/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog;

import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.derby.iapi.db.ConsistencyChecker;
import org.apache.derby.iapi.db.Factory;
import org.apache.derby.iapi.db.PropertyInfo;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedDatabaseMetaData;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.load.Export;
import org.apache.derby.impl.load.Import;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINSortPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINStatementDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINStatementTimingsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINTableDescriptor;
import org.apache.derby.impl.sql.execute.JarUtil;
import org.apache.derby.jdbc.InternalDriver;

public class SystemProcedures {
    private static final int SQL_BEST_ROWID = 1;
    private static final int SQL_ROWVER = 2;
    private static final String DRIVER_TYPE_OPTION = "DATATYPE";
    private static final String ODBC_DRIVER_OPTION = "'ODBC'";
    public static final String SQLERRMC_MESSAGE_DELIMITER = new String(new char[]{'\u0014', '\u0014', '\u0014'});
    private static final double LOG10 = StrictMath.log(10.0);

    public static void SQLCAMESSAGE(int n, short s, String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, String string3, String string4, String string5, String string6, String[] stringArray, int[] nArray) {
        int n8 = 1;
        int n9 = 0;
        while (string.indexOf(SQLERRMC_MESSAGE_DELIMITER, n9) != -1) {
            n9 = string.indexOf(SQLERRMC_MESSAGE_DELIMITER, n9) + SQLERRMC_MESSAGE_DELIMITER.length();
            ++n8;
        }
        if (n8 == 1) {
            MessageService.getLocalizedMessage(n, s, string, string2, n2, n3, n4, n5, n6, n7, string3, string4, string5, string6, stringArray, nArray);
        } else {
            n9 = 0;
            String[] stringArray2 = new String[2];
            for (int i = 0; i < n8; ++i) {
                int n10 = string.indexOf(SQLERRMC_MESSAGE_DELIMITER, n9);
                String string7 = i == n8 - 1 ? string.substring(n9) : string.substring(n9, n10);
                if (i > 0) {
                    string4 = string7.substring(0, 5);
                    string7 = string7.substring(6);
                    stringArray[0] = stringArray[0] + " SQLSTATE: " + string4 + ": ";
                }
                MessageService.getLocalizedMessage(n, (short)string7.length(), string7, string2, n2, n3, n4, n5, n6, n7, string3, string4, string5, string6, stringArray2, nArray);
                if (nArray[0] == 0) {
                    stringArray[0] = i == 0 ? stringArray2[0] : stringArray[0] + stringArray2[0];
                }
                n9 = n10 + SQLERRMC_MESSAGE_DELIMITER.length();
            }
        }
    }

    private static Connection getDefaultConn() throws SQLException {
        Connection connection;
        InternalDriver internalDriver = InternalDriver.activeDriver();
        if (internalDriver != null && (connection = internalDriver.connect("jdbc:default:connection", null)) != null) {
            return connection;
        }
        throw Util.noCurrentConnection();
    }

    private static DatabaseMetaData getDMD() throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        return connection.getMetaData();
    }

    public static void SQLPROCEDURES(String string, String string2, String string3, String string4, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.isForODBC(string4) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getProceduresForODBC(string, string2, string3) : SystemProcedures.getDMD().getProcedures(string, string2, string3);
    }

    public static void SQLFUNCTIONS(String string, String string2, String string3, String string4, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getFunctions(string, string2, string3);
    }

    public static void SQLTABLES(String string, String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        String string6 = SystemProcedures.getOption("GETCATALOGS", string5);
        if (string6 != null && string6.trim().equals("1")) {
            resultSetArray[0] = SystemProcedures.getDMD().getCatalogs();
            return;
        }
        string6 = SystemProcedures.getOption("GETTABLETYPES", string5);
        if (string6 != null && string6.trim().equals("1")) {
            resultSetArray[0] = SystemProcedures.getDMD().getTableTypes();
            return;
        }
        string6 = SystemProcedures.getOption("GETSCHEMAS", string5);
        if (string6 != null) {
            if ((string6 = string6.trim()).equals("1")) {
                resultSetArray[0] = SystemProcedures.getDMD().getSchemas();
                return;
            }
            if (string6.equals("2")) {
                EmbedDatabaseMetaData embedDatabaseMetaData = (EmbedDatabaseMetaData)SystemProcedures.getDMD();
                resultSetArray[0] = embedDatabaseMetaData.getSchemas(string, string2);
                return;
            }
        }
        String[] stringArray = null;
        if (string4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "',");
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
        resultSetArray[0] = SystemProcedures.getDMD().getTables(string, string2, string3, stringArray);
    }

    public static void SQLFOREIGNKEYS(String string, String string2, String string3, String string4, String string5, String string6, String string7, ResultSet[] resultSetArray) throws SQLException {
        String string8 = SystemProcedures.getOption("EXPORTEDKEY", string7);
        String string9 = SystemProcedures.getOption("IMPORTEDKEY", string7);
        resultSetArray[0] = string9 != null && string9.trim().equals("1") ? SystemProcedures.getDMD().getImportedKeys(string4, string5, string6) : (string8 != null && string8.trim().equals("1") ? SystemProcedures.getDMD().getExportedKeys(string, string2, string3) : (SystemProcedures.isForODBC(string7) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getCrossReferenceForODBC(string, string2, string3, string4, string5, string6) : SystemProcedures.getDMD().getCrossReference(string, string2, string3, string4, string5, string6)));
    }

    private static String getOption(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.lastIndexOf(string);
        if (n < 0) {
            return null;
        }
        int n2 = string2.indexOf(61, n);
        if (n2 < 0) {
            return null;
        }
        int n3 = string2.indexOf(59, n2);
        if (n3 < 0) {
            return string2.substring(n2 + 1);
        }
        return string2.substring(n2 + 1, n3);
    }

    public static void SQLPROCEDURECOLS(String string, String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.isForODBC(string5) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getProcedureColumnsForODBC(string, string2, string3, string4) : SystemProcedures.getDMD().getProcedureColumns(string, string2, string3, string4);
    }

    public static void SQLFUNCTIONPARAMS(String string, String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getFunctionColumns(string, string2, string3, string4);
    }

    public static void SQLCOLUMNS(String string, String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.isForODBC(string5) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getColumnsForODBC(string, string2, string3, string4) : SystemProcedures.getDMD().getColumns(string, string2, string3, string4);
    }

    public static void SQLCOLPRIVILEGES(String string, String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getColumnPrivileges(string, string2, string3, string4);
    }

    public static void SQLTABLEPRIVILEGES(String string, String string2, String string3, String string4, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getTablePrivileges(string, string2, string3);
    }

    public static void SQLPRIMARYKEYS(String string, String string2, String string3, String string4, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getPrimaryKeys(string, string2, string3);
    }

    public static void SQLGETTYPEINFO(short s, String string, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.isForODBC(string) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getTypeInfoForODBC() : SystemProcedures.getDMD().getTypeInfo();
    }

    public static void SQLSTATISTICS(String string, String string2, String string3, short s, short s2, String string4, ResultSet[] resultSetArray) throws SQLException {
        boolean bl = s == 0;
        boolean bl2 = s2 == 1;
        resultSetArray[0] = SystemProcedures.isForODBC(string4) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getIndexInfoForODBC(string, string2, string3, bl, bl2) : SystemProcedures.getDMD().getIndexInfo(string, string2, string3, bl, bl2);
    }

    public static void SQLSPECIALCOLUMNS(short s, String string, String string2, String string3, short s2, short s3, String string4, ResultSet[] resultSetArray) throws SQLException {
        boolean bl;
        boolean bl2 = bl = s3 == 1;
        resultSetArray[0] = s == 1 ? (SystemProcedures.isForODBC(string4) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getBestRowIdentifierForODBC(string, string2, string3, s2, bl) : SystemProcedures.getDMD().getBestRowIdentifier(string, string2, string3, s2, bl)) : (SystemProcedures.isForODBC(string4) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getVersionColumnsForODBC(string, string2, string3) : SystemProcedures.getDMD().getVersionColumns(string, string2, string3));
    }

    public static void SQLUDTS(String string, String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        int[] nArray = null;
        if (string4 != null && string4.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, " \t\n\t,");
            int n = stringTokenizer.countTokens();
            nArray = new int[n];
            String string6 = "";
            try {
                for (int i = 0; i < n; ++i) {
                    string6 = stringTokenizer.nextToken();
                    nArray[i] = Integer.parseInt(string6);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Invalid type, " + string6 + ", passed to getUDTs.");
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new SQLException("Internal failure: NoSuchElementException in getUDTs.");
            }
        }
        resultSetArray[0] = SystemProcedures.getDMD().getUDTs(string, string2, string3, nArray);
    }

    public static void METADATA(ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getClientCachedMetaData();
    }

    private static boolean isForODBC(String string) {
        String string2 = SystemProcedures.getOption(DRIVER_TYPE_OPTION, string);
        return string2 != null && string2.toUpperCase().equals(ODBC_DRIVER_OPTION);
    }

    public static void SYSCS_SET_DATABASE_PROPERTY(String string, String string2) throws SQLException {
        PropertyInfo.setDatabaseProperty(string, string2);
    }

    public static String SYSCS_GET_DATABASE_PROPERTY(String string) throws SQLException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        try {
            return PropertyUtil.getDatabaseProperty(languageConnectionContext.getTransactionExecute(), string);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void SYSCS_UPDATE_STATISTICS(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("alter table ");
        stringBuffer.append(SystemProcedures.basicSchemaTableValidation(string, string2));
        if (string3 != null && string3.length() == 0) {
            throw PublicAPI.wrapStandardException(StandardException.newException("42X65", string3));
        }
        if (string3 == null) {
            stringBuffer.append(" all update statistics ");
        } else {
            stringBuffer.append(" update statistics " + IdUtil.normalToDelimited(string3));
        }
        Connection connection = SystemProcedures.getDefaultConn();
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    private static String basicSchemaTableValidation(String string, String string2) throws SQLException {
        if (string != null && string.length() == 0) {
            throw PublicAPI.wrapStandardException(StandardException.newException("42Y07", string));
        }
        if (string2 == null || string2.length() == 0) {
            throw PublicAPI.wrapStandardException(StandardException.newException("42X05", string2));
        }
        return IdUtil.mkQualifiedName(string, string2);
    }

    public static void SYSCS_COMPRESS_TABLE(String string, String string2, short s) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("alter table ");
        stringBuffer.append(SystemProcedures.basicSchemaTableValidation(string, string2));
        stringBuffer.append(" compress" + (s != 0 ? " sequential" : ""));
        Connection connection = SystemProcedures.getDefaultConn();
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void SYSCS_FREEZE_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().freeze();
    }

    public static void SYSCS_UNFREEZE_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().unfreeze();
    }

    public static void SYSCS_CHECKPOINT_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().checkpoint();
    }

    public static void SYSCS_BACKUP_DATABASE(String string) throws SQLException {
        Factory.getDatabaseOfConnection().backup(string, true);
    }

    public static void SYSCS_BACKUP_DATABASE_NOWAIT(String string) throws SQLException {
        Factory.getDatabaseOfConnection().backup(string, false);
    }

    public static void SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(String string, short s) throws SQLException {
        Factory.getDatabaseOfConnection().backupAndEnableLogArchiveMode(string, s != 0, true);
    }

    public static void SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT(String string, short s) throws SQLException {
        Factory.getDatabaseOfConnection().backupAndEnableLogArchiveMode(string, s != 0, false);
    }

    public static void SYSCS_DISABLE_LOG_ARCHIVE_MODE(short s) throws SQLException {
        Factory.getDatabaseOfConnection().disableLogArchiveMode(s != 0);
    }

    public static void SYSCS_SET_RUNTIMESTATISTICS(short s) throws SQLException {
        ConnectionUtil.getCurrentLCC().setRunTimeStatisticsMode(s != 0);
    }

    public static void SYSCS_SET_STATISTICS_TIMING(short s) throws SQLException {
        ConnectionUtil.getCurrentLCC().setStatisticsTiming(s != 0);
    }

    public static int SYSCS_CHECK_TABLE(String string, String string2) throws SQLException {
        boolean bl = ConsistencyChecker.checkTable(string, string2);
        return bl ? 1 : 0;
    }

    public static void SYSCS_INPLACE_COMPRESS_TABLE(String string, String string2, short s, short s2, short s3) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        try {
            object3 = languageConnectionContext.getDataDictionary();
            object2 = object3.getSchemaDescriptor(string, transactionController, true);
            object = object3.getTableDescriptor(string2, (SchemaDescriptor)object2, transactionController);
            if (object != null && ((TableDescriptor)object).getTableType() == 5) {
                return;
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
        object3 = IdUtil.normalToDelimited(string);
        object2 = IdUtil.normalToDelimited(string2);
        object = "alter table " + (String)object3 + "." + (String)object2 + " compress inplace" + (s != 0 ? " purge" : "") + (s2 != 0 ? " defragment" : "") + (s3 != 0 ? " truncate_end" : "");
        Connection connection = SystemProcedures.getDefaultConn();
        PreparedStatement preparedStatement = connection.prepareStatement((String)object);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static String SYSCS_GET_RUNTIMESTATISTICS() throws SQLException {
        RunTimeStatistics runTimeStatistics = ConnectionUtil.getCurrentLCC().getRunTimeStatisticsObject();
        if (runTimeStatistics == null) {
            return null;
        }
        return runTimeStatistics.toString();
    }

    public static void INSTALL_JAR(String string, String string2, int n) throws SQLException {
        try {
            String string3;
            String string4;
            LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
            String[] stringArray = IdUtil.parseMultiPartSQLIdentifier(string2.trim());
            if (stringArray.length == 1) {
                string4 = languageConnectionContext.getCurrentSchemaName();
                string3 = stringArray[0];
            } else {
                string4 = stringArray[0];
                string3 = stringArray[1];
            }
            SystemProcedures.checkJarSQLName(string3);
            JarUtil.install(languageConnectionContext, string4, string3, string);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void REPLACE_JAR(String string, String string2) throws SQLException {
        try {
            String string3;
            String string4;
            LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
            String[] stringArray = IdUtil.parseMultiPartSQLIdentifier(string2.trim());
            if (stringArray.length == 1) {
                string4 = languageConnectionContext.getCurrentSchemaName();
                string3 = stringArray[0];
            } else {
                string4 = stringArray[0];
                string3 = stringArray[1];
            }
            SystemProcedures.checkJarSQLName(string3);
            JarUtil.replace(languageConnectionContext, string4, string3, string);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void REMOVE_JAR(String string, int n) throws SQLException {
        try {
            String string2;
            String string3;
            LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
            String[] stringArray = IdUtil.parseMultiPartSQLIdentifier(string.trim());
            if (stringArray.length == 1) {
                string3 = languageConnectionContext.getCurrentSchemaName();
                string2 = stringArray[0];
            } else {
                string3 = stringArray[0];
                string2 = stringArray[1];
            }
            SystemProcedures.checkJarSQLName(string2);
            JarUtil.drop(languageConnectionContext, string3, string2);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    private static void checkJarSQLName(String string) throws StandardException {
        if (string.length() == 0 || string.indexOf(58) != -1) {
            throw StandardException.newException("XCXA0.S");
        }
    }

    public static void SYSCS_EXPORT_TABLE(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        Export.exportTable(connection, string, string2, string3, string4, string5, string6);
        connection.commit();
    }

    public static void SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        Export.exportTable(connection, string, string2, string3, string4, string5, string6, string7);
        connection.commit();
    }

    public static void SYSCS_EXPORT_QUERY(String string, String string2, String string3, String string4, String string5) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        Export.exportQuery(connection, string, string2, string3, string4, string5);
        connection.commit();
    }

    public static void SYSCS_EXPORT_QUERY_LOBS_TO_EXTFILE(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        Export.exportQuery(connection, string, string2, string3, string4, string5, string6);
        connection.commit();
    }

    public static void SYSCS_IMPORT_TABLE(String string, String string2, String string3, String string4, String string5, String string6, short s) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        try {
            Import.importTable(connection, string, string2, string3, string4, string5, string6, s, false);
        }
        catch (SQLException sQLException) {
            SystemProcedures.rollBackAndThrowSQLException(connection, sQLException);
        }
        connection.commit();
    }

    private static void rollBackAndThrowSQLException(Connection connection, SQLException sQLException) throws SQLException {
        try {
            connection.rollback();
        }
        catch (SQLException sQLException2) {
            sQLException.setNextException(sQLException2);
        }
        throw sQLException;
    }

    public static void SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE(String string, String string2, String string3, String string4, String string5, String string6, short s) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        try {
            Import.importTable(connection, string, string2, string3, string4, string5, string6, s, true);
        }
        catch (SQLException sQLException) {
            SystemProcedures.rollBackAndThrowSQLException(connection, sQLException);
        }
        connection.commit();
    }

    public static void SYSCS_IMPORT_DATA(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, short s) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        try {
            Import.importData(connection, string, string2, string3, string4, string5, string6, string7, string8, s, false);
        }
        catch (SQLException sQLException) {
            SystemProcedures.rollBackAndThrowSQLException(connection, sQLException);
        }
        connection.commit();
    }

    public static void SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, short s) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        try {
            Import.importData(connection, string, string2, string3, string4, string5, string6, string7, string8, s, true);
        }
        catch (SQLException sQLException) {
            SystemProcedures.rollBackAndThrowSQLException(connection, sQLException);
        }
        connection.commit();
    }

    public static void SYSCS_BULK_INSERT(String string, String string2, String string3, String string4) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        String string5 = IdUtil.mkQualifiedName(string, string2);
        String string6 = "insert into " + string5 + " --DERBY-PROPERTIES insertMode=bulkInsert \n" + "select * from new " + IdUtil.normalToDelimited(string3) + "(" + StringUtil.quoteStringLiteral(string) + ", " + StringUtil.quoteStringLiteral(string2) + ", " + StringUtil.quoteStringLiteral(string4) + ")" + " as t";
        PreparedStatement preparedStatement = connection.prepareStatement(string6);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public static void SYSCS_RELOAD_SECURITY_POLICY() throws SQLException {
        if (System.getSecurityManager() == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Policy.getPolicy().refresh();
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            throw Util.policyNotReloaded(securityException);
        }
    }

    public static double PI() {
        return Math.PI;
    }

    public static double LOG10(double d) {
        return StrictMath.log(d) / LOG10;
    }

    public static double COT(double d) {
        return 1.0 / StrictMath.tan(d);
    }

    public static double COSH(double d) {
        return (StrictMath.exp(d) + StrictMath.exp(-d)) / 2.0;
    }

    public static double SINH(double d) {
        return (StrictMath.exp(d) - StrictMath.exp(-d)) / 2.0;
    }

    public static double TANH(double d) {
        return (StrictMath.exp(d) - StrictMath.exp(-d)) / (StrictMath.exp(d) + StrictMath.exp(-d));
    }

    public static int SIGN(double d) {
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public static double RAND(int n) {
        return new Random(n).nextDouble();
    }

    public static void SYSCS_SET_USER_ACCESS(String string, String string2) throws SQLException {
        try {
            String string3;
            if (string == null) {
                throw StandardException.newException("28502", string);
            }
            if ("FULLACCESS".equals(string2)) {
                string3 = "derby.database.fullAccessUsers";
            } else if ("READONLYACCESS".equals(string2)) {
                string3 = "derby.database.readOnlyAccessUsers";
            } else if (string2 == null) {
                string3 = null;
            } else {
                throw StandardException.newException("XCZ00.S", string2);
            }
            SystemProcedures.removeFromAccessList("derby.database.fullAccessUsers", string);
            SystemProcedures.removeFromAccessList("derby.database.readOnlyAccessUsers", string);
            if (string3 != null) {
                String string4 = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY(string3);
                SystemProcedures.SYSCS_SET_DATABASE_PROPERTY(string3, IdUtil.appendNormalToList(string, string4));
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    private static void removeFromAccessList(String string, String string2) throws SQLException, StandardException {
        String string3 = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY(string);
        if (string3 != null) {
            SystemProcedures.SYSCS_SET_DATABASE_PROPERTY(string, IdUtil.deleteId(string2, string3));
        }
    }

    public static String SYSCS_GET_USER_ACCESS(String string) throws SQLException {
        try {
            if (string == null) {
                throw StandardException.newException("28502", string);
            }
            String string2 = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY("derby.database.fullAccessUsers");
            if (IdUtil.idOnList(string, string2)) {
                return "FULLACCESS";
            }
            String string3 = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY("derby.database.readOnlyAccessUsers");
            if (IdUtil.idOnList(string, string3)) {
                return "READONLYACCESS";
            }
            String string4 = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY("derby.database.defaultConnectionMode");
            string4 = string4 != null ? StringUtil.SQLToUpperCase(string4) : "FULLACCESS";
            return string4;
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void SYSCS_EMPTY_STATEMENT_CACHE() throws SQLException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        CacheManager cacheManager = languageConnectionContext.getLanguageConnectionFactory().getStatementCache();
        if (cacheManager != null) {
            cacheManager.ageOut();
        }
    }

    public static void SYSCS_SET_XPLAIN_MODE(int n) throws SQLException, StandardException {
        ConnectionUtil.getCurrentLCC().setXplainOnlyMode(n != 0);
    }

    public static int SYSCS_GET_XPLAIN_MODE() throws SQLException, StandardException {
        return ConnectionUtil.getCurrentLCC().getXplainOnlyMode() ? 1 : 0;
    }

    public static void SYSCS_SET_XPLAIN_SCHEMA(String string) throws SQLException, StandardException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        if (string == null || string.trim().length() == 0) {
            languageConnectionContext.setXplainSchema(null);
            return;
        }
        boolean bl = languageConnectionContext.getRunTimeStatisticsMode();
        languageConnectionContext.setRunTimeStatisticsMode(false);
        SystemProcedures.createXplainSchema(string);
        SystemProcedures.createXplainTable(languageConnectionContext, string, new XPLAINStatementDescriptor());
        SystemProcedures.createXplainTable(languageConnectionContext, string, new XPLAINStatementTimingsDescriptor());
        SystemProcedures.createXplainTable(languageConnectionContext, string, new XPLAINResultSetDescriptor());
        SystemProcedures.createXplainTable(languageConnectionContext, string, new XPLAINResultSetTimingsDescriptor());
        SystemProcedures.createXplainTable(languageConnectionContext, string, new XPLAINScanPropsDescriptor());
        SystemProcedures.createXplainTable(languageConnectionContext, string, new XPLAINSortPropsDescriptor());
        languageConnectionContext.setRunTimeStatisticsMode(bl);
        languageConnectionContext.setXplainSchema(string);
    }

    private static boolean hasSchema(Connection connection, String string) throws SQLException {
        ResultSet resultSet = connection.getMetaData().getSchemas();
        boolean bl = false;
        while (resultSet.next() && !bl) {
            bl = string.equals(resultSet.getString("TABLE_SCHEM"));
        }
        resultSet.close();
        return bl;
    }

    private static boolean hasTable(Connection connection, String string, String string2) throws SQLException {
        ResultSet resultSet = connection.getMetaData().getTables(null, string, string2, new String[]{"TABLE"});
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    private static void createXplainSchema(String string) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        if (!SystemProcedures.hasSchema(connection, string)) {
            String string2 = IdUtil.normalToDelimited(string);
            Statement statement = connection.createStatement();
            statement.executeUpdate("CREATE SCHEMA " + string2);
            statement.close();
        }
        connection.close();
    }

    private static void createXplainTable(LanguageConnectionContext languageConnectionContext, String string, XPLAINTableDescriptor xPLAINTableDescriptor) throws SQLException {
        Object object;
        String[] stringArray = xPLAINTableDescriptor.getTableDDL(string);
        Connection connection = SystemProcedures.getDefaultConn();
        if (!SystemProcedures.hasTable(connection, string, xPLAINTableDescriptor.getCatalogName())) {
            object = connection.createStatement();
            for (int i = 0; i < stringArray.length; ++i) {
                object.executeUpdate(stringArray[i]);
            }
            object.close();
        }
        object = xPLAINTableDescriptor.getTableInsert();
        connection.prepareStatement((String)object).close();
        connection.close();
        languageConnectionContext.setXplainStatement(xPLAINTableDescriptor.getCatalogName(), object);
    }

    public static String SYSCS_GET_XPLAIN_SCHEMA() throws SQLException, StandardException {
        String string = ConnectionUtil.getCurrentLCC().getXplainSchema();
        if (string == null) {
            return "";
        }
        return string;
    }
}

