/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.openide.execution.ExecutionEngine;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class NbClassPath
implements Serializable {
    static final long serialVersionUID = -8458093409814321744L;
    private Object[] items;
    private String classpath;

    public NbClassPath(String[] stringArray) {
        this.items = stringArray;
    }

    public NbClassPath(File[] fileArray) {
        this.items = fileArray;
    }

    private NbClassPath(Object[] objectArray) {
        this.items = objectArray;
    }

    public NbClassPath(String string) {
        this.items = new Exception[0];
        this.classpath = string;
        if (string.indexOf(32) >= 0) {
            if (string.startsWith("\"")) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(0, '\"');
            stringBuffer.append('\"');
            this.classpath = stringBuffer.toString();
        }
    }

    public static NbClassPath createRepositoryPath() {
        Thread.dumpStack();
        return NbClassPath.createRepositoryPath(FileSystemCapability.ALL);
    }

    public static NbClassPath createRepositoryPath(FileSystemCapability fileSystemCapability) {
        Thread.dumpStack();
        LinkedList<EnvironmentNotSupportedException> linkedList = new LinkedList<EnvironmentNotSupportedException>();
        final class Env
        extends FileSystem.Environment {
            final /* synthetic */ LinkedList val$res;

            Env(LinkedList linkedList) {
                this.val$res = linkedList;
            }

            public void addClassPath(String string) {
                this.val$res.add(string);
            }
        }
        Env env = new Env(linkedList);
        Enumeration enumeration = fileSystemCapability.fileSystems();
        while (enumeration.hasMoreElements()) {
            try {
                FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                fileSystem.prepareEnvironment((FileSystem.Environment)env);
            }
            catch (EnvironmentNotSupportedException environmentNotSupportedException) {
                linkedList.add(environmentNotSupportedException);
            }
        }
        return new NbClassPath(linkedList.toArray());
    }

    public static NbClassPath createLibraryPath() {
        Thread.dumpStack();
        ExecutionEngine executionEngine = (ExecutionEngine)Lookup.getDefault().lookup(ExecutionEngine.class);
        if (executionEngine != null) {
            return executionEngine.createLibraryPath();
        }
        return new NbClassPath(new File[0]);
    }

    public static NbClassPath createClassPath() {
        Thread.dumpStack();
        String string = System.getProperty("java.class.path");
        if (string == null || string.length() == 0) {
            return new NbClassPath("");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.endsWith("openide-compat.jar")) continue;
            if (bl) {
                stringBuffer.append(File.pathSeparatorChar);
            } else {
                bl = true;
            }
            stringBuffer.append(string2);
        }
        return new NbClassPath(stringBuffer.toString());
    }

    public static NbClassPath createBootClassPath() {
        Thread.dumpStack();
        String string = System.getProperty("sun.boot.class.path");
        StringBuffer stringBuffer = string != null ? new StringBuffer(string) : new StringBuffer();
        String string2 = System.getProperty("java.ext.dirs");
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                for (int i = 0; i < fileArray.length; ++i) {
                    String string3 = fileArray[i].getName().toLowerCase(Locale.US);
                    if (!string3.endsWith(".zip") && !string3.endsWith(".jar")) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(fileArray[i].getPath());
                }
            }
        }
        return new NbClassPath(stringBuffer.toString());
    }

    public static File toFile(FileObject fileObject) {
        Thread.dumpStack();
        return FileUtil.toFile((FileObject)fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception[] getExceptions() {
        try {
            return (Exception[])this.items;
        }
        catch (ClassCastException classCastException) {
            NbClassPath nbClassPath = this;
            synchronized (nbClassPath) {
                this.getClassPath();
                int n = 0;
                for (int i = 0; i < this.items.length; ++i) {
                    if (this.items[i] == null) continue;
                    this.items[n++] = this.items[i];
                }
                Exception[] exceptionArray = new Exception[n];
                System.arraycopy(this.items, 0, exceptionArray, 0, n);
                this.items = exceptionArray;
                return exceptionArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassPath() {
        if (this.classpath != null) {
            return this.classpath;
        }
        NbClassPath nbClassPath = this;
        synchronized (nbClassPath) {
            if (this.classpath != null) {
                return this.classpath;
            }
            if (this.items.length == 0) {
                this.classpath = "";
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            for (int i = 0; i < this.items.length; ++i) {
                Object object = this.items[i];
                if (object == null || !(object instanceof String) && !(object instanceof File)) continue;
                if (bl) {
                    stringBuffer.append(File.pathSeparatorChar);
                } else {
                    bl = true;
                }
                stringBuffer.append(object.toString());
                this.items[i] = null;
            }
            String string = stringBuffer.toString();
            if (string.indexOf(32) >= 0) {
                stringBuffer.insert(0, '\"');
                stringBuffer.append('\"');
                this.classpath = stringBuffer.toString();
            } else {
                this.classpath = string;
            }
            return this.classpath;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof NbClassPath)) {
            return false;
        }
        NbClassPath nbClassPath = (NbClassPath)object;
        return this.getClassPath().equals(nbClassPath.getClassPath());
    }
}

