/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.ui.misc.ProgressCircle;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JComponent;

public class ProgressComponent
extends JComponent {
    public static final int DEFAULT_REFRESH_INTERVAL = 200;
    private static final long serialVersionUID = -3477843728563083684L;
    private static final double ROTATION_TIME = 5000.0;
    private final long m_startTime = System.currentTimeMillis();
    private final ProgressCircle m_pc = new ProgressCircle();
    private Image m_image;
    private boolean m_inProgress = false;

    public ProgressComponent() {
        this.m_pc.setInnerOuterRatio((double)0.85f);
        this.m_pc.setOpaque(false);
    }

    private void drawBackground(Graphics g) {
        if (this.m_image != null) {
            g.drawImage(this.m_image, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.m_image.getWidth(null), this.m_image.getHeight(null), null);
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.drawBackground(g);
        if (this.isInProgress()) {
            this.drawProgressCircle(g);
        }
    }

    private void drawProgressCircle(Graphics g) {
        long diff = System.currentTimeMillis() - this.m_startTime;
        int angle = (int)Math.round(360.0 * (double)diff / 5000.0);
        this.m_pc.setSize(this.getWidth(), this.getHeight());
        this.m_pc.setAngle(angle);
        this.m_pc.paint(g);
    }

    public void setNewImage(Image image) {
        this.m_image = image;
    }

    public void setInProgress(boolean inProgress) {
        this.m_inProgress = inProgress;
    }

    public boolean isInProgress() {
        return this.m_inProgress;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new IOException("You should not serialize instances of " + this.getClass().getName());
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        throw new IOException("You should not serialize instances of " + this.getClass().getName());
    }
}

