/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class CertificateHostnameVerifier
implements HostnameVerifier {
    private static HashSet hashSet = new HashSet();

    public boolean verify(String string, SSLSession sSLSession) {
        Object object;
        X509Certificate x509Certificate;
        Object object2;
        String string2 = ResourceManager.getMessage("https.dialog.unknown.host");
        try {
            int n;
            object2 = sSLSession.getPeerCertificates();
            if (!(object2[0] instanceof X509Certificate)) {
                throw new SSLPeerUnverifiedException("");
            }
            x509Certificate = (X509Certificate)object2[0];
            object = x509Certificate.getSubjectDN().getName();
            if (object != null && (n = ((String)object).toUpperCase().indexOf("CN=")) != -1) {
                int n2 = ((String)object).indexOf(",", n);
                string2 = n2 != -1 ? ((String)object).substring(n + 3, n2) : ((String)object).substring(n + 3);
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
        object2 = CertUtils.getServername(x509Certificate);
        if (CertUtils.checkWildcardDomainList(string, (ArrayList)object2)) {
            return true;
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            Object[] objectArray = (Object[])object.next();
            if (!objectArray[0].toString().equalsIgnoreCase(string) || !objectArray[1].toString().equalsIgnoreCase(string2)) continue;
            return true;
        }
        return this.showHostnameMismatchDialog(string, string2);
    }

    private boolean showHostnameMismatchDialog(String string, String string2) {
        String string3 = ResourceManager.getMessage("https.dialog.caption");
        String string4 = ResourceManager.getMessage("https.dialog.masthead");
        AppInfo appInfo = new AppInfo(0, string, string2, null, null, null, null, false, false, null, null);
        String string5 = ResourceManager.getMessage("security.dialog.signed.buttonContinue");
        String string6 = ResourceManager.getMessage("security.dialog.signed.buttonCancel");
        ToolkitStore.getUI();
        int n = -1;
        MessageFormat messageFormat = new MessageFormat(ResourceManager.getMessage("security.dialog.hostname.mismatch.sub"));
        Object[] objectArray = new Object[]{string, string2};
        String[] stringArray = new String[]{messageFormat.format(objectArray)};
        if (!Trace.isAutomationEnabled()) {
            if (Config.getBooleanProperty("deployment.security.jsse.hostmismatch.warning")) {
                n = ToolkitStore.getUI().showSecurityDialog(appInfo, string3, string4, string2, null, false, false, string5, string6, stringArray, null, false, null, -1, -1, false);
            } else {
                ToolkitStore.getUI();
                n = 0;
            }
        } else {
            Trace.msgSecurityPrintln("hostnameverifier.automation.ignoremismatch");
            ToolkitStore.getUI();
            n = 0;
        }
        ToolkitStore.getUI();
        if (n == 0) {
            Object[] objectArray2 = new Object[]{string, string2};
            hashSet.add(objectArray2);
        }
        ToolkitStore.getUI();
        return n == 0;
    }

    public static void reset() {
        hashSet.clear();
    }
}

