/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.BadLocationException;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.ClassRewriter;
import org.netbeans.lib.profiler.instrumentation.DynamicConstantPoolExtension;
import org.netbeans.lib.profiler.instrumentation.InstrumentationFactory;
import org.netbeans.lib.profiler.utils.MiscUtils;

public class CodeRegionMethodInstrumentor
extends ClassManager {
    private ClientUtils.SourceCodeSelection sourceCodeSelection;
    private ArrayList instrClasses;
    private String className;
    private int nInstrClasses;

    public CodeRegionMethodInstrumentor(ProfilingSessionStatus profilingSessionStatus, ClientUtils.SourceCodeSelection sourceCodeSelection) {
        super(profilingSessionStatus);
        this.sourceCodeSelection = sourceCodeSelection;
        this.className = this.sourceCodeSelection.getClassName().replace('.', '/').intern();
        this.instrClasses = new ArrayList();
    }

    public Object[] getFollowUpInstrumentCodeRegionResponse(int n) {
        DynamicClassInfo dynamicClassInfo = CodeRegionMethodInstrumentor.javaClassForName(this.className, n);
        this.instrClasses.clear();
        this.instrClasses.add(dynamicClassInfo);
        this.nInstrClasses = 1;
        return this.createInstrumentedMethodPack();
    }

    protected Object[] createInstrumentedMethodPack() {
        if (this.nInstrClasses == 0) {
            return null;
        }
        return this.createInstrumentedMethodPack15();
    }

    Object[] getInitialInstrumentCodeRegionResponse(String[] stringArray, int[] nArray) {
        DynamicClassInfo dynamicClassInfo = null;
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            ClassRepository.CodeRegionBCI codeRegionBCI;
            String string = stringArray[i].replace('.', '/').intern();
            if (this.className != string || (dynamicClassInfo = CodeRegionMethodInstrumentor.javaClassForName(stringArray[i], nArray[i])) == null || (codeRegionBCI = this.computeCodeRegionFromSourceCodeSelection(dynamicClassInfo)) == null || (n = dynamicClassInfo.getMethodIndex(codeRegionBCI.methodName, codeRegionBCI.methodSignature)) == -1) continue;
            dynamicClassInfo.setLoaded(true);
            this.instrClasses.add(dynamicClassInfo);
        }
        this.nInstrClasses = this.instrClasses.size();
        return this.createInstrumentedMethodPack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassRepository.CodeRegionBCI computeCodeRegionFromSourceCodeSelection(ClassInfo classInfo) {
        try {
            if (this.sourceCodeSelection.definedViaSourceLines()) {
                int n = this.sourceCodeSelection.getStartLine();
                int n2 = this.sourceCodeSelection.getEndLine();
                ClassRepository.CodeRegionBCI codeRegionBCI = ClassRepository.getMethodForSourceRegion(classInfo, n, n2);
                this.status.beginTrans(true);
                try {
                    this.status.setInstrMethodNames(new String[]{codeRegionBCI.methodName});
                    this.status.setInstrMethodSignatures(new String[]{codeRegionBCI.methodSignature});
                }
                finally {
                    this.status.endTrans();
                }
                return codeRegionBCI;
            }
            if (this.sourceCodeSelection.definedViaMethodName()) {
                String string = this.sourceCodeSelection.getMethodName();
                String string2 = this.sourceCodeSelection.getMethodSignature();
                return ClassRepository.getMethodMinAndMaxBCI(classInfo, string, string2);
            }
        }
        catch (IOException iOException) {
            MiscUtils.printErrorMessage(iOException.getMessage());
        }
        catch (BadLocationException badLocationException) {
            MiscUtils.printErrorMessage(badLocationException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            MiscUtils.printErrorMessage(classNotFoundException.getMessage());
        }
        return null;
    }

    private Object[] createInstrumentedMethodPack15() {
        String[] stringArray = new String[this.nInstrClasses];
        int[] nArray = new int[this.nInstrClasses];
        byte[][] byArrayArray = new byte[this.nInstrClasses][];
        for (int i = 0; i < this.nInstrClasses; ++i) {
            int n;
            DynamicClassInfo dynamicClassInfo = (DynamicClassInfo)this.instrClasses.get(i);
            stringArray[i] = dynamicClassInfo.getName().replace('/', '.');
            nArray[i] = dynamicClassInfo.getLoaderId();
            ClassRepository.CodeRegionBCI codeRegionBCI = this.computeCodeRegionFromSourceCodeSelection(dynamicClassInfo);
            int n2 = dynamicClassInfo.getMethodIndex(codeRegionBCI.methodName, codeRegionBCI.methodSignature);
            dynamicClassInfo.setMethodInstrumented(n2);
            DynamicConstantPoolExtension dynamicConstantPoolExtension = DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, 8);
            byte[] byArray = InstrumentationFactory.instrumentCodeRegion(dynamicClassInfo, n2, codeRegionBCI.bci0, codeRegionBCI.bci1);
            int n3 = dynamicClassInfo.getMethodNames().length;
            byte[][] byArrayArray2 = new byte[n3][];
            for (n = 0; n < n3; ++n) {
                byArrayArray2[n] = dynamicClassInfo.getMethodInfo(n);
            }
            byArrayArray2[n2] = byArray;
            n = dynamicConstantPoolExtension.getNEntries();
            byte[] byArray2 = dynamicConstantPoolExtension.getContents();
            byArrayArray[i] = ClassRewriter.rewriteClassFile(dynamicClassInfo, byArrayArray2, n, byArray2);
        }
        return new Object[]{stringArray, nArray, byArrayArray};
    }
}

