/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.utils;

import java.io.File;
import java.io.Serializable;
import java.security.Permission;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenSupport;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.openide.util.Lookup;

public class FileChangedManager
extends SecurityManager {
    private static final Logger LOG = Logger.getLogger(FileChangedManager.class.getName());
    private static final boolean isFine = LOG.isLoggable(Level.FINE);
    private static final boolean isFiner = LOG.isLoggable(Level.FINER);
    private static FileChangedManager INSTANCE;
    private static final int CREATE_HINT = 2;
    private static final int DELETE_HINT = 1;
    private static final int AMBIGOUS_HINT = 3;
    private final ConcurrentHashMap<Integer, Integer> hints = new ConcurrentHashMap();
    private long shrinkTime = System.currentTimeMillis();
    private static volatile long ioTime;
    private static volatile int ioLoad;
    private static final AtomicInteger priorityIO;
    private static final ThreadLocal<Integer> IDLE_IO;
    private static final ThreadLocal<Runnable> IDLE_CALL;
    private static final ThreadLocal<AtomicBoolean> IDLE_ON;

    public FileChangedManager() {
        if (isFine) {
            LOG.fine("Initializing FileChangedManager");
        }
    }

    public static synchronized FileChangedManager getInstance() {
        if (INSTANCE == null && (INSTANCE = (FileChangedManager)Lookup.getDefault().lookup(FileChangedManager.class)) == null) {
            INSTANCE = new FileChangedManager();
        }
        return INSTANCE;
    }

    static void assertNoLock() {
        assert (!Thread.holdsLock(IDLE_CALL));
        assert (!Thread.holdsLock(IDLE_IO));
        assert (!Thread.holdsLock(IDLE_ON));
    }

    @Override
    public void checkPermission(Permission permission) {
    }

    @Override
    public void checkDelete(String string) {
        this.put(string, false);
    }

    @Override
    public void checkWrite(String string) {
        this.put(string, true);
    }

    @Override
    public void checkRead(String string) {
        FileChangedManager.pingIO(1);
    }

    @Override
    public void checkRead(String string, Object object) {
        FileChangedManager.pingIO(1);
    }

    public boolean impeachExistence(File file, boolean bl) {
        boolean bl2;
        Integer n = this.remove(FileChangedManager.getKey(file));
        boolean bl3 = bl2 = n != null;
        if (bl2) {
            if (n == 3) {
                return true;
            }
            bl2 = bl != this.toState(n);
        }
        return bl2;
    }

    public boolean exists(File file) {
        Serializable serializable;
        long l = 0L;
        assert ((l = System.currentTimeMillis()) >= Long.MIN_VALUE);
        boolean bl = file.exists();
        if (l > 0L && (l = System.currentTimeMillis() - l) > 500L) {
            String string;
            if (FileChangedManager.isIdleIO()) {
                serializable = Level.FINE;
                string = "{0} new File(\"{1}\").exists() in I/O mode";
            } else {
                serializable = Level.WARNING;
                string = "{0} ms in new File(\"{1}\").exists()";
            }
            LOG.log((Level)serializable, string, new Object[]{l, file});
        }
        serializable = FileChangedManager.getKey(file);
        this.remove((int)serializable);
        this.put((int)serializable, bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T priorityIO(Callable<T> callable) throws Exception {
        try {
            priorityIO.incrementAndGet();
            T t = callable.call();
            return t;
        }
        finally {
            priorityIO.decrementAndGet();
        }
    }

    static boolean isIdleIO() {
        return IDLE_IO.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void idleIO(int n, Runnable runnable, Runnable runnable2, AtomicBoolean atomicBoolean) {
        Integer n2 = IDLE_IO.get();
        Runnable runnable3 = IDLE_CALL.get();
        AtomicBoolean atomicBoolean2 = IDLE_ON.get();
        int n3 = n2 == null ? 0 : n2;
        try {
            IDLE_IO.set(Math.max(n, n3));
            IDLE_CALL.set(runnable2);
            IDLE_ON.set(atomicBoolean);
            runnable.run();
        }
        finally {
            IDLE_IO.set(n2);
            IDLE_CALL.set(runnable3);
            IDLE_ON.set(atomicBoolean2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitIOLoadLowerThan(int n) throws InterruptedException {
        while (true) {
            AtomicBoolean atomicBoolean;
            if ((atomicBoolean = IDLE_ON.get()) != null && !atomicBoolean.get()) {
                if (isFine) {
                    LOG.fine("Interrupting manually");
                }
                throw new InterruptedException("Interrupting manually");
            }
            int n2 = FileChangedManager.pingIO(0);
            if (n2 < n && priorityIO.get() == 0) {
                return;
            }
            if (ChildrenSupport.isLock() || Thread.holdsLock(NamingFactory.class)) {
                return;
            }
            if (FileChangedManager.isClassLoading()) {
                return;
            }
            Runnable runnable = IDLE_CALL.get();
            if (runnable != null) {
                runnable.run();
            }
            ThreadLocal<Integer> threadLocal = IDLE_IO;
            synchronized (threadLocal) {
                IDLE_IO.wait(100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int pingIO(int n) {
        Object object;
        long l = System.currentTimeMillis();
        boolean bl = false;
        while (ioTime < l) {
            ioTime += 100L;
            bl = true;
            if ((ioLoad /= 2) != 0) continue;
            ioTime = l + 100L;
            break;
        }
        if (bl) {
            object = IDLE_IO;
            synchronized (object) {
                IDLE_IO.notifyAll();
            }
        }
        if (n == 0) {
            return ioLoad;
        }
        object = IDLE_IO.get();
        if (object != null) {
            try {
                FileChangedManager.waitIOLoadLowerThan((Integer)object);
            }
            catch (InterruptedException interruptedException) {
                if (isFine) {
                    LOG.log(Level.FINE, "Interrupted {0}", interruptedException.getMessage());
                }
            }
        } else {
            ioLoad += n;
            if (isFiner) {
                LOG.log(Level.FINER, "I/O load: {0} (+{1})", new Object[]{ioLoad, n});
            }
        }
        return ioLoad;
    }

    private Integer put(int n, boolean bl) {
        FileChangedManager.pingIO(2);
        this.shrinkTime = System.currentTimeMillis();
        int n2 = this.toValue(bl);
        Integer n3 = this.hints.putIfAbsent(n, n2);
        if (n3 != null && n3 != 3 && n3 != n2) {
            this.hints.put(n, 3);
        }
        return n3;
    }

    private int toValue(boolean bl) {
        return bl ? 2 : 1;
    }

    private boolean toState(int n) {
        switch (n) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    private void shrink() {
        this.hints.keySet().clear();
    }

    private Integer remove(int n) {
        long l = System.currentTimeMillis();
        if (l - this.shrinkTime > 5000L) {
            int n2 = this.hints.size();
            if (n2 > 1500) {
                this.shrink();
            }
            this.shrinkTime = l;
        }
        return this.hints.remove(n);
    }

    private static int getKey(File file) {
        return NamingFactory.createID(file);
    }

    private static int getKey(String string) {
        return FileChangedManager.getKey(new File(string));
    }

    private Integer put(String string, boolean bl) {
        return this.put(FileChangedManager.getKey(string), bl);
    }

    private static boolean isClassLoading() {
        StackTraceElement[] stackTraceElementArray;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = new Throwable().getStackTrace()) {
            if (!stackTraceElement.getClassName().startsWith("org.netbeans.JarClassLoader") && !stackTraceElement.getClassName().startsWith("org.netbeans.ProxyClassLoader") && !stackTraceElement.getClassName().equals("java.lang.ClassLoader")) continue;
            return true;
        }
        return false;
    }

    static {
        ioTime = -1L;
        priorityIO = new AtomicInteger();
        IDLE_IO = new ThreadLocal();
        IDLE_CALL = new ThreadLocal();
        IDLE_ON = new ThreadLocal();
    }
}

