/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.packager.bundlers.IOUtils;
import com.sun.javafx.tools.packager.bundlers.WinAppBundler;
import com.sun.javafx.tools.resource.windows.WinResources;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WinExeBundler
extends Bundler {
    WinAppBundler appBundler = new WinAppBundler();
    BundleParams params;
    private File configRoot = null;
    File imageDir = null;
    private boolean menuShortcut = false;
    private boolean desktopShortcut = false;
    private static final String DEFAULT_EXE_PROJECT_TEMPLATE = "template.iss";
    private static final String TOOL_INNO_SETUP_COMPILER = "iscc.exe";
    private static final String DEFAULT_INNO_SETUP_ICON = "icon_inno_setup.bmp";

    public WinExeBundler() {
        this.baseResourceLoader = WinResources.class;
    }

    protected void setBuildRoot(File dir) {
        super.setBuildRoot(dir);
        this.configRoot = new File(dir, "windows");
        this.configRoot.mkdirs();
        this.appBundler.setBuildRoot(dir);
    }

    public void setVerbose(boolean m) {
        super.setVerbose(m);
        this.appBundler.setVerbose(m);
    }

    private static double findTool(String toolName) {
        try {
            ProcessBuilder pb = new ProcessBuilder(toolName, "/?");
            VersionExtractor ve = new VersionExtractor();
            IOUtils.exec(pb, Log.isDebug(), true, ve);
            double version = ve.getVersion();
            Log.verbose("  Detected [" + toolName + "] version [" + version + "]");
            return version;
        }
        catch (Exception e) {
            if (Log.isDebug()) {
                e.printStackTrace();
            }
            return 0.0;
        }
    }

    boolean validate(BundleParams p) throws Bundler.UnsupportedPlatformException, Bundler.ConfigException {
        if (p.type != Bundler.BundleType.ALL && p.type != Bundler.BundleType.INSTALLER || p.bundleFormat != null && !"exe".equals(p.bundleFormat)) {
            return false;
        }
        this.appBundler.doValidate(p);
        double innoVersion = WinExeBundler.findTool(TOOL_INNO_SETUP_COMPILER);
        double minVersion = 5.0;
        if (innoVersion < minVersion) {
            Log.info("Detected [iscc.exe] version " + innoVersion + " but version " + minVersion + " is required.");
            throw new Bundler.ConfigException("Can not find Inno Setup Compiler (iscc.exe).", "  Download Inno Setup 5 or later from http://www.jrsoftware.org and add it to the PATH.");
        }
        return true;
    }

    private boolean prepareProto() throws IOException {
        if (!this.appBundler.doBundle(this.params, this.imageDir, true)) {
            return false;
        }
        if (!this.params.licenseFile.isEmpty()) {
            File lfile = new File(this.params.appResources.getBaseDirectory(), this.params.licenseFile.get(0));
            IOUtils.copyFile(lfile, new File(this.imageDir, lfile.getName()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean bundle(BundleParams p, File outdir) {
        boolean configScript2;
        block21: {
            boolean bl;
            block20: {
                this.imageDir = new File(this.imagesRoot, "win-app.image");
                try {
                    try {
                        this.params = p;
                        this.imageDir.mkdirs();
                        this.menuShortcut = this.params.needMenu;
                        this.desktopShortcut = this.params.needShortcut;
                        if (!this.menuShortcut && !this.desktopShortcut) {
                            Log.verbose("At least one type of shortcut is required. Enabling menu shortcut.");
                            this.menuShortcut = true;
                        }
                        if (this.prepareProto() && this.prepareProjectConfig()) {
                            File configScript2 = this.getConfig_Script();
                            if (configScript2.exists()) {
                                Log.info("Running WSH script on application image [" + configScript2.getAbsolutePath() + "]");
                                IOUtils.run("wscript", configScript2, this.verbose);
                            }
                            bl = this.buildEXE(outdir);
                            Object var6_8 = null;
                            break block20;
                        }
                        configScript2 = false;
                        break block21;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        boolean bl2 = false;
                        Object var6_10 = null;
                        try {
                            if (this.verbose) {
                                this.saveConfigFiles();
                            }
                            if (this.imageDir != null && !Log.isDebug()) {
                                IOUtils.deleteRecursive(this.imageDir);
                                return bl2;
                            }
                            if (this.imageDir == null) return bl2;
                            Log.info("Kept working directory for debug: " + this.imageDir.getAbsolutePath());
                            return bl2;
                        }
                        catch (FileNotFoundException ex2) {
                            return false;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    try {}
                    catch (FileNotFoundException ex2) {
                        return false;
                    }
                    if (this.verbose) {
                        this.saveConfigFiles();
                    }
                    if (this.imageDir != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(this.imageDir);
                        throw throwable;
                    }
                    if (this.imageDir == null) throw throwable;
                    Log.info("Kept working directory for debug: " + this.imageDir.getAbsolutePath());
                    throw throwable;
                }
            }
            try {}
            catch (FileNotFoundException ex2) {
                return false;
            }
            if (this.verbose) {
                this.saveConfigFiles();
            }
            if (this.imageDir != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(this.imageDir);
                return bl;
            }
            if (this.imageDir == null) return bl;
            Log.info("Kept working directory for debug: " + this.imageDir.getAbsolutePath());
            return bl;
        }
        Object var6_9 = null;
        try {}
        catch (FileNotFoundException ex2) {
            return false;
        }
        if (this.verbose) {
            this.saveConfigFiles();
        }
        if (this.imageDir != null && !Log.isDebug()) {
            IOUtils.deleteRecursive(this.imageDir);
            return configScript2;
        }
        if (this.imageDir == null) return configScript2;
        Log.info("Kept working directory for debug: " + this.imageDir.getAbsolutePath());
        return configScript2;
    }

    private File getConfig_Script() {
        return new File(this.imageDir, WinAppBundler.getAppName(this.params) + "-post-image.wsf");
    }

    protected void saveConfigFiles() {
        try {
            if (this.getConfig_ExeProjectFile().exists()) {
                IOUtils.copyFile(this.getConfig_ExeProjectFile(), new File(this.configRoot, this.getConfig_ExeProjectFile().getName()));
            }
            if (this.getConfig_Script().exists()) {
                IOUtils.copyFile(this.getConfig_Script(), new File(this.configRoot, this.getConfig_Script().getName()));
            }
            if (this.getConfig_SmallInnoSetupIcon().exists()) {
                IOUtils.copyFile(this.getConfig_SmallInnoSetupIcon(), new File(this.configRoot, this.getConfig_SmallInnoSetupIcon().getName()));
            }
            Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String toString() {
        return "Exe Bundler (based on Inno Setup)";
    }

    private String getAppIdentifier() {
        String nm = null;
        nm = this.params.identifier != null ? this.params.identifier : this.params.getMainClassName();
        if (nm.length() > 126) {
            nm = nm.substring(0, 126);
        }
        return nm;
    }

    private String getGroup() {
        if (this.params.applicationCategory != null) {
            return this.params.applicationCategory;
        }
        if (this.params.vendor != null) {
            return this.params.vendor;
        }
        return "Unknown";
    }

    private String getLicenseFile() {
        if (this.params.licenseFile.isEmpty()) {
            return "";
        }
        return this.params.licenseFile.get(0);
    }

    private String getDescription() {
        if (this.params.description != null) {
            return this.params.description.replaceAll("\"", "'");
        }
        return "none";
    }

    boolean prepareMainProjectFile(File imageDir) throws IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("PRODUCT_APP_IDENTIFIER", this.getAppIdentifier());
        data.put("APPLICATION_NAME", WinAppBundler.getAppName(this.params));
        data.put("APPLICATION_VENDOR", this.params.vendor != null ? this.params.vendor : "Unknown");
        data.put("APPLICATION_VERSION", this.params.appVersion != null ? this.params.appVersion : "1.0");
        data.put("APPLICATION_LAUNCHER_FILENAME", WinAppBundler.getLauncher(imageDir, this.params).getName());
        data.put("APPLICATION_DESKTOP_SHORTCUT", this.desktopShortcut ? "returnTrue" : "returnFalse");
        data.put("APPLICATION_MENU_SHORTCUT", this.menuShortcut ? "returnTrue" : "returnFalse");
        data.put("APPLICATION_GROUP", this.getGroup());
        data.put("APPLICATION_COMMENTS", this.params.title != null ? this.params.title : "");
        data.put("APPLICATION_COPYRIGHT", this.params.copyright != null ? this.params.copyright : "");
        data.put("APPLICATION_LICENSE_FILE", this.getLicenseFile());
        if (this.params.systemWide != null && this.params.systemWide.booleanValue()) {
            data.put("APPLICATION_INSTALL_ROOT", "{pf}");
            data.put("APPLICATION_INSTALL_PRIVILEGE", "admin");
        } else {
            data.put("APPLICATION_INSTALL_ROOT", "{localappdata}");
            data.put("APPLICATION_INSTALL_PRIVILEGE", "lowest");
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(this.getConfig_ExeProjectFile()));
        String content = this.preprocessTextResource("package/windows/" + this.getConfig_ExeProjectFile().getName(), "Inno Setup project file", DEFAULT_EXE_PROJECT_TEMPLATE, data);
        w.write(content);
        ((Writer)w).close();
        return true;
    }

    private boolean prepareProjectConfig() throws IOException {
        this.prepareMainProjectFile(this.imageDir);
        File iconTarget = this.getConfig_SmallInnoSetupIcon();
        this.fetchResource("package/windows/" + iconTarget.getName(), "setup dialog icon", DEFAULT_INNO_SETUP_ICON, iconTarget);
        this.fetchResource("package/windows/" + this.getConfig_Script().getName(), "script to run after application image is populated", (String)null, this.getConfig_Script());
        return true;
    }

    private File getConfig_SmallInnoSetupIcon() {
        return new File(this.imageDir, WinAppBundler.getAppName(this.params) + "-setup-icon.bmp");
    }

    private File getConfig_ExeProjectFile() {
        return new File(this.imageDir, WinAppBundler.getAppName(this.params) + ".iss");
    }

    private boolean buildEXE(File outdir) throws IOException {
        Log.verbose("Generating EXE for installer to: " + outdir.getAbsolutePath());
        outdir.mkdirs();
        ProcessBuilder pb = new ProcessBuilder(TOOL_INNO_SETUP_COMPILER, "/o" + outdir.getAbsolutePath(), this.getConfig_ExeProjectFile().getAbsolutePath());
        pb = pb.directory(this.imageDir);
        IOUtils.exec(pb, this.verbose);
        Log.info("Installer (.exe) saved to: " + outdir.getAbsolutePath());
        return true;
    }

    static class VersionExtractor
    extends PrintStream {
        double version = 0.0;

        public VersionExtractor() {
            super(new ByteArrayOutputStream());
        }

        double getVersion() {
            if (this.version == 0.0) {
                String content = new String(((ByteArrayOutputStream)this.out).toByteArray());
                Pattern pattern = Pattern.compile("Inno Setup (\\d+.?\\d*)");
                Matcher matcher = pattern.matcher(content);
                if (matcher.find()) {
                    String v = matcher.group(1);
                    this.version = new Double(v);
                }
            }
            return this.version;
        }
    }
}

