/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx;

import com.jrockit.mc.rjmx.RJMXSingleton;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;

public final class RJMXPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.jrockit.mc.rjmx";
    static final String SERVER_CONFIG_ID = "serverConfig";
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private static RJMXPlugin plugin;
    private IEclipsePreferences rjmxPreferences;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        RJMXPlugin rJMXPlugin = this;
        synchronized (rJMXPlugin) {
            if (this.rjmxPreferences != null) {
                RJMXSingleton.getDefault().storeAllSettings();
                this.rjmxPreferences.flush();
            }
        }
        plugin = null;
        super.stop(context);
    }

    public static RJMXPlugin getDefault() {
        return plugin;
    }

    public synchronized IEclipsePreferences getRJMXPreferences() {
        if (this.rjmxPreferences == null) {
            this.rjmxPreferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        }
        return this.rjmxPreferences;
    }

    public synchronized Preferences getServerPreferences(String serverUid) {
        return this.getRJMXPreferences().node(SERVER_CONFIG_ID).node(serverUid);
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public <T> T getService(Class<T> clazz) {
        return RJMXSingleton.getDefault().getService(clazz);
    }
}

