/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import sun.security.pkcs.PKCS8Key;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateKeyImpl;
import sun.security.rsa.RSAUtil;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class RSAPrivateCrtKeyImpl
extends PKCS8Key
implements RSAPrivateCrtKey {
    private static final long serialVersionUID = -1326088454257084918L;
    private BigInteger n;
    private BigInteger e;
    private BigInteger d;
    private BigInteger p;
    private BigInteger q;
    private BigInteger pe;
    private BigInteger qe;
    private BigInteger coeff;
    private transient RSAUtil.KeyType type;
    private transient AlgorithmParameterSpec keyParams;

    public static RSAPrivateKey newKey(byte[] byArray) throws InvalidKeyException {
        RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl = new RSAPrivateCrtKeyImpl(byArray);
        if (rSAPrivateCrtKeyImpl.getPublicExponent().signum() == 0 || rSAPrivateCrtKeyImpl.getPrimeExponentP().signum() == 0 || rSAPrivateCrtKeyImpl.getPrimeExponentQ().signum() == 0 || rSAPrivateCrtKeyImpl.getPrimeP().signum() == 0 || rSAPrivateCrtKeyImpl.getPrimeQ().signum() == 0 || rSAPrivateCrtKeyImpl.getCrtCoefficient().signum() == 0) {
            return new RSAPrivateKeyImpl(rSAPrivateCrtKeyImpl.algid, rSAPrivateCrtKeyImpl.getModulus(), rSAPrivateCrtKeyImpl.getPrivateExponent());
        }
        return rSAPrivateCrtKeyImpl;
    }

    public static RSAPrivateKey newKey(RSAUtil.KeyType keyType, String string, byte[] byArray) throws InvalidKeyException {
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Missing key encoding");
        }
        switch (string) {
            case "PKCS#8": {
                RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl = new RSAPrivateCrtKeyImpl(byArray);
                RSAKeyFactory.checkKeyAlgo(rSAPrivateCrtKeyImpl, keyType.keyAlgo);
                if (rSAPrivateCrtKeyImpl.getPublicExponent().signum() == 0 || rSAPrivateCrtKeyImpl.getPrimeExponentP().signum() == 0 || rSAPrivateCrtKeyImpl.getPrimeExponentQ().signum() == 0 || rSAPrivateCrtKeyImpl.getPrimeP().signum() == 0 || rSAPrivateCrtKeyImpl.getPrimeQ().signum() == 0 || rSAPrivateCrtKeyImpl.getCrtCoefficient().signum() == 0) {
                    return new RSAPrivateKeyImpl(RSAUtil.createAlgorithmId(rSAPrivateCrtKeyImpl.type, rSAPrivateCrtKeyImpl.keyParams), rSAPrivateCrtKeyImpl.getModulus(), rSAPrivateCrtKeyImpl.getPrivateExponent());
                }
                return rSAPrivateCrtKeyImpl;
            }
            case "PKCS#1": {
                try {
                    BigInteger[] bigIntegerArray = RSAPrivateCrtKeyImpl.parseASN1(byArray);
                    if (bigIntegerArray[1].signum() == 0 || bigIntegerArray[3].signum() == 0 || bigIntegerArray[4].signum() == 0 || bigIntegerArray[5].signum() == 0 || bigIntegerArray[6].signum() == 0 || bigIntegerArray[7].signum() == 0) {
                        return new RSAPrivateKeyImpl(RSAUtil.createAlgorithmId(keyType, null), bigIntegerArray[0], bigIntegerArray[2]);
                    }
                    return new RSAPrivateCrtKeyImpl(RSAUtil.createAlgorithmId(keyType, null), bigIntegerArray[0], bigIntegerArray[1], bigIntegerArray[2], bigIntegerArray[3], bigIntegerArray[4], bigIntegerArray[5], bigIntegerArray[6], bigIntegerArray[7]);
                }
                catch (IOException iOException) {
                    throw new InvalidKeyException("Invalid PKCS#1 encoding", iOException);
                }
            }
        }
        throw new InvalidKeyException("Unsupported RSA Private(Crt)Key format: " + string);
    }

    public static RSAPrivateKey newKey(RSAUtil.KeyType keyType, AlgorithmParameterSpec algorithmParameterSpec, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        AlgorithmId algorithmId = RSAUtil.createAlgorithmId(keyType, algorithmParameterSpec);
        if (bigInteger2.signum() == 0 || bigInteger4.signum() == 0 || bigInteger5.signum() == 0 || bigInteger6.signum() == 0 || bigInteger7.signum() == 0 || bigInteger8.signum() == 0) {
            return new RSAPrivateKeyImpl(algorithmId, bigInteger, bigInteger3);
        }
        return new RSAPrivateCrtKeyImpl(algorithmId, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    private RSAPrivateCrtKeyImpl(byte[] byArray) throws InvalidKeyException {
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Missing key encoding");
        }
        this.decode(byArray);
        RSAKeyFactory.checkRSAProviderKeyLengths(this.n.bitLength(), this.e);
        try {
            Object[] objectArray = RSAUtil.getTypeAndParamSpec(this.algid);
            this.type = (RSAUtil.KeyType)((Object)objectArray[0]);
            this.keyParams = (AlgorithmParameterSpec)objectArray[1];
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(providerException);
        }
    }

    RSAPrivateCrtKeyImpl(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        RSAKeyFactory.checkRSAProviderKeyLengths(bigInteger.bitLength(), bigInteger2);
        this.n = bigInteger;
        this.e = bigInteger2;
        this.d = bigInteger3;
        this.p = bigInteger4;
        this.q = bigInteger5;
        this.pe = bigInteger6;
        this.qe = bigInteger7;
        this.coeff = bigInteger8;
        this.algid = algorithmId;
        Object[] objectArray = RSAUtil.getTypeAndParamSpec(this.algid);
        this.type = (RSAUtil.KeyType)((Object)objectArray[0]);
        this.keyParams = (AlgorithmParameterSpec)objectArray[1];
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(0);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            derOutputStream.putInteger(bigInteger3);
            derOutputStream.putInteger(bigInteger4);
            derOutputStream.putInteger(bigInteger5);
            derOutputStream.putInteger(bigInteger6);
            derOutputStream.putInteger(bigInteger7);
            derOutputStream.putInteger(bigInteger8);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.type.keyAlgo;
    }

    @Override
    public BigInteger getModulus() {
        return this.n;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.e;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.d;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.p;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.q;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.pe;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.qe;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.coeff;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    public String toString() {
        return "SunRsaSign " + this.type.keyAlgo + " private CRT key, " + this.n.bitLength() + " bits\n  params: " + this.keyParams + "\n  modulus: " + this.n + "\n  private exponent: " + this.d;
    }

    private static BigInteger[] parseASN1(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("Not a SEQUENCE");
        }
        int n = derValue.data.getInteger();
        if (n != 0) {
            throw new IOException("Version must be 0");
        }
        BigInteger[] bigIntegerArray = new BigInteger[8];
        for (int i = 0; i < bigIntegerArray.length; ++i) {
            bigIntegerArray[i] = derValue.data.getPositiveBigInteger();
        }
        if (derValue.data.available() != 0) {
            throw new IOException("Extra data available");
        }
        return bigIntegerArray;
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            BigInteger[] bigIntegerArray = RSAPrivateCrtKeyImpl.parseASN1(this.key);
            this.n = bigIntegerArray[0];
            this.e = bigIntegerArray[1];
            this.d = bigIntegerArray[2];
            this.p = bigIntegerArray[3];
            this.q = bigIntegerArray[4];
            this.pe = bigIntegerArray[5];
            this.qe = bigIntegerArray[6];
            this.coeff = bigIntegerArray[7];
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Invalid RSA private key", iOException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("RSAPrivateCrtKeyImpl keys are not directly deserializable");
    }
}

