/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.Color;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.OQLSupport;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.OQLControllerUI;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.netbeans.modules.profiler.oql.engine.api.OQLException;
import org.netbeans.modules.profiler.oql.engine.api.ReferenceChain;
import org.openide.util.NbBundle;

public class OQLController
extends AbstractTopLevelController
implements NavigationHistoryManager.NavigationHistoryCapable {
    private static final int RESULTS_LIMIT = Integer.parseInt(System.getProperty("OQLController.limitResults", "100"));
    private HeapFragmentWalker heapFragmentWalker;
    private ResultsController resultsController;
    private QueryController queryController;
    private SavedController savedController;
    private final ExecutorService progressUpdater = Executors.newSingleThreadExecutor();
    private final AtomicBoolean analysisRunning = new AtomicBoolean(false);
    private OQLEngine engine = null;

    public OQLController(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        if (OQLEngine.isOQLSupported()) {
            this.engine = new OQLEngine(heapFragmentWalker.getHeapFragment());
            this.resultsController = new ResultsController(this);
            this.queryController = new QueryController(this);
            this.savedController = new SavedController(this);
        }
    }

    public void executeQuery(String string) {
        this.executeQueryImpl(string);
    }

    public void cancelQuery() {
        try {
            this.engine.cancelQuery();
        }
        catch (OQLException oQLException) {
            // empty catch block
        }
        this.finalizeQuery();
    }

    public boolean isQueryRunning() {
        return this.analysisRunning.get();
    }

    public HeapFragmentWalker getHeapFragmentWalker() {
        return this.heapFragmentWalker;
    }

    public ResultsController getResultsController() {
        return this.resultsController;
    }

    public QueryController getQueryController() {
        return this.queryController;
    }

    public SavedController getSavedController() {
        return this.savedController;
    }

    @Override
    protected AbstractButton[] createClientPresenters() {
        return new AbstractButton[]{this.resultsController.getPresenter(), this.queryController.getPresenter(), this.savedController.getPresenter()};
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((OQLControllerUI)this.getPanel()).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new OQLControllerUI(this);
    }

    @Override
    public NavigationHistoryManager.Configuration getCurrentConfiguration() {
        return new NavigationHistoryManager.Configuration();
    }

    @Override
    public void configure(NavigationHistoryManager.Configuration configuration) {
        this.heapFragmentWalker.switchToHistoryOQLView();
    }

    private void executeQueryImpl(final String string) {
        final DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(0, 10, 0, 100);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserUtils.performTask(new Runnable(){

                    @Override
                    public void run() {
                        final AtomicInteger atomicInteger = new AtomicInteger(RESULTS_LIMIT);
                        defaultBoundedRangeModel.setMaximum(100);
                        final StringBuilder stringBuilder = new StringBuilder();
                        final boolean[] blArray = new boolean[1];
                        Color color = UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground());
                        final String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
                        stringBuilder.append("<table border='0' width='100%'>");
                        try {
                            OQLController.this.analysisRunning.compareAndSet(false, true);
                            OQLController.this.queryController.queryStarted(defaultBoundedRangeModel);
                            OQLController.this.progressUpdater.submit(new ProgressUpdater(defaultBoundedRangeModel));
                            OQLController.this.engine.executeQuery(string, new OQLEngine.ObjectVisitor(){

                                public boolean visit(Object object) {
                                    stringBuilder.append(blArray[0] ? "<tr><td style='background-color: " + string + ";'>" : "<tr><td>");
                                    blArray[0] = !blArray[0];
                                    OQLController.this.dump(object, stringBuilder);
                                    stringBuilder.append("</td></tr>");
                                    return atomicInteger.decrementAndGet() == 0 || !OQLController.this.analysisRunning.get() && !OQLController.this.engine.isCancelled();
                                }
                            });
                            if (atomicInteger.get() == 0) {
                                stringBuilder.append("<tr><td><h4>Too many results. Please, refine your query.</h4></td></tr>");
                            } else if (atomicInteger.get() == RESULTS_LIMIT) {
                                stringBuilder.append("<tr><td><h4>");
                                stringBuilder.append(NbBundle.getMessage(OQLController.class, (String)"OQL_NO_RESULTS_MSG"));
                                stringBuilder.append("</h4></td></tr>");
                            }
                            stringBuilder.append("</table>");
                            OQLController.this.resultsController.setResult(stringBuilder.toString());
                            OQLController.this.finalizeQuery();
                        }
                        catch (OQLException oQLException) {
                            StringBuilder stringBuilder2 = new StringBuilder();
                            stringBuilder2.append("<h2>").append(NbBundle.getMessage(OQLController.class, (String)"OQL_QUERY_ERROR")).append("</h2>");
                            stringBuilder2.append(NbBundle.getMessage(OQLController.class, (String)"OQL_QUERY_PLZ_CHECK"));
                            stringBuilder2.append("<hr>");
                            stringBuilder2.append(oQLException.getLocalizedMessage().replace("\n", "<br>").replace("\r", "<br>"));
                            OQLController.this.resultsController.setResult(stringBuilder2.toString());
                            OQLController.this.finalizeQuery();
                        }
                    }
                });
            }
        });
    }

    private void finalizeQuery() {
        this.analysisRunning.compareAndSet(true, false);
        this.queryController.queryFinished();
    }

    private void dump(Object object, StringBuilder stringBuilder) {
        if (object == null) {
            return;
        }
        if (object instanceof Instance) {
            Instance instance = (Instance)object;
            stringBuilder.append(OQLController.printInstance(instance, this.heapFragmentWalker.getHeapFragment()));
        } else if (object instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)object;
            stringBuilder.append(OQLController.printClass(javaClass));
        } else if (object instanceof ReferenceChain) {
            boolean bl = true;
            for (ReferenceChain referenceChain = (ReferenceChain)object; referenceChain != null; referenceChain = referenceChain.getNext()) {
                if (!bl) {
                    stringBuilder.append("-&gt;");
                } else {
                    bl = false;
                }
                object = referenceChain.getObj();
                if (object instanceof Instance) {
                    stringBuilder.append(OQLController.printInstance((Instance)object, this.heapFragmentWalker.getHeapFragment()));
                    continue;
                }
                if (!(object instanceof JavaClass)) continue;
                stringBuilder.append(OQLController.printClass((JavaClass)object));
            }
        } else if (object instanceof Map) {
            Set set = ((Map)object).entrySet();
            stringBuilder.append("<span><b>{</b><br/>");
            boolean bl = true;
            for (Map.Entry entry : set) {
                if (!bl) {
                    stringBuilder.append(",<br/>");
                } else {
                    bl = false;
                }
                stringBuilder.append(entry.getKey().toString().replace("<", "&lt;").replace(">", "&gt;"));
                stringBuilder.append(" = ");
                this.dump(entry.getValue(), stringBuilder);
            }
            stringBuilder.append("<br/><b>}</b></span>");
        } else if (object instanceof Object[]) {
            stringBuilder.append("<span><b>[</b>&nbsp;");
            boolean bl = true;
            for (Object object2 : (Object[])object) {
                if (!bl) {
                    stringBuilder.append(", ");
                } else {
                    bl = false;
                }
                Object object3 = this.engine.unwrapJavaObject(object2, true);
                if (object3 != null) {
                    this.dump(object3, stringBuilder);
                    continue;
                }
                this.dump(object2, stringBuilder);
            }
            stringBuilder.append("&nbsp;<b>]</b></span>");
        } else {
            stringBuilder.append(object.toString());
        }
    }

    private OQLEngine getEngine() {
        return this.engine;
    }

    private void showURL(URL uRL) {
        String string = uRL.toString();
        if (string.startsWith("file://instance/")) {
            string = string.substring("file://instance/".length());
            int n = string.indexOf(35);
            int n2 = string.indexOf(64);
            String string2 = null;
            if (n > -1 || n2 > -1) {
                string2 = string.substring(0, Math.max(n, n2));
            }
            Instance instance = null;
            String string3 = null;
            if (n > -1) {
                string3 = string.substring(n + 1);
                JavaClass javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(string2);
                if (javaClass != null) {
                    List list = javaClass.getInstances();
                    int n3 = Integer.parseInt(string3);
                    if (n3 <= list.size()) {
                        instance = (Instance)list.get(n3 - 1);
                    }
                } else {
                    ProfilerDialogs.displayError((String)Bundle.AnalysisController_CannotResolveClassMsg(string2));
                }
            } else if (n2 > -1) {
                string3 = string.substring(n2 + 1);
                instance = this.heapFragmentWalker.getHeapFragment().getInstanceByID(Long.parseLong(string3));
            }
            if (instance != null) {
                this.heapFragmentWalker.getClassesController().showInstance(instance);
            } else {
                ProfilerDialogs.displayError((String)Bundle.AnalysisController_CannotResolveInstanceMsg(string3, string2));
            }
        } else if (string.startsWith("file://class/")) {
            string = string.substring("file://class/".length());
            JavaClass javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByID(Long.parseLong(string));
            if (javaClass != null) {
                this.heapFragmentWalker.getClassesController().showClass(javaClass);
            } else {
                ProfilerDialogs.displayError((String)Bundle.AnalysisController_CannotResolveClassMsg(string));
            }
        }
    }

    private static String printClass(JavaClass javaClass) {
        String string;
        if (javaClass == null) {
            return NbBundle.getMessage(Utils.class, (String)"LBL_UnknownClass");
        }
        String string2 = string = javaClass.getName();
        String string3 = "";
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(58);
        if (n2 == -1) {
            n2 = string.lastIndexOf(59);
        }
        if (n2 > 0) {
            string2 = string.substring(0, n2);
            string3 = "." + string.substring(n2 + 1);
        }
        return "<a href='file://class/" + javaClass.getJavaClassId() + "'>" + string2 + "</a>" + string3;
    }

    private static String printInstance(Instance instance, Heap heap) {
        String string = instance.getJavaClass().getName();
        String string2 = DetailsUtils.getInstanceString(instance, heap);
        return "<a href='file://instance/" + string + "@" + instance.getInstanceId() + "'>" + string + '#' + instance.getInstanceNumber() + "</a>" + (string2 != null ? " - " + string2 : "");
    }

    private class ProgressUpdater
    implements Runnable {
        private final BoundedRangeModel progressModel;

        ProgressUpdater(BoundedRangeModel boundedRangeModel) {
            this.progressModel = boundedRangeModel;
        }

        @Override
        public void run() {
            while (OQLController.this.analysisRunning.get()) {
                int n = this.progressModel.getValue() + 10;
                if (n > this.progressModel.getMaximum()) {
                    n = this.progressModel.getMinimum();
                }
                final int n2 = n;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressUpdater.this.progressModel.setValue(n2);
                    }
                });
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static class SavedController
    extends AbstractController {
        private OQLController oqlController;

        public SavedController(OQLController oQLController) {
            this.oqlController = oQLController;
        }

        public OQLController getOQLController() {
            return this.oqlController;
        }

        public void saveQuery(String string) {
            ((OQLControllerUI.SavedUI)((Object)this.getPanel())).saveQuery(string);
        }

        public static void loadData(OQLSupport.OQLTreeModel oQLTreeModel) {
            OQLSupport.loadModel(oQLTreeModel);
        }

        public static void saveData(OQLSupport.OQLTreeModel oQLTreeModel) {
            OQLSupport.saveModel(oQLTreeModel);
        }

        @Override
        protected AbstractButton createControllerPresenter() {
            return ((OQLControllerUI.SavedUI)((Object)this.getPanel())).getPresenter();
        }

        @Override
        protected JPanel createControllerUI() {
            OQLControllerUI.SavedUI savedUI = new OQLControllerUI.SavedUI(this);
            return savedUI;
        }
    }

    public static class QueryController
    extends AbstractController {
        private OQLController oqlController;

        public QueryController(OQLController oQLController) {
            this.oqlController = oQLController;
        }

        public OQLController getOQLController() {
            return this.oqlController;
        }

        public void setQuery(String string) {
            ((OQLControllerUI.QueryUI)((Object)this.getPanel())).setQuery(string);
        }

        private void queryStarted(BoundedRangeModel boundedRangeModel) {
            ((OQLControllerUI.QueryUI)((Object)this.getPanel())).queryStarted(boundedRangeModel);
        }

        private void queryFinished() {
            ((OQLControllerUI.QueryUI)((Object)this.getPanel())).queryFinished();
        }

        @Override
        protected AbstractButton createControllerPresenter() {
            return ((OQLControllerUI.QueryUI)((Object)this.getPanel())).getPresenter();
        }

        @Override
        protected JPanel createControllerUI() {
            return new OQLControllerUI.QueryUI(this, this.oqlController.getEngine());
        }
    }

    public static class ResultsController
    extends AbstractController {
        private OQLController oqlController;

        public ResultsController(OQLController oQLController) {
            this.oqlController = oQLController;
        }

        public void setResult(final String string) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((OQLControllerUI.ResultsUI)((Object)ResultsController.this.getPanel())).setResult(string);
                }
            });
        }

        public void showURL(URL uRL) {
            this.oqlController.showURL(uRL);
        }

        public OQLController getOQLController() {
            return this.oqlController;
        }

        @Override
        protected AbstractButton createControllerPresenter() {
            return ((OQLControllerUI.ResultsUI)((Object)this.getPanel())).getPresenter();
        }

        @Override
        protected JPanel createControllerUI() {
            return new OQLControllerUI.ResultsUI(this);
        }
    }
}

