/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.dial;

import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.ListInput;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.selection.BrowseForEventAttributeWizard;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.misc.MCColor;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class DialInput
extends ListInput<DialDescriptor> {
    static final String ANIMATED = "animated";
    private final IServiceLocator m_serviceLocator;
    private final DialDescriptorRepository m_configuration;

    public DialInput(IServiceLocator serviceLocator, DialDescriptorRepository configuration) {
        super(Messages.DIAL_COMPONENT_MASTER_DETAIL_TITLE);
        this.m_serviceLocator = serviceLocator;
        this.m_configuration = configuration;
        this.addInputs(this.m_serviceLocator);
    }

    private void addInputs(IServiceLocator m_serviceLocator2) {
        this.addInput(InputFactory.createAttributeWithRepository(this.m_serviceLocator, this.m_configuration.getEventTypeDescriptorBase(), true));
        this.addInput((IInput)InputFactory.createName());
        this.addInput(InputFactory.createDescription());
        this.addInput(InputFactory.createAggregator());
        this.addInput(InputFactory.createColor());
        this.addInput(this.createAnimated());
    }

    protected IInput createTopInput() {
        return InputFactory.createEventTypeInput(this.m_serviceLocator);
    }

    public List<DialDescriptor> createDetailList() {
        return this.m_configuration.getDialDescriptors();
    }

    public List<DialDescriptor> createNew(Shell shell) {
        EventTypeDescriptorRepository eventTypes = this.m_configuration.getEventTypeDescriptorBase();
        if (eventTypes.getDescriptors().isEmpty()) {
            MessageDialog.openConfirm((Shell)shell, (String)Messages.DIAL_COMPONENT_CONFIGURATION_MISSING_EVENT_TYPE_TEXT, (String)Messages.DIAL_COMPONENT_CONFIGURATION_YOU_MUST_SELECT_AN_EVENT_TYPE);
            return null;
        }
        BrowseForEventAttributeWizard bfeaw = new BrowseForEventAttributeWizard(this.m_serviceLocator, 4, false, eventTypes);
        OnePageWizardDialog dialog = new OnePageWizardDialog(shell, (IWizardPage)bfeaw);
        dialog.setWidthConstraint(800, Integer.MAX_VALUE);
        dialog.setHeightConstraint(600, 800);
        if (dialog.open() == 0) {
            Object[] object = bfeaw.getSelection().toArray();
            ArrayList<DialDescriptor> list = new ArrayList<DialDescriptor>();
            Object[] objectArray = object;
            int n = object.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                list.add(this.createDialDescriptor((IField)element));
                ++n2;
            }
            return list;
        }
        return null;
    }

    public StructuredViewer createTableViewer(Composite parent) {
        FieldTableViewer viewer = new FieldTableViewer(this.createTable(parent), this.createFields());
        viewer.setContentProvider((IContentProvider)new InformationContentProvider());
        viewer.setInput(this.getDialDescriptors());
        return viewer;
    }

    private DialDescriptor createDialDescriptor(IField result) {
        DialDescriptor dialDescriptor = new DialDescriptor();
        dialDescriptor.setName(result.getName());
        dialDescriptor.setDescription(result.getDescription());
        dialDescriptor.setAttributeIdentifier(result.getIdentifier());
        dialDescriptor.setAnimated(true);
        dialDescriptor.setColor(new MCColor(Color.BLACK));
        dialDescriptor.setUnit(new UnitDescriptor());
        return dialDescriptor;
    }

    private IInput createAnimated() {
        return new BooleanInput(ANIMATED, Messages.DIAL_COMPONENT_ANIMATE_TEXT);
    }

    private Table createTable(Composite parent) {
        return new Table(parent, 268503812);
    }

    private Field[] createFields() {
        return new Field[]{InformationContentProvider.FIELD_NAME, InformationContentProvider.FIELD_DESCRIPTION};
    }

    private List<DialDescriptor> getDialDescriptors() {
        return this.m_configuration.getDialDescriptors();
    }
}

