/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jconsole;

import com.sun.tools.jconsole.JConsoleContext;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public abstract class JConsolePlugin {
    private volatile JConsoleContext context = null;
    private List<PropertyChangeListener> listeners = null;

    protected JConsolePlugin() {
    }

    public final synchronized void setContext(JConsoleContext jConsoleContext) {
        this.context = jConsoleContext;
        if (this.listeners != null) {
            for (PropertyChangeListener propertyChangeListener : this.listeners) {
                jConsoleContext.addPropertyChangeListener(propertyChangeListener);
            }
            this.listeners = null;
        }
    }

    public final JConsoleContext getContext() {
        return this.context;
    }

    public abstract Map<String, JPanel> getTabs();

    public abstract SwingWorker<?, ?> newSwingWorker();

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addContextPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener is null");
        }
        if (this.context == null) {
            JConsolePlugin jConsolePlugin = this;
            synchronized (jConsolePlugin) {
                if (this.context == null) {
                    if (this.listeners == null) {
                        this.listeners = new ArrayList<PropertyChangeListener>();
                    }
                    this.listeners.add(propertyChangeListener);
                    return;
                }
            }
        }
        this.context.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeContextPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener is null");
        }
        if (this.context == null) {
            JConsolePlugin jConsolePlugin = this;
            synchronized (jConsolePlugin) {
                if (this.context == null) {
                    if (this.listeners != null) {
                        this.listeners.remove(propertyChangeListener);
                    }
                    return;
                }
            }
        }
        this.context.removePropertyChangeListener(propertyChangeListener);
    }
}

