/*
 * Copyright (c) 2020, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package org.graalvm.compiler.core.test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.options.OptionValues;
import org.junit.Test;

import jdk.vm.ci.meta.ResolvedJavaMethod;

public class DeepUnrollingTest extends SubprocessTest {

    public static void loops() {
        for (int i = 0; i < 6; i++) {
            for (int n = 2; n < 30; n++) {
                for (int j = 1; j <= n; j++) {
                    for (int k = 1; k <= j; k++) {
                        // nop
                    }
                }
            }
        }
    }

    public static int reference(int a, int n) {
        int v = a;
        for (int i = 0; i < n; i++) {
            if (v % 2 == 0) {
                v = v / 2;
            } else {
                v = 3 * v + 1;
            }
        }
        return v;
    }

    public void loopTest() {
        // warmup
        time("reference");
        time("loops");
        long reference = time("reference");
        long loops = time("loops");
        // observed ratio is ~20-30x. Pathological case before fix was ~300x
        assertTrue("Compilation of the loop nest is too slow", loops < reference * 45);
    }

    public long time(String methodName) {
        ResolvedJavaMethod method = getResolvedJavaMethod(methodName);
        OptionValues options = new OptionValues(getInitialOptions(),
                        GraalOptions.FullUnroll, true);
        long start = System.nanoTime();
        getCode(method, null, true, false, options);
        long end = System.nanoTime();
        return TimeUnit.NANOSECONDS.toMillis(end - start);
    }

    @Test
    public void test() throws IOException, InterruptedException {
        launchSubprocess(this::loopTest);
    }
}
