/*
 * Copyright (c) 1997, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.tools.internal.ws.wscompile;

import com.sun.tools.internal.xjc.api.ErrorListener;
import org.xml.sax.SAXParseException;

/**
 * @author Vivek Pandey
 */
public class WsimportListener implements ErrorListener {
    /**
     * Called for each file generated by wsimport or wsgen.
     *
     * <p>
     * The file name includes the path portions that correspond with the package name.
     *
     * <p>
     * When generating files into a directory, file names will be relative to the
     * output directory.
     *
     * @param fileName
     *      file names like "org/acme/foo/Foo.java"
     *
     */
    public void generatedFile(String fileName) {}

    /**
     * Other miscellenous messages that do not have structures
     * will be reported through this method.
     *
     * This method is used like {@link java.io.PrintStream#println(String)}.
     * The callee is expected to add '\n'.
     */
    public void message(String msg) {}

    public void error(SAXParseException exception) {

    }

    public void fatalError(SAXParseException exception) {

    }

    public void warning(SAXParseException exception) {

    }

    public void info(SAXParseException exception) {

    }

    public void debug(SAXParseException exception){}

    /**
     * wsimport will periodically invoke this method to see if it should cancel a compilation.
     *
     * @return
     *      true if the {@link com.sun.tools.internal.ws.wscompile.WsimportListener} wants to abort the processing.
     * @since 2.1
     */
    public boolean isCanceled() {
        return false;
    }

}
