/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.nashorn.api.tree;

import java.util.List;

/**
 * A tree node for a statement block.
 *
 * For example:
 * <pre>
 *   { }
 *
 *   { <em>statements</em> }
 * </pre>
 *
 * @since 9
 */
public interface BlockTree extends StatementTree {
    /**
     * Returns the list of statements in this block.
     *
     * @return the list of statements in this block
     */
    List<? extends StatementTree> getStatements();
}
