/*
 * Copyright (c) 2014, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/**
 * Defines the Java Management Extensions (JMX) API.
 * <P>
 * The JMX API consists of interfaces for monitoring and management of the
 * JVM and other components in the Java runtime.
 *
 * @uses javax.management.remote.JMXConnectorProvider
 * @uses javax.management.remote.JMXConnectorServerProvider
 *
 * @moduleGraph
 * @since 9
 */
module java.management {
    // source file: file:///scratch/opt/mach5/mesos/work_dir/slaves/c4ee7e63-1ded-4e8c-9581-ce26f27e3af4-S497/frameworks/1735e8a2-a1db-478c-8104-60c8b0af87dd-0196/executors/5297d4ef-7370-47a1-9ee2-e0e664eddf0c/runs/d370ac1b-2805-4768-a268-21d3b04bf882/workspace/open/src/java.management/share/classes/module-info.java
    //              file:///scratch/opt/mach5/mesos/work_dir/slaves/c4ee7e63-1ded-4e8c-9581-ce26f27e3af4-S497/frameworks/1735e8a2-a1db-478c-8104-60c8b0af87dd-0196/executors/5297d4ef-7370-47a1-9ee2-e0e664eddf0c/runs/d370ac1b-2805-4768-a268-21d3b04bf882/workspace/closed/src/java.management/share/classes/module-info.java.extra
    exports java.lang.management;
    exports javax.management;
    exports javax.management.loading;
    exports javax.management.modelmbean;
    exports javax.management.monitor;
    exports javax.management.openmbean;
    exports javax.management.relation;
    exports javax.management.remote;
    exports javax.management.timer;
    exports com.sun.jmx.remote.internal to
        java.management.rmi,
        jdk.management.agent;
    exports com.sun.jmx.remote.security to
        java.management.rmi,
        jdk.management.agent;
    exports com.sun.jmx.remote.util to java.management.rmi;
    exports sun.management to
        jdk.jconsole,
        jdk.management,
        jdk.management.agent;
    exports sun.management.counter to jdk.management.agent;
    exports sun.management.counter.perf to jdk.management.agent;
    exports sun.management.spi to
        jdk.internal.vm.compiler.management,
        jdk.management,
        jdk.management.cmm,
        jdk.management.jfr;

    uses javax.management.remote.JMXConnectorProvider;
    uses javax.management.remote.JMXConnectorServerProvider;
    uses sun.management.spi.PlatformMBeanProvider;
    provides javax.security.auth.spi.LoginModule with com.sun.jmx.remote.security.FileLoginModule;
}
