/*
 * Copyright (c) 1995, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package sun.applet;

import java.awt.*;
import java.io.*;
import java.util.Properties;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.PrivilegedActionException;

import sun.security.action.*;

@SuppressWarnings("serial") // JDK implementation class
@Deprecated(since = "9")
class AppletProps extends Frame {

    TextField proxyHost;
    TextField proxyPort;
    Choice accessMode;

    @SuppressWarnings("deprecation")
    AppletProps() {
        setTitle(amh.getMessage("title"));
        Panel p = new Panel();
        p.setLayout(new GridLayout(0, 2));

        p.add(new Label(amh.getMessage("label.http.server", "Http proxy server:")));
        p.add(proxyHost = new TextField());

        p.add(new Label(amh.getMessage("label.http.proxy")));
        p.add(proxyPort = new TextField());

        p.add(new Label(amh.getMessage("label.class")));
        p.add(accessMode = new Choice());
        accessMode.addItem(amh.getMessage("choice.class.item.restricted"));
        accessMode.addItem(amh.getMessage("choice.class.item.unrestricted"));

        add("Center", p);
        p = new Panel();
        p.add(new Button(amh.getMessage("button.apply")));
        p.add(new Button(amh.getMessage("button.reset")));
        p.add(new Button(amh.getMessage("button.cancel")));
        add("South", p);
        move(200, 150);
        pack();
        reset();
    }

    void reset() {
        AppletSecurity security = (AppletSecurity) System.getSecurityManager();
        if (security != null)
            security.reset();

        String proxyhost = AccessController.doPrivileged(
                new GetPropertyAction("http.proxyHost"));
        String proxyport = AccessController.doPrivileged(
                new GetPropertyAction("http.proxyPort"));

        Boolean tmp = AccessController.doPrivileged(
                new GetBooleanAction("package.restrict.access.sun"));

        boolean packageRestrict = tmp.booleanValue();
        if (packageRestrict) {
           accessMode.select(amh.getMessage("choice.class.item.restricted"));
        } else {
           accessMode.select(amh.getMessage("choice.class.item.unrestricted"));
        }

        if (proxyhost != null) {
            proxyHost.setText(proxyhost);
            proxyPort.setText(proxyport);
        } else {
            proxyHost.setText("");
            proxyPort.setText("");
        }
    }

    @SuppressWarnings("deprecation")
    void apply() {
        String proxyHostValue = proxyHost.getText().trim();
        String proxyPortValue = proxyPort.getText().trim();

        // Get properties
        final Properties props = AccessController.doPrivileged(
             new PrivilegedAction<Properties>() {
                 public Properties run() {
                     return System.getProperties();
                 }
        });

        if (proxyHostValue.length() != 0) {
            /* 4066402 */
            /* Check for parsable value in proxy port number field before */
            /* applying. Display warning to user until parsable value is  */
            /* entered. */
            int proxyPortNumber = 0;
            try {
                proxyPortNumber = Integer.parseInt(proxyPortValue);
            } catch (NumberFormatException e) {}

            if (proxyPortNumber <= 0) {
                proxyPort.selectAll();
                proxyPort.requestFocus();
                (new AppletPropsErrorDialog(this,
                                            amh.getMessage("title.invalidproxy"),
                                            amh.getMessage("label.invalidproxy"),
                                            amh.getMessage("button.ok"))).show();
                return;
            }
            /* end 4066402 */

            props.put("http.proxyHost", proxyHostValue);
            props.put("http.proxyPort", proxyPortValue);
        } else {
            props.put("http.proxyHost", "");
        }

        if (amh.getMessage("choice.class.item.restricted").equals(accessMode.getSelectedItem())) {
            props.put("package.restrict.access.sun", "true");
        } else {
            props.put("package.restrict.access.sun", "false");
        }

        // Save properties
        try {
            reset();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>() {
                public Object run() throws IOException {
                    File dotAV = Main.theUserPropertiesFile;
                    FileOutputStream out = new FileOutputStream(dotAV);
                    Properties avProps = new Properties();
                    for (int i = 0; i < Main.avDefaultUserProps.length; i++) {
                        String avKey = Main.avDefaultUserProps[i][0];
                        avProps.setProperty(avKey, props.getProperty(avKey));
                    }
                    avProps.store(out, amh.getMessage("prop.store"));
                    out.close();
                    return null;
                }
            });
            hide();
        } catch (java.security.PrivilegedActionException e) {
            System.out.println(amh.getMessage("apply.exception",
                                              e.getException()));
            // XXX what's the general feeling on stack traces to System.out?
            e.printStackTrace();
            reset();
        }
    }

    @SuppressWarnings("deprecation")
    public boolean action(Event evt, Object obj) {
        if (amh.getMessage("button.apply").equals(obj)) {
            apply();
            return true;
        }
        if (amh.getMessage("button.reset").equals(obj)) {
            reset();
            return true;
        }
        if (amh.getMessage("button.cancel").equals(obj)) {
            reset();
            hide();
            return true;
        }
        return false;
    }

    private static AppletMessageHandler amh = new AppletMessageHandler("appletprops");

}

/* 4066432 */
/* Dialog class to display property-related errors to user */
@SuppressWarnings("serial") // JDK implementation class
@Deprecated(since = "9")
class AppletPropsErrorDialog extends Dialog {
    @SuppressWarnings("deprecation")
    public AppletPropsErrorDialog(Frame parent, String title, String message,
                String buttonText) {
        super(parent, title, true);
        Panel p = new Panel();
        add("Center", new Label(message));
        p.add(new Button(buttonText));
        add("South", p);
        pack();

        Dimension dDim = size();
        Rectangle fRect = parent.bounds();
        move(fRect.x + ((fRect.width - dDim.width) / 2),
             fRect.y + ((fRect.height - dDim.height) / 2));
    }

    @SuppressWarnings("deprecation")
    public boolean action(Event event, Object object) {
        hide();
        dispose();
        return true;
    }
}

/* end 4066432 */
