/*
 * Copyright (c) 1998, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/**
 * Provides for system input and output through data streams,
 * serialization and the file system.
 *
 * Unless otherwise noted, passing a null argument to a constructor or
 * method in any class or interface in this package will cause a
 * {@code NullPointerException} to be thrown.
 *
 * <h2>Package Specification</h2>
 * <ul>
 *   <li><a href="{@docRoot}/../specs/serialization/index.html">
 *       Java Object Serialization Specification </a>
 * </ul>
 *
 * <h2>Related Documentation</h2>
 *
 * For overviews, tutorials, examples, guides, and tool documentation,
 * please see:
 * <ul>
 *     <li>{@extLink serialver_tool_reference The serialver tool}</li>
 *     <li>{@extLink serialization_guide Serialization Documentation}</li>
 * </ul>
 *
 * @since 1.0
 */
package java.io;
