<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">

<xsl:output method="text" indent="yes"/>

<xsl:template match="/reportcollection">
	<xsl:text>Flight Recording report</xsl:text>
	<xsl:text>&#xa;&#xa;</xsl:text>
	<xsl:apply-templates select="report" />
</xsl:template>

<xsl:template match="report/file">
	<xsl:text>File: </xsl:text>
	<xsl:value-of select="."/>
	<xsl:text>&#xa;&#xa;</xsl:text>
</xsl:template>

<xsl:template match="rule">
	<xsl:apply-templates select="name" />
	<xsl:apply-templates select="severity" />
	<xsl:apply-templates select="score" />
	<xsl:apply-templates select="message" />
	<xsl:apply-templates select="detailedmessage" />
	<xsl:apply-templates select="itemset" />
	<xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="rule/name">
	<xsl:text>Rule: </xsl:text>
	<xsl:value-of select="."/>
	<xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="rule/severity">
	<xsl:text>Severity: </xsl:text>
	<xsl:value-of select="."/>
	<xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="rule/score">
	<xsl:text>Score: </xsl:text>
	<xsl:value-of select="format-number(.,'0.#')"/>
	<xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="rule/message">
	<xsl:text>Message: </xsl:text>
	<xsl:value-of select="."/>
	<xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="rule/detailedmessage">
	<xsl:text>Detailed message: </xsl:text>
	<xsl:value-of select="."/>
	<xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="itemset">
	<xsl:apply-templates select="name"/>
	<xsl:apply-templates select="fields"/>
	<xsl:apply-templates select="items"/>
</xsl:template>

<xsl:template match="itemset/name">
	<xsl:text>Result item set: </xsl:text>
	<xsl:value-of select="."/>
	<xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="fields">
	<xsl:for-each select="field">
		<xsl:value-of select="name" />
		<xsl:choose>
			<xsl:when test="position()!=last()">
				<xsl:text>;</xsl:text>
			</xsl:when>
		</xsl:choose>
	</xsl:for-each>
	<xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="field/name">
	<xsl:value-of select="."/>
</xsl:template>

<xsl:template match="items">
	<xsl:for-each select="item">
		<xsl:for-each select="value">
			<xsl:value-of select="." />
			<xsl:choose>
				<xsl:when test="position()!=last()">
					<xsl:text>;</xsl:text>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		<xsl:text>&#xa;</xsl:text>
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>