<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="yes"/>

<xsl:template match="/reportcollection">
	<html>
	<head>
	<title>Flight Recording report</title>
	</head>
	<body>
		<xsl:apply-templates select="report" />
	</body>
	</html>
</xsl:template>

<xsl:template match="report/file">
	<h1><xsl:value-of select="."/></h1>
</xsl:template>

<xsl:template match="rule">
	<xsl:apply-templates select="name" />
	<xsl:apply-templates select="severity" />
	<xsl:apply-templates select="score" />
	<xsl:apply-templates select="message" />
	<xsl:apply-templates select="detailedmessage" />
	<xsl:apply-templates select="itemset" />
</xsl:template>

<xsl:template match="rule/name">
	<h2><xsl:value-of select="."/></h2>
</xsl:template>

<xsl:template match="rule/severity">
	<p><b>Severity:</b> <xsl:value-of select="."/></p>
</xsl:template>

<xsl:template match="rule/score">
	<p><b>Score:</b> <xsl:value-of select="format-number(.,'0.#')"/></p>
</xsl:template>

<xsl:template match="rule/message">
	<p><b>Message:</b> <xsl:value-of select="."/></p>
</xsl:template>

<xsl:template match="rule/detailedmessage">
	<p><b>Detailed message:</b> <xsl:value-of select="."/></p>
</xsl:template>

<xsl:template match="itemset">
	<p><b>Result item set:</b> <xsl:apply-templates select="name"/></p>
	<p><table border="1">
	<xsl:apply-templates select="fields"/>
	<xsl:apply-templates select="items"/>
	</table></p>
</xsl:template>

<xsl:template match="itemset/name">
	<xsl:value-of select="."/>
</xsl:template>

<xsl:template match="fields">
	<tr>
	<xsl:apply-templates select="field"/>
	</tr>
</xsl:template>

<xsl:template match="field/name">
	<th><xsl:value-of select="."/></th>
</xsl:template>

<xsl:template match="items/item">
	<tr>
	<xsl:apply-templates select="value"/>
	</tr>
</xsl:template>

<xsl:template match="item/value">
	<td><xsl:value-of select="."/></td>
</xsl:template>

</xsl:stylesheet>