/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.views.stacktrace;

import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.common.IMCStackTrace;
import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.collection.ArrayToolkit;
import com.oracle.jmc.common.collection.SimpleArray;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.ItemToolkit;
import com.oracle.jmc.common.util.MCFrame;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.ui.views.stacktrace.FrameSeparator;
import com.oracle.jmc.flightrecorder.ui.views.stacktrace.StacktraceFrame;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class StacktraceModel {
    private final IMemberAccessor<IMCStackTrace, IItem> accessor = ItemToolkit.accessor((IAttribute)JfrAttributes.EVENT_STACKTRACE);
    private final boolean threadRootAtTop;
    private final FrameSeparator frameSeparator;
    private final IItemCollection items;
    private Fork rootFork;
    static final IMCFrame UNKNOWN_FRAME = new MCFrame(null, null, null, IMCFrame.Type.UNKNOWN);
    private static final Comparator<FrameEntry> COUNT_CMP = new Comparator<FrameEntry>(){

        @Override
        public int compare(FrameEntry o1, FrameEntry o2) {
            return o2.items.size() - o1.items.size();
        }
    };

    StacktraceModel(boolean threadRootAtTop, FrameSeparator frameSeparator, IItemCollection items) {
        this.threadRootAtTop = threadRootAtTop;
        this.frameSeparator = frameSeparator;
        this.items = items;
    }

    public int hashCode() {
        return Objects.hash(this.frameSeparator, this.items, this.threadRootAtTop);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StacktraceModel) {
            StacktraceModel other = (StacktraceModel)obj;
            return this.threadRootAtTop == other.threadRootAtTop && this.frameSeparator.equals(other.frameSeparator) && this.items.equals(other.items);
        }
        return false;
    }

    Fork getRootFork() {
        if (this.rootFork == null) {
            this.rootFork = new Fork(ItemToolkit.asIterable((IItemCollection)this.items));
        }
        return this.rootFork;
    }

    private IMCFrame getFrame(IItem item, int atIndex) {
        IMCStackTrace st = (IMCStackTrace)this.accessor.getMember((Object)item);
        if (st != null) {
            List stack = st.getFrames();
            if (this.threadRootAtTop && atIndex == 0 && st.getTruncationState().isTruncated()) {
                return UNKNOWN_FRAME;
            }
            if (stack != null && stack.size() > atIndex) {
                return (IMCFrame)stack.get(this.threadRootAtTop ? stack.size() - 1 - atIndex : atIndex);
            }
        }
        return null;
    }

    private Stream<FrameEntry> getDistinctFrames(int atLevel, Iterable<? extends IItem> items) {
        HashMap<Object, SimpleArray> categories = new HashMap<Object, SimpleArray>(2000);
        Object lastCategory = null;
        SimpleArray lastCategoryEntries = null;
        for (IItem iItem : items) {
            IMCFrame frame = this.getFrame(iItem, atLevel);
            if (frame == null) continue;
            Object category = this.frameSeparator.getCategory(frame);
            if (!category.equals(lastCategory)) {
                lastCategoryEntries = (SimpleArray)categories.get(category);
                lastCategory = category;
                if (lastCategoryEntries == null) {
                    lastCategoryEntries = new SimpleArray((Object[])new FrameEntry[1]);
                    categories.put(category, lastCategoryEntries);
                }
            }
            StacktraceModel.findEntryForFrame((SimpleArray<FrameEntry>)lastCategoryEntries, (IMCFrame)frame, (FrameSeparator)this.frameSeparator).items.add((Object)iItem);
        }
        return categories.values().stream().flatMap(a -> StreamSupport.stream(Spliterators.spliterator(a.iterator(), (long)a.size(), 0), false));
    }

    private static FrameEntry findEntryForFrame(SimpleArray<FrameEntry> entries, IMCFrame frame, FrameSeparator frameSeparator) {
        for (FrameEntry e : entries) {
            if (!frameSeparator.compareDetails(e.frame, frame)) continue;
            return e;
        }
        FrameEntry newEntry = new FrameEntry(frame);
        entries.add((Object)newEntry);
        return newEntry;
    }

    private static int countFramesOnOrAbove(Branch branch) {
        if (branch != null) {
            return StacktraceModel.countFramesOnOrAbove(branch.getParentFork().getParentBranch()) + 1 + branch.getTailFrames().length;
        }
        return 0;
    }

    class Branch {
        private final Fork parentFork;
        private final StacktraceFrame firstFrame;
        private final int siblingIndex;
        private final int itemOffsetInFork;
        private Boolean hasTail;
        private StacktraceFrame[] tailFrames;
        private Fork branchEnding;

        private Branch(Fork parent, SimpleArray<IItem> items, IMCFrame frame, int siblingIndex, int itemOffsetInFork) {
            this.parentFork = parent;
            this.siblingIndex = siblingIndex;
            this.itemOffsetInFork = itemOffsetInFork;
            this.firstFrame = new StacktraceFrame(items, frame, this, 0);
        }

        int getItemOffsetInFork() {
            return this.itemOffsetInFork;
        }

        Fork getParentFork() {
            return this.parentFork;
        }

        boolean hasTail() {
            if (this.hasTail == null) {
                this.hasTail = this.calculateHasTail();
            }
            return this.hasTail;
        }

        Branch selectSibling(Integer siblingOffset) {
            if (siblingOffset == null) {
                this.parentFork.selectBranch(null);
                return null;
            }
            Branch[] siblings = this.parentFork.branches;
            int selectedSibling = Math.max(0, Math.min(siblings.length - 1, this.siblingIndex + siblingOffset));
            this.parentFork.selectBranch(selectedSibling);
            return siblings[selectedSibling];
        }

        StacktraceFrame getFirstFrame() {
            return this.firstFrame;
        }

        StacktraceFrame getLastFrame() {
            StacktraceFrame[] tail = this.getTailFrames();
            return tail.length > 0 ? tail[tail.length - 1] : this.firstFrame;
        }

        Stream<StacktraceFrame> getAllFrames() {
            return Stream.concat(Stream.of(this.firstFrame), Stream.of(this.getTailFrames()));
        }

        StacktraceFrame[] getTailFrames() {
            if (this.tailFrames == null) {
                this.tailFrames = this.buildTail();
            }
            return this.tailFrames;
        }

        Fork getEndFork() {
            if (this.branchEnding == null) {
                this.branchEnding = new Fork(this);
            }
            return this.branchEnding;
        }

        private boolean calculateHasTail() {
            int firstTailFrameIndex = StacktraceModel.countFramesOnOrAbove(this.parentFork.getParentBranch()) + 1;
            for (IItem item : this.firstFrame.items) {
                IMCFrame frame = StacktraceModel.this.getFrame(item, firstTailFrameIndex);
                if (frame == null) continue;
                return true;
            }
            return false;
        }

        private StacktraceFrame[] buildTail() {
            SimpleArray tail = new SimpleArray((Object[])new StacktraceFrame[5]);
            int nextIndex = StacktraceModel.countFramesOnOrAbove(this.parentFork.getParentBranch()) + 1;
            StacktraceFrame node = this.firstFrame;
            while (true) {
                ArrayList<Integer> removeIndexes = new ArrayList<Integer>();
                IMCFrame commonFrame = null;
                int itemIndex = 0;
                for (IItem item : node.items) {
                    IMCFrame frame = StacktraceModel.this.getFrame(item, nextIndex);
                    if (frame == null) {
                        removeIndexes.add(itemIndex);
                    } else if (commonFrame == null) {
                        commonFrame = frame;
                    } else if (StacktraceModel.this.frameSeparator.separate(commonFrame, frame)) {
                        return (StacktraceFrame[])tail.elements();
                    }
                    ++itemIndex;
                }
                if (commonFrame == null) {
                    return (StacktraceFrame[])tail.elements();
                }
                if (removeIndexes.isEmpty()) {
                    node = new StacktraceFrame(node.items, commonFrame, this, tail.size() + 1);
                } else {
                    IItem[] subset = (IItem[])ArrayToolkit.filter((Object[])((IItem[])node.items.elements()), removeIndexes);
                    node = new StacktraceFrame(subset, commonFrame, this, tail.size() + 1);
                }
                tail.add((Object)node);
                ++nextIndex;
            }
        }
    }

    class Fork {
        private final Branch parentBranch;
        private final Branch[] branches;
        private final int itemOffset;
        private final int itemsInFork;
        private Integer selectedBranchIndex;

        private Fork(Branch parentBranch) {
            this((Iterable<? extends IItem>)parentBranch.getLastFrame().items, parentBranch.getParentFork().itemOffset + parentBranch.itemOffsetInFork, parentBranch);
        }

        private Fork(Iterable<? extends IItem> items) {
            this(items, 0, null);
        }

        private Fork(Iterable<? extends IItem> items, int itemOffset, Branch parentBranch) {
            this.itemOffset = itemOffset;
            this.parentBranch = parentBranch;
            Spliterator branchHeadFrames = ((Stream)StacktraceModel.this.getDistinctFrames(StacktraceModel.countFramesOnOrAbove(parentBranch), items).sequential()).sorted(COUNT_CMP).spliterator();
            int estimateBranchCount = (int)Math.min(10000L, branchHeadFrames.estimateSize());
            int itemsInFork = 0;
            SimpleArray branches = new SimpleArray((Object[])new Branch[estimateBranchCount]);
            Iterator iterator = Spliterators.iterator(branchHeadFrames);
            while (iterator.hasNext()) {
                FrameEntry fe = (FrameEntry)iterator.next();
                Branch b = new Branch(this, fe.items, fe.frame, branches.size(), itemsInFork);
                itemsInFork += fe.items.size();
                branches.add((Object)b);
            }
            this.selectedBranchIndex = branches.size() > 0 ? Integer.valueOf(0) : null;
            this.branches = (Branch[])branches.elements();
            this.itemsInFork = itemsInFork;
        }

        int getItemOffset() {
            return this.itemOffset;
        }

        int getItemsInFork() {
            return this.itemsInFork;
        }

        Branch getParentBranch() {
            return this.parentBranch;
        }

        int getBranchCount() {
            return this.branches.length;
        }

        Branch getSelectedBranch() {
            return this.selectedBranchIndex != null ? this.branches[this.selectedBranchIndex] : null;
        }

        Branch getBranch(int branchIndex) {
            return this.branches[this.selectedBranchIndex];
        }

        Stream<StacktraceFrame> getFirstFrames() {
            return Stream.of(this.branches).map(Branch::getFirstFrame);
        }

        private void selectBranch(Integer branchIndex) {
            if (this.parentBranch != null) {
                this.parentBranch.selectSibling(0);
            }
            this.selectedBranchIndex = branchIndex;
        }
    }

    private static class FrameEntry {
        final SimpleArray<IItem> items = new SimpleArray((Object[])new IItem[3]);
        final IMCFrame frame;

        FrameEntry(IMCFrame frame) {
            this.frame = frame;
        }
    }
}

