/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.views.stacktrace;

import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import java.util.Objects;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

class FrameSeparator {
    private final boolean distinguishFramesByOptimization;
    private final FrameCategorization categorization;

    FrameSeparator(FrameCategorization categorization, boolean distinguishFramesByOptimization) {
        this.categorization = categorization;
        this.distinguishFramesByOptimization = distinguishFramesByOptimization;
    }

    FrameCategorization getCategorization() {
        return this.categorization;
    }

    boolean isDistinguishFramesByOptimization() {
        return this.distinguishFramesByOptimization;
    }

    boolean separate(IMCFrame frameA, IMCFrame frameB) {
        return !this.compareDetails(frameA, frameB) || !this.getCategory(frameA).equals(this.getCategory(frameB));
    }

    Object getCategory(IMCFrame frame) {
        switch (this.categorization) {
            case PACKAGE: {
                return frame.getMethod().getType().getPackageName();
            }
            case CLASS: {
                return frame.getMethod().getType();
            }
        }
        return frame.getMethod();
    }

    boolean compareDetails(IMCFrame frameA, IMCFrame frameB) {
        if (this.distinguishFramesByOptimization && !Objects.equals(frameA.getType(), frameB.getType())) {
            return false;
        }
        if (this.categorization == FrameCategorization.BCI) {
            return Objects.equals(frameA.getBCI(), frameB.getBCI());
        }
        if (this.categorization == FrameCategorization.LINE) {
            return Objects.equals(frameA.getFrameLineNumber(), frameB.getFrameLineNumber());
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.categorization, this.distinguishFramesByOptimization});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FrameSeparator) {
            FrameSeparator other = (FrameSeparator)obj;
            return this.categorization == other.categorization && this.distinguishFramesByOptimization == other.distinguishFramesByOptimization;
        }
        return false;
    }

    static enum FrameCategorization {
        BCI(Messages.STACKTRACE_VIEW_BYTE_CODE_INDEX),
        LINE(Messages.STACKTRACE_VIEW_LINE_NUMBER),
        METHOD(Messages.STACKTRACE_VIEW_METHOD),
        CLASS(Messages.STACKTRACE_VIEW_CLASS),
        PACKAGE(Messages.STACKTRACE_VIEW_PACKAGE);

        private final String localizedName;

        private FrameCategorization(String localizedName) {
            this.localizedName = localizedName;
        }
    }

    static class FrameSeparatorManager
    implements IMenuListener {
        private final Runnable onChangeCallback;
        private FrameSeparator current;

        FrameSeparatorManager(Runnable onChangeCallback, FrameSeparator initial) {
            this.onChangeCallback = onChangeCallback;
            this.current = initial;
        }

        FrameSeparator getFrameSeparator() {
            return this.current;
        }

        MenuManager createMenu() {
            MenuManager menu = new MenuManager(Messages.STACKTRACE_VIEW_DISTINGUISH_FRAMES_BY);
            menu.setRemoveAllWhenShown(true);
            menu.addMenuListener((IMenuListener)this);
            return menu;
        }

        public void menuAboutToShow(IMenuManager manager) {
            Action typeAction = new Action(Messages.STACKTRACE_VIEW_OPTIMIZATION_TYPE, 2){

                public void run() {
                    current = new FrameSeparator(current.categorization, this.isChecked());
                    onChangeCallback.run();
                }
            };
            typeAction.setChecked(this.current.distinguishFramesByOptimization);
            manager.add((IAction)typeAction);
            manager.add((IContributionItem)new Separator());
            FrameCategorization[] frameCategorizationArray = FrameCategorization.values();
            int n = frameCategorizationArray.length;
            int n2 = 0;
            while (n2 < n) {
                final FrameCategorization l = frameCategorizationArray[n2];
                Action levelOption = new Action(l.localizedName, 8){

                    public void run() {
                        if (this.isChecked() && current.categorization != l) {
                            current = new FrameSeparator(l, current.distinguishFramesByOptimization);
                            onChangeCallback.run();
                        }
                    }
                };
                levelOption.setChecked(this.current.categorization == l);
                manager.add((IAction)levelOption);
                ++n2;
            }
        }
    }
}

