/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.selection;

import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.common.IMCMethod;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.util.FormatToolkit;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.selection.FlavoredSelectionBase;
import com.oracle.jmc.flightrecorder.ui.selection.IFilterFlavor;
import com.oracle.jmc.flightrecorder.ui.selection.IItemStreamFlavor;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Stream;

public class StacktraceFrameSelection
extends FlavoredSelectionBase {
    private IMCFrame frame;
    private IItemCollection selectedItems;

    public StacktraceFrameSelection(IMCFrame frame, IItemCollection selectedItems, String name) {
        super(name);
        this.frame = frame;
        this.selectedItems = selectedItems;
    }

    @Override
    public Stream<IItemStreamFlavor> getFlavors(IItemFilter filter, IItemCollection items, List<IAttribute<?>> attributes) {
        Stream.Builder<IItemStreamFlavor> builder = Stream.builder();
        builder.add(IItemStreamFlavor.build(MessageFormat.format(Messages.FLAVOR_SELECTED_EVENTS, ItemCollectionToolkit.getDescription(this.selectedItems)), this.selectedItems));
        builder.add(StacktraceFrameSelection.buildContainsMethodFlavor(this.frame.getMethod(), items));
        return builder.build();
    }

    private static IFilterFlavor buildContainsMethodFlavor(final IMCMethod method, final IItemCollection items) {
        return new IFilterFlavor(){

            @Override
            public String getName() {
                return MessageFormat.format(Messages.FLAVOR_CONTAINS, JdkAttributes.STACK_TRACE_STRING.getName(), FormatToolkit.getHumanReadable((IMCMethod)method));
            }

            @Override
            public IItemCollection evaluate() {
                return items.apply(this.getFilter());
            }

            @Override
            public IItemFilter getFilter() {
                return ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_STRING, (String)FormatToolkit.getHumanReadable((IMCMethod)method));
            }
        };
    }
}

