/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.selection;

import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.item.RangeMatchPolicy;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.common.ItemHistogram;
import com.oracle.jmc.flightrecorder.ui.common.ItemList;
import com.oracle.jmc.flightrecorder.ui.common.ItemRow;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.selection.ChartSelection;
import com.oracle.jmc.flightrecorder.ui.selection.IFlavoredSelection;
import com.oracle.jmc.flightrecorder.ui.selection.ItemBackedSelection;
import com.oracle.jmc.flightrecorder.ui.selection.RangedChartSelection;
import com.oracle.jmc.flightrecorder.ui.selection.SelectionStore;
import com.oracle.jmc.flightrecorder.ui.selection.TypeSelection;
import com.oracle.jmc.ui.charts.XYChart;
import com.oracle.jmc.ui.handlers.ActionToolkit;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.actions.SelectionProviderAction;

public final class SelectionStoreActionToolkit {
    private SelectionStoreActionToolkit() {
    }

    public static void addSelectionStoreActions(StructuredViewer viewer, Supplier<SelectionStore> store, Supplier<IFlavoredSelection> selection, IContributionManager cm) {
        if (cm.find("group.edit") == null) {
            cm.add((IContributionItem)new Separator("group.edit"));
        }
        Runnable storeSelection = () -> ((SelectionStore)store.get()).addSelection((IFlavoredSelection)selection.get());
        SelectionStoreAction storeSelectionAction = viewer == null ? ActionToolkit.action((Runnable)storeSelection, (String)Messages.STORE_SELECTION_ACTION) : new SelectionStoreAction((ISelectionProvider)viewer, storeSelection, Messages.STORE_SELECTION_ACTION);
        Runnable storeAndSetSelection = () -> ((SelectionStore)store.get()).addAndSetAsCurrentSelection((IFlavoredSelection)selection.get());
        SelectionStoreAction storeAndSetSelectionAction = viewer == null ? ActionToolkit.action((Runnable)storeAndSetSelection, (String)Messages.STORE_AND_ACTIVATE_SELECTION_ACTION) : new SelectionStoreAction((ISelectionProvider)viewer, storeAndSetSelection, Messages.STORE_AND_ACTIVATE_SELECTION_ACTION);
        cm.appendToGroup("group.edit", (IAction)storeSelectionAction);
        cm.appendToGroup("group.edit", (IAction)storeAndSetSelectionAction);
    }

    public static void addSelectionStoreActions(StructuredViewer viewer, Supplier<Set<IType<?>>> typeSupplier, SelectionStore store, String selectionName, IContributionManager cm) {
        SelectionStoreActionToolkit.addSelectionStoreActions(viewer, () -> store, () -> new TypeSelection((Set)typeSupplier.get(), selectionName), cm);
    }

    public static void addSelectionStoreActions(StructuredViewer viewer, SelectionStore store, Supplier<IItemCollection> itemStreamSupplier, String selectionName, IContributionManager cm) {
        SelectionStoreActionToolkit.addSelectionStoreActions(viewer, () -> store, () -> new ItemBackedSelection((IItemCollection)itemStreamSupplier.get(), selectionName), cm);
    }

    public static void addSelectionStoreActions(StructuredViewer viewer, Supplier<SelectionStore> store, Supplier<IItemCollection> itemStreamSupplier, String selectionName, IContributionManager cm) {
        SelectionStoreActionToolkit.addSelectionStoreActions(viewer, store, () -> new ItemBackedSelection((IItemCollection)itemStreamSupplier.get(), selectionName), cm);
    }

    public static void addSelectionStoreActions(SelectionStore store, ItemList list, String selectionName, IContributionManager cm) {
        SelectionStoreActionToolkit.addSelectionStoreActions((StructuredViewer)list.getManager().getViewer(), store, () -> ItemCollectionToolkit.build(list.getSelection().get()), selectionName, cm);
    }

    public static void addSelectionStoreActions(SelectionStore store, ItemHistogram histogram, String selectionName, IContributionManager cm) {
        SelectionStoreActionToolkit.addSelectionStoreActions((StructuredViewer)histogram.getManager().getViewer(), store, () -> histogram.getSelection().getItems(), selectionName, cm);
    }

    public static void addSelectionStoreActions(SelectionStore store, XYChart chart, IAttribute<IQuantity> xAttribute, String selectionName, IContributionManager cm) {
        SelectionStoreActionToolkit.addSelectionStoreActions(store, () -> chart, xAttribute, selectionName, cm);
    }

    public static void addSelectionStoreActions(SelectionStore store, Supplier<XYChart> chartSupplier, IAttribute<IQuantity> xAttribute, String selectionName, IContributionManager cm) {
        SelectionStoreActionToolkit.addSelectionStoreActions(null, () -> store, () -> new ChartSelection(selectionName, ItemRow.getSelection((XYChart)chartSupplier.get()), ((XYChart)chartSupplier.get()).getSelectionStart(), ((XYChart)chartSupplier.get()).getSelectionEnd(), xAttribute), cm);
    }

    public static void addSelectionStoreRangeActions(SelectionStore store, XYChart chart, IAttribute<IRange<IQuantity>> xRangeAttribute, String selectionName, IContributionManager cm) {
        SelectionStoreActionToolkit.addSelectionStoreActions(null, () -> store, () -> new RangedChartSelection(selectionName, ItemRow.getSelection(chart), (IRange<IQuantity>)chart.getSelectionRange(), RangeMatchPolicy.CONTAINED_IN_CLOSED, xRangeAttribute), cm);
    }

    private static class SelectionStoreAction
    extends SelectionProviderAction {
        private Runnable action;

        protected SelectionStoreAction(ISelectionProvider provider, Runnable action, String name) {
            super(provider, name);
            this.action = action;
            this.setEnabled(false);
        }

        public void selectionChanged(IStructuredSelection selection) {
            this.setEnabled(!selection.isEmpty());
        }

        public void run() {
            this.action.run();
        }
    }
}

