/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.selection;

import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.JfrPropertySheet;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.selection.FlavoredSelectionBase;
import com.oracle.jmc.flightrecorder.ui.selection.IItemStreamFlavor;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Stream;

public class ItemBackedSelection
extends FlavoredSelectionBase {
    private final IItemCollection selectedItems;

    public ItemBackedSelection(IItemCollection selectedItems, String name) {
        super(name);
        this.selectedItems = selectedItems;
    }

    @Override
    public Stream<IItemStreamFlavor> getFlavors(IItemFilter filter, IItemCollection items, List<IAttribute<?>> dstAttributes) {
        boolean itemsApplicableOnPage = ItemCollectionToolkit.filterIfNotNull(this.selectedItems, filter).hasItems();
        Stream.Builder<IItemStreamFlavor> builder = Stream.builder();
        IItemStreamFlavor selectedEventsFlavor = IItemStreamFlavor.build(MessageFormat.format(Messages.FLAVOR_SELECTED_EVENTS, ItemCollectionToolkit.getDescription(this.selectedItems)), this.selectedItems);
        if (itemsApplicableOnPage) {
            builder.accept(selectedEventsFlavor);
        }
        IItemCollection dstItems = ItemCollectionToolkit.filterIfNotNull(items, filter);
        JfrPropertySheet.calculatePersistableFilterFlavors(this.selectedItems, dstItems, items, dstAttributes).forEach(builder::accept);
        if (!itemsApplicableOnPage) {
            builder.accept(selectedEventsFlavor);
        }
        return builder.build();
    }
}

