/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.preferences;

import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.ui.misc.QuantityKindProposal;
import java.util.LinkedList;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeneralPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button noDefaultRadio;
    private Button wholeRadio;
    private Button timespanRadio;
    private final LinkedList<CheckBox> checkBoxes = new LinkedList();
    private Text timespanValue;
    private Text selectionStoreValue;
    private Text itemListValue;
    private Text propertiesArrayStringSizeValue;
    private Text editorRuleEvaluationThreadsValue;

    public GeneralPage() {
        this.setPreferenceStore(FlightRecorderUI.getDefault().getPreferenceStore());
        this.setDescription(Messages.PREFERENCES_GENERAL_SETTINGS_TEXT);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Button removeRecordingsCheckbox = this.createRemoveRecordingsCheckBox(container);
        removeRecordingsCheckbox.setLayoutData((Object)new GridData(4, 4, false, false));
        Button confirmRemoveTemplateCheckbox = this.createConfirmRemoveTemplateCheckBox(container);
        confirmRemoveTemplateCheckbox.setLayoutData((Object)new GridData(4, 4, false, false));
        Button showMonitoringWarningCheckbox = this.createShowMonitoringWarningCheckBox(container);
        showMonitoringWarningCheckbox.setLayoutData((Object)new GridData(4, 4, false, false));
        Button enableAnalysisCheckbox = this.createEnableAnalysisCheckBox(container);
        enableAnalysisCheckbox.setLayoutData((Object)new GridData(4, 4, false, false));
        Button includeExperimental = this.createIncludeExperimentalEventsAndFieldsCheckBox(container);
        includeExperimental.setLayoutData((Object)new GridData(4, 4, false, false));
        Group dumpDefaultGroup = new Group(container, 0);
        dumpDefaultGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        dumpDefaultGroup.setText(Messages.DUMP_RECORDING_DEFAULT_TIMESPAN_TO_DUMP);
        dumpDefaultGroup.setLayout((Layout)new GridLayout());
        this.noDefaultRadio = new Button((Composite)dumpDefaultGroup, 16);
        this.noDefaultRadio.setText(Messages.DUMP_RECORDING_NO_DEFAULT);
        this.wholeRadio = new Button((Composite)dumpDefaultGroup, 16);
        this.wholeRadio.setText(Messages.DUMP_RECORDING_WHOLE);
        this.timespanRadio = new Button((Composite)dumpDefaultGroup, 16);
        this.timespanRadio.setText(Messages.DUMP_RECORDING_TIMESPAN);
        Composite defaultTimespanContainer = new Composite(container, 0);
        defaultTimespanContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        defaultTimespanContainer.setLayout((Layout)new GridLayout(2, false));
        Label timespanLabel = new Label(defaultTimespanContainer, 0);
        timespanLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        timespanLabel.setText(Messages.DUMP_RECORDING_TIMESPAN_VALUE);
        this.timespanValue = new Text(defaultTimespanContainer, 2048);
        this.timespanValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        QuantityKindProposal.install((Text)this.timespanValue, (KindOfQuantity)UnitLookup.TIMESPAN);
        Label selectionStoreLabel = new Label(defaultTimespanContainer, 0);
        selectionStoreLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        selectionStoreLabel.setText(Messages.STORED_SELECTIONS_SIZE_PREF);
        this.selectionStoreValue = new Text(defaultTimespanContainer, 2048);
        this.selectionStoreValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        QuantityKindProposal.install((Text)this.selectionStoreValue, (KindOfQuantity)UnitLookup.NUMBER);
        Label itemListLabel = new Label(defaultTimespanContainer, 0);
        itemListLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        itemListLabel.setText(Messages.ITEM_LIST_SIZE_PREF);
        itemListLabel.setToolTipText(Messages.ITEM_LIST_SIZE_PREF_TOOLTIP);
        this.itemListValue = new Text(defaultTimespanContainer, 2048);
        this.itemListValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        QuantityKindProposal.install((Text)this.itemListValue, (KindOfQuantity)UnitLookup.NUMBER);
        Label propertiesArrayStringSizeLabel = new Label(defaultTimespanContainer, 0);
        propertiesArrayStringSizeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        propertiesArrayStringSizeLabel.setText(Messages.PREFERENCES_PROPERTIES_ARRAY_STRING_SIZE_TEXT);
        propertiesArrayStringSizeLabel.setToolTipText(Messages.PREFERENCES_PROPERTIES_ARRAY_STRING_SIZE_TOOLTIP);
        this.propertiesArrayStringSizeValue = new Text(defaultTimespanContainer, 2048);
        this.propertiesArrayStringSizeValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        QuantityKindProposal.install((Text)this.propertiesArrayStringSizeValue, (KindOfQuantity)UnitLookup.NUMBER);
        Label editorRuleEvaluationThreadsLabel = new Label(defaultTimespanContainer, 0);
        editorRuleEvaluationThreadsLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editorRuleEvaluationThreadsLabel.setText(Messages.PREFERENCES_EVALUATION_THREAD_NUMBER_TEXT);
        editorRuleEvaluationThreadsLabel.setToolTipText(Messages.PREFERENCES_EVALUATION_THREAD_NUMBER_TOOLTIP);
        this.editorRuleEvaluationThreadsValue = new Text(defaultTimespanContainer, 2048);
        this.editorRuleEvaluationThreadsValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        QuantityKindProposal.install((Text)this.editorRuleEvaluationThreadsValue, (KindOfQuantity)UnitLookup.NUMBER);
        this.loadDumpTypeFromPrefStore(false);
        this.loadTimespanFromPrefStore(false);
        this.loadSelectionStoreSizeFromPrefStore(false);
        this.loadItemListSizeFromPrefStore(false);
        this.loadPropertiesArrayStringSizeFromPrefStore(false);
        this.loadEditorRuleEvaluationThreadsFromPrefStore(false);
        this.timespanValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralPage.this.validatePage();
            }
        });
        this.selectionStoreValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralPage.this.validatePage();
            }
        });
        this.itemListValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralPage.this.validatePage();
            }
        });
        this.propertiesArrayStringSizeValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralPage.this.validatePage();
            }
        });
        this.editorRuleEvaluationThreadsValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralPage.this.validatePage();
            }
        });
        return container;
    }

    private void validatePage() {
        String error = GeneralPage.validateSelectionStoreSize(this.selectionStoreValue.getText());
        this.setErrorMessage(error);
        String error2 = GeneralPage.validateItemListSize(this.selectionStoreValue.getText());
        if (error == null) {
            this.setErrorMessage(error2);
        }
        String error3 = FlightRecorderUI.validateDumpTimespan(this.timespanValue.getText());
        if (error == null && error2 == null) {
            this.setErrorMessage(error3);
        }
        String error4 = GeneralPage.validateNumEvaluationThreads(this.editorRuleEvaluationThreadsValue.getText());
        if (error == null && error2 == null && error3 == null) {
            this.setErrorMessage(error4);
        }
        this.setValid(error == null && error2 == null && error3 == null && error4 == null);
    }

    public static String validateNumEvaluationThreads(String text) {
        try {
            ITypedQuantity size = UnitLookup.NUMBER.parseInteractive(text);
            if (size.longValue() < 1L) {
                return Messages.PREFERENCES_EVALUATION_THREAD_NUMBER_LESS_THAN_ONE;
            }
        }
        catch (QuantityConversionException qce) {
            return NLS.bind((String)Messages.PREFERENCES_EVALUATION_THREAD_NUMBER_UNPARSEABLE, (Object)qce.getLocalizedMessage());
        }
        return null;
    }

    public static String validateSelectionStoreSize(String text) {
        try {
            ITypedQuantity size = UnitLookup.NUMBER.parseInteractive(text);
            if (size.longValue() <= 0L) {
                return Messages.STORED_SELECTIONS_SIZE_LESS_THAN_ZERO;
            }
        }
        catch (QuantityConversionException qce) {
            return NLS.bind((String)Messages.STORED_SELECTIONS_SIZE_UNPARSABLE, (Object)qce.getLocalizedMessage());
        }
        return null;
    }

    public static String validateItemListSize(String text) {
        try {
            ITypedQuantity size = UnitLookup.NUMBER.parseInteractive(text);
            if (size.longValue() <= 0L) {
                return Messages.ITEM_LIST_SIZE_LESS_THAN_ZERO;
            }
        }
        catch (QuantityConversionException qce) {
            return NLS.bind((String)Messages.ITEM_LIST_SIZE_UNPARSABLE, (Object)qce.getLocalizedMessage());
        }
        return null;
    }

    private void loadDumpTypeFromPrefStore(boolean loadDefault) {
        int dumpType = loadDefault ? this.getPreferenceStore().getDefaultInt("flightrecorder.controlpanel.default.dump.type") : this.getPreferenceStore().getInt("flightrecorder.controlpanel.default.dump.type");
        this.timespanRadio.setSelection(dumpType == 1);
        this.wholeRadio.setSelection(dumpType == 2);
        this.noDefaultRadio.setSelection(dumpType == 0);
    }

    private void loadTimespanFromPrefStore(boolean loadDefault) {
        String timespan = loadDefault ? this.getPreferenceStore().getDefaultString("flightrecorder.controlpanel.default.dump.timespan") : this.getPreferenceStore().getString("flightrecorder.controlpanel.default.dump.timespan");
        this.timespanValue.setText(FlightRecorderUI.parseDumpTimespan(timespan).interactiveFormat());
    }

    private void loadSelectionStoreSizeFromPrefStore(boolean loadDefault) {
        String size = loadDefault ? this.getPreferenceStore().getDefaultString("flightrecorder.selectionstore.size") : this.getPreferenceStore().getString("flightrecorder.selectionstore.size");
        this.selectionStoreValue.setText(FlightRecorderUI.parseSelectionStoreSize(size).interactiveFormat());
    }

    private void loadItemListSizeFromPrefStore(boolean loadDefault) {
        String size = loadDefault ? this.getPreferenceStore().getDefaultString("flightrecorder.itemlist.size") : this.getPreferenceStore().getString("flightrecorder.itemlist.size");
        this.itemListValue.setText(FlightRecorderUI.parseItemListSize(size).interactiveFormat());
    }

    private void loadPropertiesArrayStringSizeFromPrefStore(boolean loadDefault) {
        String size = loadDefault ? this.getPreferenceStore().getDefaultString("flightrecorder.properties.array.string.size") : this.getPreferenceStore().getString("flightrecorder.properties.array.string.size");
        this.propertiesArrayStringSizeValue.setText(FlightRecorderUI.parseItemListSize(size).interactiveFormat());
    }

    private void loadEditorRuleEvaluationThreadsFromPrefStore(boolean loadDefault) {
        String size = loadDefault ? this.getPreferenceStore().getDefaultString("flightrecorder.rule.evaluation.threads") : this.getPreferenceStore().getString("flightrecorder.rule.evaluation.threads");
        this.editorRuleEvaluationThreadsValue.setText(FlightRecorderUI.parseItemListSize(size).interactiveFormat());
    }

    private Button createRemoveRecordingsCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_REMOVE_FINISHED_RECORDING_TEXT, "flightRecorder.removeFinishedRecording");
    }

    private Button createConfirmRemoveTemplateCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_CONFIRM_REMOVE_TEMPLATE_TEXT, "flightRecorder.confirmRemoveTemplate");
    }

    private Button createShowMonitoringWarningCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_SHOW_MONITORING_WARNING_TEXT, "flightrecorder.controlpanel.show.monitoring.warning");
    }

    private Button createEnableAnalysisCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_ENABLE_RECORDING_ANALYSIS, "flightrecorder.controlpanel.enable.recording.analysis");
    }

    private Button createIncludeExperimentalEventsAndFieldsCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_INCLUDE_EXPERIMENTAL_EVENTS_AND_FIELDS, "flightrecorder.ui.includeExperimentalEventsAndFields");
    }

    protected void performDefaults() {
        for (CheckBox checkBox : this.checkBoxes) {
            checkBox.setToDefault();
        }
        this.loadDumpTypeFromPrefStore(true);
        this.loadTimespanFromPrefStore(true);
        this.loadSelectionStoreSizeFromPrefStore(true);
        this.loadItemListSizeFromPrefStore(true);
        this.loadPropertiesArrayStringSizeFromPrefStore(true);
        this.loadEditorRuleEvaluationThreadsFromPrefStore(true);
        super.performDefaults();
    }

    private Button createCheckBox(Composite parent, String text, String name) {
        Button checkBox = new Button(parent, 32);
        checkBox.setSelection(this.getPreferenceStore().getBoolean(name));
        checkBox.setText(text);
        this.checkBoxes.add(new CheckBox(checkBox, name));
        return checkBox;
    }

    public boolean performOk() {
        ITypedQuantity size;
        try {
            ITypedQuantity timespan = UnitLookup.TIMESPAN.parseInteractive(this.timespanValue.getText());
            this.getPreferenceStore().setValue("flightrecorder.controlpanel.default.dump.timespan", timespan.persistableString());
        }
        catch (QuantityConversionException qce) {
            this.setErrorMessage(qce.getLocalizedMessage());
            return false;
        }
        try {
            size = UnitLookup.NUMBER.parseInteractive(this.selectionStoreValue.getText());
            this.getPreferenceStore().setValue("flightrecorder.selectionstore.size", size.persistableString());
        }
        catch (QuantityConversionException qce) {
            this.setErrorMessage(qce.getLocalizedMessage());
            return false;
        }
        try {
            size = UnitLookup.NUMBER.parseInteractive(this.itemListValue.getText());
            this.getPreferenceStore().setValue("flightrecorder.itemlist.size", size.persistableString());
        }
        catch (QuantityConversionException qce) {
            this.setErrorMessage(qce.getLocalizedMessage());
            return false;
        }
        try {
            size = UnitLookup.NUMBER.parseInteractive(this.propertiesArrayStringSizeValue.getText());
            this.getPreferenceStore().setValue("flightrecorder.properties.array.string.size", size.persistableString());
        }
        catch (QuantityConversionException qce) {
            this.setErrorMessage(qce.getLocalizedMessage());
            return false;
        }
        try {
            size = UnitLookup.NUMBER.parseInteractive(this.editorRuleEvaluationThreadsValue.getText());
            size = UnitLookup.NUMBER_UNITY.quantity(size.clampedFloorIn((IUnit)UnitLookup.NUMBER_UNITY));
            this.getPreferenceStore().setValue("flightrecorder.rule.evaluation.threads", size.persistableString());
        }
        catch (QuantityConversionException qce) {
            this.setErrorMessage(qce.getLocalizedMessage());
            return false;
        }
        this.setErrorMessage(null);
        if (this.timespanRadio.getSelection()) {
            this.getPreferenceStore().setValue("flightrecorder.controlpanel.default.dump.type", 1);
        } else if (this.wholeRadio.getSelection()) {
            this.getPreferenceStore().setValue("flightrecorder.controlpanel.default.dump.type", 2);
        } else {
            this.getPreferenceStore().setValue("flightrecorder.controlpanel.default.dump.type", 0);
        }
        for (CheckBox checkBox : this.checkBoxes) {
            this.getPreferenceStore().setValue(checkBox.m_preference, checkBox.m_button.getSelection());
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private class CheckBox {
        private final Button m_button;
        private final String m_preference;

        public CheckBox(Button button, String preference) {
            this.m_button = button;
            this.m_preference = preference;
        }

        public void setToDefault() {
            GeneralPage.this.getPreferenceStore().setToDefault(this.m_preference);
            this.m_button.setSelection(GeneralPage.this.getPreferenceStore().getBoolean(this.m_preference));
        }
    }
}

