/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages.itemhandler;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.ItemToolkit;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.unit.LinearKindOfQuantity;
import com.oracle.jmc.common.util.StateToolkit;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.common.FilterComponent;
import com.oracle.jmc.flightrecorder.ui.common.ItemHistogram;
import com.oracle.jmc.flightrecorder.ui.common.ItemList;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.pages.itemhandler.AttributeComponentConfiguration;
import com.oracle.jmc.flightrecorder.ui.pages.itemhandler.ItemChart;
import com.oracle.jmc.flightrecorder.ui.pages.itemhandler.TriConsumer;
import com.oracle.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.ColumnMenusFactory;
import com.oracle.jmc.ui.column.TableSettings;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

class ItemListAndChart {
    private static final String LIST_SETTINGS = "listSettings";
    private static final String CHART_SETTINGS = "chartSettings";
    private static final String SELECTED_SUBTAB = "selectedSubTab";
    private static final String ITEM_LIST_FILTER = "itemListFilter";
    private ItemList itemList;
    private final ItemChart itemChart;
    private MCContextMenuManager listContextMenuManager;
    private final CTabFolder tabFolder;
    private final Consumer<IItemCollection> selectionListener;
    private final CTabItem listTab;
    private final IPageContainer controller;
    private String pageName;
    private ToolBarManager toolBarManager;
    private FilterComponent itemListFilterComponent;
    private StreamModel streamModel;
    private FormToolkit toolkit;
    private IItemFilter inputFilter;
    private IItemFilter itemListFilter;
    private IItemCollection listItems;

    public ItemListAndChart(FormToolkit toolkit, IPageContainer controller, StreamModel streamModel, IItemFilter filter, IItemFilter itemListFilter, String pageName, Composite parent, IState state, AttributeComponentConfiguration acc, Consumer<IItemCollection> selectionListener) {
        this.toolkit = toolkit;
        this.controller = controller;
        this.streamModel = streamModel;
        this.inputFilter = filter;
        this.itemListFilter = itemListFilter;
        this.pageName = pageName;
        this.selectionListener = selectionListener;
        this.tabFolder = new CTabFolder(parent, 0);
        toolkit.adapt((Composite)this.tabFolder);
        this.toolBarManager = new ToolBarManager(256);
        this.tabFolder.setTopRight((Control)this.toolBarManager.createControl((Composite)this.tabFolder));
        this.listTab = new CTabItem(this.tabFolder, 0);
        this.listTab.setText(Messages.ITEMHANDLER_LIST_TITLE);
        this.listTab.setImage(FlightRecorderUI.getDefault().getImage("table.gif"));
        this.listTab.setToolTipText(Messages.ITEMHANDLER_LIST_DESCRIPTION);
        this.buildList(state, acc);
        CTabItem chartTab = new CTabItem(this.tabFolder, 0);
        chartTab.setText(Messages.ITEMHANDLER_CHART_TITLE);
        chartTab.setImage(FlightRecorderUI.getDefault().getImage("chart_bar_16x16.gif"));
        chartTab.setToolTipText(Messages.ITEMHANDLER_CHART_DESCRIPTION);
        this.itemChart = new ItemChart((Composite)this.tabFolder, toolkit, pageName, acc, state != null ? state.getChild(CHART_SETTINGS) : null, controller);
        chartTab.setControl(this.itemChart.getControl());
        this.tabFolder.setSelection(StateToolkit.readInt((IState)state, (String)SELECTED_SUBTAB, (Integer)0).intValue());
    }

    private void buildList(IState state, AttributeComponentConfiguration acc) {
        this.listItems = this.streamModel.getItems().apply(this.inputFilter);
        ItemList.ItemListBuilder itemListBuilder = new ItemList.ItemListBuilder();
        acc.getAllAttributes().entrySet().forEach(entry -> {
            String combinedId = entry.getKey();
            IAttribute<?> a = entry.getValue();
            ContentType contentType = a.getContentType();
            IMemberAccessor accessor = ItemToolkit.accessor(a);
            itemListBuilder.addColumn(combinedId, a.getName(), a.getDescription(), contentType instanceof LinearKindOfQuantity, accessor);
        });
        TableSettings itemListSettings = TableSettings.forStateAndColumns((IState)(state != null ? state.getChild(LIST_SETTINGS) : null), acc.getAllAttributes().keySet(), acc.getCommonAttributes().keySet());
        Composite listComposite = this.toolkit.createComposite((Composite)this.tabFolder);
        listComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        this.itemList = itemListBuilder.buildWithoutBorder(listComposite, itemListSettings);
        this.listTab.setControl((Control)listComposite);
        this.itemList.getManager().getViewer().addSelectionChangedListener(e -> this.selectionListener.accept(this.getListSelection()));
        ColumnManager columnsManager = this.itemList.getManager();
        this.listContextMenuManager = MCContextMenuManager.create((Control)columnsManager.getViewer().getControl());
        ColumnMenusFactory.addDefaultMenus((ColumnManager)columnsManager, (MCContextMenuManager)this.listContextMenuManager);
        SelectionStoreActionToolkit.addSelectionStoreActions(this.controller.getSelectionStore(), this.itemList, NLS.bind((String)Messages.ITEMHANDLER_LOG_SELECTION, (Object)this.pageName), (IContributionManager)this.listContextMenuManager);
        this.itemListFilterComponent = FilterComponent.createFilterComponent(this.itemList, this.itemListFilter, this.listItems, this.controller.getSelectionStore()::getSelections, this::onFilterChange);
        this.listContextMenuManager.add(this.itemListFilterComponent.getShowFilterAction());
        this.listContextMenuManager.add(this.itemListFilterComponent.getShowSearchAction());
        if (state != null) {
            this.itemListFilterComponent.loadState(state.getChild(ITEM_LIST_FILTER));
        }
        this.onFilterChange(this.itemListFilter);
    }

    private void onFilterChange(IItemFilter itemListFilter) {
        this.itemListFilter = itemListFilter;
        this.itemListFilterComponent.filterChangeHelper(itemListFilter, this.itemList, this.listItems.apply(this.inputFilter));
    }

    private IItemCollection getListSelection() {
        return ItemCollectionToolkit.build(this.itemList.getSelection().get());
    }

    public void saveState(IWritableState state) {
        StateToolkit.writeInt((IWritableState)state, (String)SELECTED_SUBTAB, (Integer)this.tabFolder.getSelectionIndex());
        this.itemList.getManager().getSettings().saveState(state.createChild(LIST_SETTINGS));
        this.itemChart.saveState(state.createChild(CHART_SETTINGS));
        this.itemListFilterComponent.saveState(state.createChild(ITEM_LIST_FILTER));
    }

    public Control getControl() {
        return this.tabFolder;
    }

    void setVisibleRange(IRange<IQuantity> visibleRange) {
        this.itemChart.setVisibleRange(visibleRange);
    }

    IRange<IQuantity> getVisibleRange() {
        return this.itemChart.getVisibleRange();
    }

    void setListSelectionState(ColumnManager.SelectionState state) {
        this.itemList.getManager().setSelectionState(state);
    }

    ColumnManager.SelectionState getListSelectionState() {
        return this.itemList.getManager().getSelectionState();
    }

    void setTabFolderIndex(int index) {
        this.tabFolder.setSelection(index);
    }

    int getTabFolderIndex() {
        return this.tabFolder.getSelectionIndex();
    }

    IItemFilter getItemListFilter() {
        return this.itemListFilter;
    }

    List<IContributionManager> getMenuManagers() {
        return Arrays.asList(this.listContextMenuManager, this.itemChart.getMenuManager());
    }

    List<TriConsumer<String, ImageDescriptor, IMenuListener>> getMenuConsumers() {
        TriConsumer<String, ImageDescriptor, IMenuListener> menuConsumer = this::addMenuListenerAction;
        return Arrays.asList(menuConsumer);
    }

    private void addMenuListenerAction(String text, ImageDescriptor image, IMenuListener menuListener) {
        MCContextMenuManager bm = MCContextMenuManager.create((Control)this.tabFolder);
        bm.setRemoveAllWhenShown(true);
        bm.addMenuListener(menuListener);
        Action a = new Action(text, image){

            public void run() {
                ItemListAndChart.this.tabFolder.getMenu().setVisible(true);
            }
        };
        this.toolBarManager.add((IAction)a);
        this.toolBarManager.update(true);
    }

    public void update(IItemCollection filteredItems, IRange<IQuantity> currentRange, ItemHistogram.HistogramSelection histogramSelection, Boolean grouped) {
        this.listItems = histogramSelection != null && histogramSelection.getRowCount() > 0 ? histogramSelection.getItems() : filteredItems;
        this.itemList.show(ItemCollectionToolkit.filterIfNotNull(this.listItems, this.itemListFilter));
        this.itemChart.update(filteredItems, currentRange, histogramSelection, grouped);
    }

    public void onUseRange(Boolean useRange) {
        this.itemChart.onUseRange(useRange);
    }
}

