/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages.itemhandler;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.LinearKindOfQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.Pair;
import com.oracle.jmc.common.util.StateToolkit;
import com.oracle.jmc.common.util.StringToolkit;
import com.oracle.jmc.common.util.TypeHandling;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.common.BucketBuilder;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import com.oracle.jmc.flightrecorder.ui.common.ItemHistogram;
import com.oracle.jmc.flightrecorder.ui.common.ItemList;
import com.oracle.jmc.flightrecorder.ui.common.ItemRow;
import com.oracle.jmc.flightrecorder.ui.common.TypeLabelProvider;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.pages.itemhandler.AttributeComponentConfiguration;
import com.oracle.jmc.flightrecorder.ui.pages.itemhandler.AttributeMenuFactory;
import com.oracle.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import com.oracle.jmc.ui.charts.IXDataRenderer;
import com.oracle.jmc.ui.charts.RendererToolkit;
import com.oracle.jmc.ui.charts.XYChart;
import com.oracle.jmc.ui.charts.XYDataRenderer;
import com.oracle.jmc.ui.misc.ChartCanvas;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

class ItemChart {
    private static final int CHART_TITLE_OFFSET = 180;
    private static final String AGGREGATOR_DELIMITER = ";";
    private static final String ATTRIBUTE_DELIMITER = ",";
    private static final String COLOR_BY = "colorBy";
    private static final String LINE_CHART_ATTRIBUTES = "lineChartAttributes";
    private static final String BAR_CHART_ATTRIBUTES = "barChartAttributes";
    private static final String BAR_CHART_TYPES = "barChartTypes";
    private static final String BAR_CHART_AGGREGATES = "barChartAggregates";
    private static final String SHOW_GROUPING_AS_SPAN_CHART = "showSpanChart";
    private static final String SPAN_CONFIG_MENU_GROUP = "SpanConfig";
    private static final String CHART_MENU_GROUP = "Chart";
    private static final String OTHER_MENU_GROUP = "Other";
    private IMenuManager chartContextMenuManager;
    private final Map<LinearKindOfQuantity, List<IAttribute<?>>> attributesToLineChart = new LinkedHashMap();
    private final Map<String, Pair<IAttribute<?>, IAggregator<?, ?>>> attributeAggregatesToBarChart = new LinkedHashMap();
    private final Map<String, Pair<IType<?>, IAggregator<?, ?>>> typeAggregatesToBarChart = new LinkedHashMap();
    private final List<IAggregator<IQuantity, ?>> aggregatesToBarChart = new ArrayList();
    private final IPageContainer controller;
    private ChartCanvas chartCanvas;
    private IAttribute<?> colorBy;
    private IItemCollection chartItems;
    private IRange<IQuantity> currentRange;
    private ItemHistogram.HistogramSelection histogramSelection;
    private boolean grouped = false;
    private boolean showSpanChart;
    private AttributeComponentConfiguration acc;
    private String pageName;
    private XYChart xyChart;

    public ItemChart(Composite container, FormToolkit toolkit, String pageName, AttributeComponentConfiguration acc, IState state, IPageContainer controller) {
        this.pageName = pageName;
        this.controller = controller;
        this.acc = acc;
        this.initializeChartAttributes(state);
        this.createChart(container, toolkit);
        this.initializeChartMenu();
    }

    public Control getControl() {
        return this.chartCanvas;
    }

    private void addMenuOption(MenuManager menu, String group) {
        if (this.chartContextMenuManager.find(menu.getId()) == null) {
            if (group != null) {
                this.chartContextMenuManager.appendToGroup(group, (IContributionItem)menu);
            } else {
                this.chartContextMenuManager.add((IContributionItem)menu);
            }
        }
    }

    private void createChart(Composite parent, FormToolkit toolkit) {
        if (this.chartCanvas == null) {
            this.chartCanvas = new ChartCanvas(parent);
            toolkit.adapt((Composite)this.chartCanvas);
            DataPageToolkit.createChartTimestampTooltip(this.chartCanvas);
            IXDataRenderer cleanRow = RendererToolkit.uniformRows(Collections.emptyList());
            this.xyChart = new XYChart(this.controller.getFullRange(), cleanRow, 180);
            DataPageToolkit.setChart(this.chartCanvas, this.xyChart, this.controller::showSelection);
            this.chartContextMenuManager = this.chartCanvas.getContextMenu();
            SelectionStoreActionToolkit.addSelectionStoreRangeActions(this.controller.getSelectionStore(), this.xyChart, (IAttribute<IRange<IQuantity>>)JfrAttributes.LIFETIME, NLS.bind((String)Messages.ITEM_CHART_TIMELINE_SELECTION, (Object)this.pageName), (IContributionManager)this.chartContextMenuManager);
        }
    }

    private void initializeChartAttributes(IState chartSettings) {
        if (chartSettings == null) {
            this.onShowAggregateInBarChart(Aggregators.count(), true);
        } else {
            String barChartAggregators;
            String barChartTypes;
            String barChartAttributes;
            int n;
            String lineChartAttributes;
            String colorByAttribute = chartSettings.getAttribute(COLOR_BY);
            if (colorByAttribute != null) {
                this.colorBy = this.acc.getAllAttributes().get(colorByAttribute);
            }
            if ((lineChartAttributes = chartSettings.getAttribute(LINE_CHART_ATTRIBUTES)) != null) {
                String[] stringArray = lineChartAttributes.split(ATTRIBUTE_DELIMITER);
                n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String a = stringArray[n2];
                    IAttribute<IQuantity> attribute = this.acc.getLineChartableAttributes().get(a);
                    this.showAttributeInLineChart(attribute, true);
                    ++n2;
                }
            }
            if ((barChartAttributes = chartSettings.getAttribute(BAR_CHART_ATTRIBUTES)) != null) {
                String[] stringArray = barChartAttributes.split(ATTRIBUTE_DELIMITER);
                int n3 = stringArray.length;
                n = 0;
                while (n < n3) {
                    String attrAggrString = stringArray[n];
                    IAggregator aggregator = null;
                    IAttribute<IQuantity> attribute = null;
                    String[] attrAggr = attrAggrString.split(AGGREGATOR_DELIMITER);
                    if (attrAggr.length >= 2) {
                        String attributeString = attrAggr[0];
                        String aggregatorString = attrAggr[1];
                        attribute = this.acc.getCommonChartableAttributes().get(attributeString);
                        if (attribute == null) {
                            attribute = this.acc.getUncommonChartableAttributes().get(attributeString);
                        }
                        if (attribute != null && attribute.getContentType() instanceof LinearKindOfQuantity) {
                            IAttribute<IQuantity> qAttribute = attribute;
                            aggregator = Aggregators.getQuantityAggregator((String)aggregatorString, qAttribute);
                        }
                    }
                    if (aggregator != null && attribute != null) {
                        this.showAttributeAggregateInBarChart(attribute, aggregator, true);
                    } else {
                        FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Unable to read in chart state, undefined attribute/aggregator tuple: " + attrAggrString);
                    }
                    ++n;
                }
            }
            if ((barChartTypes = chartSettings.getAttribute(BAR_CHART_TYPES)) != null) {
                String[] stringArray = barChartTypes.split(ATTRIBUTE_DELIMITER);
                int n4 = stringArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    String typeAggrString = stringArray[n5];
                    IAggregator aggregator = null;
                    IType<?> type = null;
                    String[] typeAggr = typeAggrString.split(AGGREGATOR_DELIMITER);
                    if (typeAggr.length >= 2) {
                        String typeString = typeAggr[0];
                        String aggregatorString = typeAggr[1];
                        type = this.acc.getAllTypes().get(typeString);
                        aggregator = Aggregators.getQuantityAggregator((String)aggregatorString, type);
                    }
                    if (aggregator != null) {
                        this.showTypeAggregateInBarChart(type, aggregator, true);
                    } else {
                        FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Unable to read in chart state, undefined type/aggregator tuple: " + typeAggrString);
                    }
                    ++n5;
                }
            }
            if ((barChartAggregators = chartSettings.getAttribute(BAR_CHART_AGGREGATES)) != null) {
                String[] stringArray = barChartAggregators.split(ATTRIBUTE_DELIMITER);
                int n6 = stringArray.length;
                int n7 = 0;
                while (n7 < n6) {
                    String aggrString = stringArray[n7];
                    IAggregator aggregator = Aggregators.getQuantityAggregator((String)aggrString);
                    if (aggregator != null) {
                        this.showAggregateInBarChart(aggregator, true);
                    } else {
                        FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Unable to read in chart state, undefined aggregator tuple: " + aggrString);
                    }
                    ++n7;
                }
            }
            this.showSpanChart = StateToolkit.readBoolean((IState)chartSettings, (String)SHOW_GROUPING_AS_SPAN_CHART, (Boolean)false);
        }
    }

    public void onGrouped(Boolean grouped) {
        if (grouped != this.grouped) {
            this.grouped = grouped;
        }
        this.updateCharts();
    }

    private void initializeChartMenu() {
        this.chartContextMenuManager.add((IContributionItem)new Separator());
        this.chartContextMenuManager.add((IContributionItem)new GroupMarker(CHART_MENU_GROUP));
        this.chartContextMenuManager.appendToGroup(CHART_MENU_GROUP, (IContributionItem)new Separator());
        this.chartContextMenuManager.add((IContributionItem)new GroupMarker(SPAN_CONFIG_MENU_GROUP));
        this.chartContextMenuManager.appendToGroup(SPAN_CONFIG_MENU_GROUP, (IContributionItem)new Separator());
        this.chartContextMenuManager.add((IContributionItem)new GroupMarker(OTHER_MENU_GROUP));
        this.chartContextMenuManager.appendToGroup(OTHER_MENU_GROUP, (IContributionItem)new Separator());
        ArrayList aggregators = new ArrayList();
        aggregators.add(Aggregators.count());
        ArrayList<Function<IType, IAggregator>> typeAggregators = new ArrayList<Function<IType, IAggregator>>();
        typeAggregators.add(type -> Aggregators.count(type));
        List<Function<IAttribute<?>, IAggregator<IQuantity, ?>>> attributeAggregators = this.createAttributeAggregators();
        this.addMenuOption(AttributeMenuFactory.aggregatorMenu(this::onShowAggregateInBarChart, this::onShowAttributeAggregateInBarChart, this::onShowTypeAggregateInBarChart, () -> this.acc.getCommonChartableAttributes().values().stream(), () -> this.acc.getUncommonChartableAttributes().values().stream(), attributeAggregators, () -> this.acc.getAllTypes().values().stream(), (Function)typeAggregators.get(0), aggregators, Messages.ITEM_CHART_SHOW_IN_BAR_CHART, true, this::chartState), CHART_MENU_GROUP);
        this.addMenuOption(AttributeMenuFactory.attributeMenu(false, this::onShowAttributeInLineChart, () -> this.acc.getLineChartableAttributes().values().stream(), () -> Stream.empty(), Messages.ITEM_CHART_SHOW_IN_LINE_CHART, true, this::chartState), CHART_MENU_GROUP);
        this.chartContextMenuManager.appendToGroup(SPAN_CONFIG_MENU_GROUP, (IAction)new Action(Messages.ITEM_CHART_SHOW_GROUPING_AS_SPAN_CHART, 2){
            {
                this.setChecked(ItemChart.this.showSpanChart);
            }

            public void run() {
                ItemChart.this.onShowSpanChart(this.isChecked());
            }

            public boolean isEnabled() {
                return ItemChart.this.grouped;
            }
        });
        this.addMenuOption(AttributeMenuFactory.attributeMenu(true, () -> this.grouped && this.showSpanChart, this::onColorBy, () -> this.acc.getCommonAttributes().values().stream(), () -> this.acc.getUncommonAttributes().values().stream(), Messages.ITEM_CHART_COLOR_SPAN_BY, true, this::colorbyState), SPAN_CONFIG_MENU_GROUP);
    }

    private List<Function<IAttribute<?>, IAggregator<IQuantity, ?>>> createAttributeAggregators() {
        ArrayList attributeAggregators = new ArrayList();
        attributeAggregators.add(a -> Aggregators.max(a));
        attributeAggregators.add(a -> Aggregators.min(a));
        attributeAggregators.add(a -> Aggregators.sum(a));
        attributeAggregators.add(a -> Aggregators.avg(a));
        return attributeAggregators;
    }

    public void update(IItemCollection chartItems, IRange<IQuantity> currentRange, ItemHistogram.HistogramSelection histogramSelection, Boolean grouped) {
        this.chartItems = chartItems;
        this.currentRange = currentRange;
        this.histogramSelection = histogramSelection;
        this.grouped = grouped;
        this.updateCharts();
    }

    private void updateCharts() {
        if (this.chartCanvas != null) {
            IXDataRenderer rendererRoot;
            if (this.showSpanChart && this.grouped || !this.attributesToLineChart.isEmpty() || !this.attributeAggregatesToBarChart.isEmpty() || !this.typeAggregatesToBarChart.isEmpty() || !this.aggregatesToBarChart.isEmpty()) {
                IItemCollection itemsToChart;
                ArrayList<IXDataRenderer> rows = new ArrayList<IXDataRenderer>();
                IItemCollection iItemCollection = itemsToChart = this.grouped && this.histogramSelection != null ? this.histogramSelection.getItems() : this.chartItems;
                if (this.grouped && this.showSpanChart) {
                    rows.addAll(this.updateSpanChart(this.histogramSelection));
                }
                if (ItemCollectionToolkit.stream(this.chartItems).count() > 0L && !this.attributesToLineChart.isEmpty()) {
                    rows.addAll(this.updateLineChart(this.chartItems));
                }
                rows.addAll(this.updateBarChart(itemsToChart));
                rendererRoot = RendererToolkit.uniformRows(rows);
            } else {
                rendererRoot = RendererToolkit.uniformRows(Collections.emptyList());
            }
            this.xyChart.setRendererRoot(rendererRoot);
            this.chartCanvas.setChart(this.xyChart);
            this.chartContextMenuManager.update("enabled");
        }
    }

    private void showAttributeInLineChart(IAttribute<?> a, Boolean enabled) {
        ContentType q;
        if (a != null && (q = a.getContentType()) instanceof LinearKindOfQuantity) {
            List<IAttribute<?>> aList = this.attributesToLineChart.get(q);
            if (aList == null) {
                aList = new ArrayList();
                this.attributesToLineChart.put((LinearKindOfQuantity)q, aList);
            }
            if (!aList.contains(a) && enabled.booleanValue()) {
                aList.add(a);
            } else if (aList.contains(a) && !enabled.booleanValue()) {
                aList.remove(a);
            }
        }
    }

    private void onShowAttributeInLineChart(IAttribute<?> a, Boolean enabled) {
        this.showAttributeInLineChart(a, enabled);
        this.updateCharts();
    }

    private void showAggregateInBarChart(IAggregator<IQuantity, ?> aggregator, Boolean enabled) {
        if (aggregator != null) {
            if (!this.aggregatesToBarChart.contains(aggregator) && enabled.booleanValue()) {
                this.aggregatesToBarChart.add(aggregator);
            } else if (this.aggregatesToBarChart.contains(aggregator) && !enabled.booleanValue()) {
                this.aggregatesToBarChart.remove(aggregator);
            }
        }
    }

    private void showTypeAggregateInBarChart(IType<?> type, IAggregator<?, ?> aggregator, Boolean enabled) {
        if (aggregator != null) {
            String id = this.getKey(type, aggregator);
            if (!this.typeAggregatesToBarChart.containsKey(id) && enabled.booleanValue()) {
                this.typeAggregatesToBarChart.put(id, new Pair(type, aggregator));
            } else if (this.typeAggregatesToBarChart.containsKey(id) && !enabled.booleanValue()) {
                this.typeAggregatesToBarChart.remove(id);
            }
        }
    }

    private void showAttributeAggregateInBarChart(IAttribute<?> attribute, IAggregator<?, ?> aggregator, Boolean enabled) {
        if (aggregator != null) {
            String id = this.getKey(attribute, aggregator);
            if (!this.attributeAggregatesToBarChart.containsKey(id) && enabled.booleanValue()) {
                Pair pair = new Pair(attribute, aggregator);
                this.attributeAggregatesToBarChart.put(id, pair);
            } else if (this.attributeAggregatesToBarChart.containsKey(id) && !enabled.booleanValue()) {
                this.attributeAggregatesToBarChart.remove(id);
            }
        }
    }

    private void onShowAggregateInBarChart(IAggregator<IQuantity, ?> aggregator, Boolean enabled) {
        this.showAggregateInBarChart(aggregator, enabled);
        this.updateCharts();
    }

    private void onShowTypeAggregateInBarChart(IType<?> type, IAggregator<?, ?> aggregator, Boolean enabled) {
        this.showTypeAggregateInBarChart(type, aggregator, enabled);
        this.updateCharts();
    }

    private void onShowAttributeAggregateInBarChart(IAttribute<?> attribute, IAggregator<?, ?> aggregator, Boolean enabled) {
        this.showAttributeAggregateInBarChart(attribute, aggregator, enabled);
        this.updateCharts();
    }

    protected void onShowSpanChart(boolean show) {
        this.showSpanChart = show;
        this.updateCharts();
    }

    private void onColorBy(IAttribute<?> a, Boolean ignore) {
        this.colorBy = a;
        this.updateCharts();
    }

    Boolean chartState(Object chartItem) {
        if (chartItem instanceof IAttribute) {
            return this.attributesToLineChart.values().stream().flatMap(l -> l.stream()).anyMatch(a -> a.equals(chartItem));
        }
        if (chartItem instanceof IAggregator) {
            return this.aggregatesToBarChart.contains(chartItem);
        }
        if (chartItem instanceof Pair && ((Pair)chartItem).right instanceof IAggregator) {
            Pair p = (Pair)chartItem;
            if (p.left instanceof IType) {
                return this.typeAggregatesToBarChart.containsKey(this.getKey((IType)p.left, (IAggregator)p.right));
            }
            if (p.left instanceof IAttribute) {
                return this.attributeAggregatesToBarChart.containsKey(this.getKey((IAttribute)p.left, (IAggregator)p.right));
            }
        }
        return false;
    }

    Boolean colorbyState(Object colorAttribute) {
        return Objects.equals(this.colorBy, colorAttribute);
    }

    void setVisibleRange(IRange<IQuantity> visibleRange) {
        this.xyChart.setVisibleRange((IQuantity)visibleRange.getStart(), (IQuantity)visibleRange.getEnd());
    }

    IRange<IQuantity> getVisibleRange() {
        return this.xyChart.getVisibleRange();
    }

    private String getKey(IAttribute<?> attribute, IAggregator<?, ?> aggregator) {
        return String.valueOf(ItemList.getColumnId(attribute)) + AGGREGATOR_DELIMITER + aggregator.getName();
    }

    private String getKey(IType<?> type, IAggregator<?, ?> aggregator) {
        return String.valueOf(type != null ? type.getIdentifier() : "null") + AGGREGATOR_DELIMITER + aggregator.getName();
    }

    public void saveState(IWritableState chartSettings) {
        if (this.colorBy != null) {
            chartSettings.putString(COLOR_BY, ItemList.getColumnId(this.colorBy));
        }
        if (!this.attributeAggregatesToBarChart.isEmpty()) {
            chartSettings.putString(BAR_CHART_ATTRIBUTES, this.attributeAggregatesToBarChart.keySet().stream().collect(Collectors.joining(ATTRIBUTE_DELIMITER)));
        }
        if (!this.typeAggregatesToBarChart.isEmpty()) {
            chartSettings.putString(BAR_CHART_TYPES, this.typeAggregatesToBarChart.keySet().stream().collect(Collectors.joining(ATTRIBUTE_DELIMITER)));
        }
        if (!this.aggregatesToBarChart.isEmpty()) {
            chartSettings.putString(BAR_CHART_AGGREGATES, this.aggregatesToBarChart.stream().map(a -> a.getName()).collect(Collectors.joining(ATTRIBUTE_DELIMITER)));
        }
        if (!this.attributesToLineChart.isEmpty()) {
            chartSettings.putString(LINE_CHART_ATTRIBUTES, this.attributesToLineChart.values().stream().flatMap(l -> l.stream()).map(a -> ItemList.getColumnId(a)).collect(Collectors.joining(ATTRIBUTE_DELIMITER)));
        }
        StateToolkit.writeBoolean((IWritableState)chartSettings, (String)SHOW_GROUPING_AS_SPAN_CHART, (Boolean)this.showSpanChart);
    }

    private Collection<ItemRow> updateLineChart(IItemCollection itemsToChart) {
        boolean fill = false;
        if (this.attributesToLineChart.size() > 0 && itemsToChart.hasItems()) {
            ArrayList<ItemRow> rows = new ArrayList<ItemRow>();
            for (Map.Entry<LinearKindOfQuantity, List<IAttribute<?>>> entry : this.attributesToLineChart.entrySet()) {
                List<IAttribute<?>> attributes = entry.getValue();
                if (attributes == null || attributes.size() <= 0) continue;
                String name = StringToolkit.join((Collection)attributes.stream().map(a -> a.getName()).collect(Collectors.toList()), (String)ATTRIBUTE_DELIMITER);
                String description = StringToolkit.join((Collection)attributes.stream().map(b -> b.getDescription()).collect(Collectors.toList()), (String)ATTRIBUTE_DELIMITER);
                XYDataRenderer xyRenderer = new XYDataRenderer((IQuantity)entry.getKey().getDefaultUnit().quantity(0L), name, description);
                for (IAttribute<?> attribute : attributes) {
                    Iterator chartItemsWithAttributeSomeType = itemsToChart.apply(ItemFilters.hasAttribute(attribute)).iterator();
                    if (!chartItemsWithAttributeSomeType.hasNext() || !(attribute.getContentType() instanceof LinearKindOfQuantity)) continue;
                    IItemIterable is = (IItemIterable)chartItemsWithAttributeSomeType.next();
                    if (chartItemsWithAttributeSomeType.hasNext()) {
                        FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Only charting a subset of the events! (Ref: JMC-4499)");
                    }
                    IAttribute<?> qAttribute = attribute;
                    DataPageToolkit.addEndTimeLine(xyRenderer, is.iterator(), (IType<IItem>)is.getType(), qAttribute, fill);
                }
                rows.add(new ItemRow(name, description, (IXDataRenderer)xyRenderer, itemsToChart));
            }
            return rows;
        }
        return Collections.emptyList();
    }

    private Collection<ItemRow> updateBarChart(IItemCollection itemsToChart) {
        if (this.attributeAggregatesToBarChart.size() > 0 || this.typeAggregatesToBarChart.size() > 0 || this.aggregatesToBarChart.size() > 0) {
            ITypedQuantity zero;
            ArrayList<ItemRow> rows = new ArrayList<ItemRow>();
            for (Pair<IAttribute<?>, IAggregator<?, ?>> pair : this.attributeAggregatesToBarChart.values()) {
                LinearKindOfQuantity ct = (LinearKindOfQuantity)((IAttribute)pair.left).getContentType();
                ITypedQuantity zero2 = ct != null ? ct.getDefaultUnit().quantity(0L) : UnitLookup.NUMBER_UNITY.quantity(0L);
                IAggregator aggregator = (IAggregator)pair.right;
                XYDataRenderer xyRenderer = new XYDataRenderer((IQuantity)zero2, aggregator.getName(), aggregator.getDescription());
                xyRenderer.addBarChart(aggregator.getName(), BucketBuilder.aggregatorSeries(itemsToChart, aggregator, (IAttribute<IQuantity>)JfrAttributes.END_TIME), TypeLabelProvider.getColorOrDefault(aggregator.getName()));
                rows.add(new ItemRow(aggregator.getName(), aggregator.getDescription(), (IXDataRenderer)xyRenderer, itemsToChart));
            }
            for (Pair<IAttribute<?>, IAggregator<?, ?>> pair : this.typeAggregatesToBarChart.values()) {
                if (!(((IAggregator)pair.right).getValueType() instanceof LinearKindOfQuantity)) continue;
                zero = UnitLookup.NUMBER_UNITY.quantity(0L);
                IAggregator aggregator = (IAggregator)pair.right;
                XYDataRenderer xyRenderer = new XYDataRenderer((IQuantity)zero, aggregator.getName(), aggregator.getDescription());
                xyRenderer.addBarChart(aggregator.getName(), BucketBuilder.aggregatorSeries(itemsToChart, aggregator, (IAttribute<IQuantity>)JfrAttributes.END_TIME), TypeLabelProvider.getColorOrDefault(aggregator.getName()));
                rows.add(new ItemRow(aggregator.getName(), aggregator.getDescription(), (IXDataRenderer)xyRenderer, itemsToChart));
            }
            for (IAggregator iAggregator : this.aggregatesToBarChart) {
                zero = UnitLookup.NUMBER_UNITY.quantity(0L);
                XYDataRenderer xyRenderer = new XYDataRenderer((IQuantity)zero, iAggregator.getName(), iAggregator.getDescription());
                xyRenderer.addBarChart(iAggregator.getName(), BucketBuilder.aggregatorSeries(itemsToChart, iAggregator, (IAttribute<IQuantity>)JfrAttributes.END_TIME), TypeLabelProvider.getColorOrDefault(iAggregator.getName()));
                rows.add(new ItemRow(iAggregator.getName(), iAggregator.getDescription(), (IXDataRenderer)xyRenderer, itemsToChart));
            }
            return rows;
        }
        return Collections.emptyList();
    }

    private Collection<IXDataRenderer> updateSpanChart(ItemHistogram.HistogramSelection selection) {
        if (selection != null && selection.getRowCount() > 0) {
            IXDataRenderer spanRoot = RendererToolkit.uniformRows(selection.getSelectedRows(this::buildSpanRow).collect(Collectors.toList()));
            return Arrays.asList(spanRoot);
        }
        return Collections.emptyList();
    }

    private ItemRow buildSpanRow(Object rowTitle, IItemCollection items) {
        String title = rowTitle != null ? TypeHandling.getValueString((Object)rowTitle) : "";
        return this.buildSpanRow(title, null, items);
    }

    private ItemRow buildSpanRow(String laneTitle, String laneDescription, IItemCollection items) {
        IXDataRenderer spanRenderer = DataPageToolkit.buildSpanRenderer(items, this.colorBy != null ? DataPageToolkit.getAttributeValueColor(this.colorBy) : DataPageToolkit.ITEM_COLOR);
        return new ItemRow(laneTitle, laneDescription, spanRenderer, items);
    }

    public IMenuManager getMenuManager() {
        return this.chartContextMenuManager;
    }

    public void onUseRange(Boolean useRange) {
        IRange<IQuantity> range = useRange != false ? this.currentRange : this.controller.getFullRange();
        this.xyChart.setVisibleRange((IQuantity)range.getStart(), (IQuantity)range.getEnd());
        this.updateCharts();
    }
}

