/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages.itemhandler;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.ui.column.TableSettings;
import java.util.HashMap;
import java.util.Map;

class HistogramSettingsTree {
    private static final String ATTRIBUTE_PARENT_GROUPBY = "parentGroupBy";
    private static final String ATTRIBUTE_GROUPBY = "groupBy";
    private static final String ELEMENT_TABLE = "table";
    private static final String ELEMENT_CHILD = "child";
    public String groupBy;
    public TableSettings tableSettings;
    private final Map<String, HistogramSettingsTree> children = new HashMap<String, HistogramSettingsTree>();

    public HistogramSettingsTree(IState state) {
        this.groupBy = state.getAttribute(ATTRIBUTE_GROUPBY);
        IState table = state.getChild(ELEMENT_TABLE);
        this.tableSettings = TableSettings.forState((IState)table);
        IState[] iStateArray = state.getChildren(ELEMENT_CHILD);
        int n = iStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            IState child = iStateArray[n2];
            this.children.put(child.getAttribute(ATTRIBUTE_PARENT_GROUPBY), new HistogramSettingsTree(child));
            ++n2;
        }
    }

    public HistogramSettingsTree() {
    }

    public HistogramSettingsTree(String groupBy, TableSettings tableConfig) {
        this.groupBy = groupBy;
        this.tableSettings = tableConfig;
    }

    public HistogramSettingsTree getSelectedChild() {
        return this.children.computeIfAbsent(this.groupBy, key -> new HistogramSettingsTree());
    }

    public void saveState(IWritableState state) {
        state.putString(ATTRIBUTE_GROUPBY, this.groupBy);
        if (this.tableSettings != null) {
            this.tableSettings.saveState(state.createChild(ELEMENT_TABLE));
        }
        for (Map.Entry<String, HistogramSettingsTree> e : this.children.entrySet()) {
            IWritableState childState = state.createChild(ELEMENT_CHILD);
            childState.putString(ATTRIBUTE_PARENT_GROUPBY, e.getKey());
            e.getValue().saveState(childState);
        }
    }
}

