/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages.itemhandler;

import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.util.Pair;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.pages.itemhandler.TriConsumer;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;

class AttributeMenuFactory {
    AttributeMenuFactory() {
    }

    public static MenuManager attributeMenu(boolean includeNone, BiConsumer<IAttribute<?>, Boolean> onSelection, Supplier<Stream<? extends IAttribute<?>>> commonAttributes, String menuOption, ImageDescriptor imageDescriptor) {
        return AttributeMenuFactory.attributeMenu(includeNone, () -> Boolean.TRUE, onSelection, commonAttributes, () -> Stream.empty(), menuOption, imageDescriptor, false, o -> Boolean.FALSE);
    }

    public static MenuManager attributeMenu(boolean includeNone, Supplier<Boolean> actionEnabled, BiConsumer<IAttribute<?>, Boolean> onSelection, Supplier<Stream<? extends IAttribute<?>>> commonAttributes, String menuOption) {
        return AttributeMenuFactory.attributeMenu(includeNone, actionEnabled, onSelection, commonAttributes, () -> Stream.empty(), menuOption, null, false, o -> Boolean.FALSE);
    }

    public static MenuManager attributeMenu(boolean includeNone, Supplier<Boolean> actionEnabled, BiConsumer<IAttribute<?>, Boolean> onSelection, Supplier<Stream<? extends IAttribute<?>>> commonAttributes, Supplier<Stream<? extends IAttribute<?>>> uncommonAttributes, String menuOption) {
        return AttributeMenuFactory.attributeMenu(includeNone, actionEnabled, onSelection, commonAttributes, uncommonAttributes, menuOption, null, false, o -> Boolean.FALSE);
    }

    public static MenuManager attributeMenu(boolean includeNone, Supplier<Boolean> actionEnabled, BiConsumer<IAttribute<?>, Boolean> onSelection, Supplier<Stream<? extends IAttribute<?>>> commonAttributes, Supplier<Stream<? extends IAttribute<?>>> uncommonAttributes, String menuOption, boolean checkAction, Function<Object, Boolean> checkedState) {
        return AttributeMenuFactory.attributeMenu(includeNone, actionEnabled, onSelection, commonAttributes, uncommonAttributes, menuOption, null, checkAction, checkedState);
    }

    public static MenuManager attributeMenu(boolean includeNone, BiConsumer<IAttribute<?>, Boolean> onSelection, Supplier<Stream<? extends IAttribute<?>>> commonAttributes, Supplier<Stream<? extends IAttribute<?>>> uncommonAttributes, String menuOption, boolean checkAction, Function<Object, Boolean> checkedState) {
        return AttributeMenuFactory.attributeMenu(includeNone, () -> Boolean.TRUE, onSelection, commonAttributes, uncommonAttributes, menuOption, null, checkAction, checkedState);
    }

    public static MenuManager attributeMenu(boolean includeNone, Supplier<Boolean> actionEnabled, BiConsumer<IAttribute<?>, Boolean> onSelection, Supplier<Stream<? extends IAttribute<?>>> commonAttributes, Supplier<Stream<? extends IAttribute<?>>> uncommonAttributes, String menuOption, ImageDescriptor image, boolean checkAction, Function<Object, Boolean> checkedState) {
        MenuManager gbMenu = new MenuManager(menuOption, image, menuOption);
        gbMenu.setRemoveAllWhenShown(true);
        gbMenu.addMenuListener(AttributeMenuFactory.attributeMenuListener(includeNone, actionEnabled, onSelection, commonAttributes, uncommonAttributes, checkAction, checkedState));
        return gbMenu;
    }

    public static IMenuListener attributeMenuListener(boolean includeNone, BiConsumer<IAttribute<?>, Boolean> onSelection, Supplier<Stream<? extends IAttribute<?>>> commonAttributes) {
        return AttributeMenuFactory.attributeMenuListener(includeNone, () -> Boolean.TRUE, onSelection, commonAttributes, () -> Stream.empty(), false, o -> Boolean.FALSE);
    }

    public static IMenuListener attributeMenuListener(boolean includeNone, Supplier<Boolean> actionEnabled, final BiConsumer<IAttribute<?>, Boolean> onSelection, Supplier<Stream<? extends IAttribute<?>>> commonAttributes, final Supplier<Stream<? extends IAttribute<?>>> uncommonAttributes, final boolean checkAction, final Function<Object, Boolean> checkedState) {
        return manager -> {
            if (((Boolean)actionEnabled.get()).booleanValue()) {
                if (includeNone) {
                    manager.add((IAction)new Action(Messages.TABLECOMPONENT_NONE){

                        public void run() {
                            onSelection.accept(null, true);
                        }
                    });
                }
                ((Stream)commonAttributes.get()).map(AttributeMenuFactory.getAttributeAction(onSelection, checkAction, checkedState)).forEach(arg_0 -> ((IMenuManager)manager).add(arg_0));
                if (((Stream)uncommonAttributes.get()).findAny().isPresent()) {
                    MenuManager uncommonMenu = new MenuManager(Messages.ATTRIBUTE_NOT_SHARED, Messages.ATTRIBUTE_NOT_SHARED);
                    uncommonMenu.setRemoveAllWhenShown(true);
                    uncommonMenu.addMenuListener(new IMenuListener(){

                        public void menuAboutToShow(IMenuManager innerManager) {
                            ((Stream)uncommonAttributes.get()).map(AttributeMenuFactory.getAttributeAction(onSelection, checkAction, checkedState)).forEach(arg_0 -> ((IMenuManager)innerManager).add(arg_0));
                        }
                    });
                    manager.add((IContributionItem)uncommonMenu);
                }
            }
        };
    }

    public static MenuManager aggregatorMenu(final BiConsumer<IAggregator<IQuantity, ?>, Boolean> onAggregateSelection, final TriConsumer<IAttribute<?>, IAggregator<IQuantity, ?>, Boolean> onAttributeSelection, final TriConsumer<IType<?>, IAggregator<IQuantity, ?>, Boolean> onTypeSelection, final Supplier<Stream<? extends IAttribute<?>>> commonAttributes, final Supplier<Stream<? extends IAttribute<?>>> uncommonAttributes, final List<Function<IAttribute<?>, IAggregator<IQuantity, ?>>> attributeAggregators, final Supplier<Stream<IType<?>>> types, final Function<IType<?>, IAggregator<IQuantity, ?>> typeAggregator, final List<IAggregator<IQuantity, ?>> aggregators, String menuOption, final boolean checkAction, final Function<Object, Boolean> checkedState) {
        MCContextMenuManager aggregatorMenu = new MCContextMenuManager(menuOption, menuOption);
        aggregatorMenu.setRemoveAllWhenShown(true);
        aggregatorMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                aggregators.stream().map(this::getAggregateAction).forEach(arg_0 -> ((IMenuManager)manager).add(arg_0));
                ((Stream)types.get()).map(type -> this.getTypeAggregateAction((IType<?>)type, typeAggregator)).forEach(arg_0 -> ((IMenuManager)manager).add(arg_0));
                ((Stream)commonAttributes.get()).map(AttributeMenuFactory.getAttributeAggregatorMenu(onAttributeSelection, attributeAggregators, checkAction, checkedState)).forEach(arg_0 -> ((IMenuManager)manager).add(arg_0));
                if (((Stream)uncommonAttributes.get()).findAny().isPresent()) {
                    MenuManager uncommonMenu = new MenuManager(Messages.ATTRIBUTE_NOT_SHARED, Messages.ATTRIBUTE_NOT_SHARED);
                    uncommonMenu.setRemoveAllWhenShown(true);
                    uncommonMenu.addMenuListener(new IMenuListener(){

                        public void menuAboutToShow(IMenuManager innerManager) {
                            ((Stream)uncommonAttributes.get()).map(AttributeMenuFactory.getAttributeAggregatorMenu(onAttributeSelection, attributeAggregators, checkAction, checkedState)).forEach(arg_0 -> ((IMenuManager)innerManager).add(arg_0));
                        }
                    });
                    manager.add((IContributionItem)uncommonMenu);
                }
            }

            private Action getAggregateAction(final IAggregator<IQuantity, ?> aggregator) {
                return new Action(aggregator.getName(), checkAction ? 2 : 0, checkedState){
                    {
                        super($anonymous0, $anonymous1);
                        if (bl) {
                            this.setChecked((Boolean)function.apply(iAggregator));
                        }
                    }

                    public void run() {
                        onAggregateSelection.accept(aggregator, checkAction ? this.isChecked() : true);
                    }
                };
            }

            private Action getTypeAggregateAction(final IType<?> type, Function<IType<?>, IAggregator<IQuantity, ?>> aggregatorSupplier) {
                final IAggregator<IQuantity, ?> aggregator = aggregatorSupplier.apply(type);
                return new Action(aggregator.getName(), checkAction ? 2 : 0, checkedState){
                    {
                        super($anonymous0, $anonymous1);
                        if (bl) {
                            this.setChecked((Boolean)function.apply(new Pair((Object)iType, (Object)iAggregator)));
                        }
                    }

                    public void run() {
                        onTypeSelection.accept(type, aggregator, checkAction ? this.isChecked() : true);
                    }
                };
            }
        });
        return aggregatorMenu;
    }

    private static Function<IAttribute<?>, Action> getAttributeAction(final BiConsumer<IAttribute<?>, Boolean> onSelection, final boolean checkAction, final Function<Object, Boolean> checkedState) {
        return new Function<IAttribute<?>, Action>(){

            @Override
            public Action apply(final IAttribute<?> attribute) {
                return new Action(attribute.getName(), checkAction ? 2 : 0, checkedState){
                    {
                        super($anonymous0, $anonymous1);
                        if (bl) {
                            this.setChecked((Boolean)function.apply(iAttribute));
                        }
                    }

                    public void run() {
                        onSelection.accept(attribute, checkAction ? this.isChecked() : true);
                    }
                };
            }
        };
    }

    private static Function<IAttribute<?>, MenuManager> getAttributeAggregatorMenu(final TriConsumer<IAttribute<?>, IAggregator<IQuantity, ?>, Boolean> onSelection, final List<Function<IAttribute<?>, IAggregator<IQuantity, ?>>> attributeAggregators, final boolean checkAction, final Function<Object, Boolean> checkedState) {
        return new Function<IAttribute<?>, MenuManager>(){

            @Override
            public MenuManager apply(final IAttribute<?> attribute) {
                MenuManager aggregatorMenu = new MenuManager(attribute.getName(), attribute.getName());
                aggregatorMenu.setRemoveAllWhenShown(true);
                aggregatorMenu.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        attributeAggregators.stream().map(this::attributeAggregatorMenu).forEach(arg_0 -> ((IMenuManager)manager).add(arg_0));
                    }

                    Action attributeAggregatorMenu(Function<IAttribute<?>, IAggregator<IQuantity, ?>> aggregatorFunction) {
                        IAggregator<IQuantity, ?> aggregator = aggregatorFunction.apply(attribute);
                        return new AggregatorAction(aggregator, attribute, checkAction, checkedState, onSelection);
                    }
                });
                return aggregatorMenu;
            }
        };
    }

    private static final class AggregatorAction
    extends Action {
        private final IAttribute<?> attribute;
        private final IAggregator<IQuantity, ?> aggregator;
        private final boolean checkAction;
        private final TriConsumer<IAttribute<?>, IAggregator<IQuantity, ?>, Boolean> onSelection;

        public AggregatorAction(IAggregator<IQuantity, ?> aggregator, IAttribute<?> attribute, boolean checkAction, Function<Object, Boolean> checkedState, TriConsumer<IAttribute<?>, IAggregator<IQuantity, ?>, Boolean> onSelection) {
            super(aggregator.getName(), checkAction ? 2 : 0);
            this.aggregator = aggregator;
            this.attribute = attribute;
            this.checkAction = checkAction;
            this.onSelection = onSelection;
            if (checkAction) {
                this.setChecked(checkedState.apply(new Pair(attribute, aggregator)));
            }
        }

        public void run() {
            this.onSelection.accept(this.attribute, this.aggregator, this.checkAction ? this.isChecked() : true);
        }
    }
}

