/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages.itemhandler;

import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.LinearKindOfQuantity;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.common.ItemList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class AttributeComponentConfiguration {
    private final Map<String, IType<?>> allTypes = new HashMap();
    private final Map<String, IAttribute<?>> allAttributes = new HashMap();
    private final Map<String, IAttribute<?>> commonAttributes = new HashMap();
    private final Map<String, IAttribute<IQuantity>> commonChartableAttributes = new HashMap<String, IAttribute<IQuantity>>();
    private final Map<String, IAttribute<?>> uncommonAttributes = new HashMap();
    private final Map<String, IAttribute<IQuantity>> uncommonChartableAttributes = new HashMap<String, IAttribute<IQuantity>>();
    private final Map<String, IAttribute<IQuantity>> lineChartableAttributes = new HashMap<String, IAttribute<IQuantity>>();

    public AttributeComponentConfiguration(IItemCollection items) {
        this.forEachType(items);
        this.populateAttributeMaps(AttributeComponentConfiguration.isSuitableForLineCharts(items, this.allTypes));
    }

    private void forEachType(IItemCollection items) {
        if (items != null) {
            ItemCollectionToolkit.stream(items).filter(IItemIterable::hasItems).map(IItemIterable::getType).forEach(type -> {
                this.allTypes.put(type.getIdentifier(), (IType<?>)type);
                for (IAttribute a : type.getAttributes()) {
                    if (a.equals(JfrAttributes.EVENT_STACKTRACE)) continue;
                    this.allAttributes.put(ItemList.getColumnId(a), a);
                }
            });
        }
    }

    private void populateAttributeMaps(boolean allowLineCharts) {
        for (Map.Entry<String, IAttribute<?>> a : this.allAttributes.entrySet()) {
            IAttribute<?> qa;
            if (!this.commonAttributes.containsKey(a.getKey()) && !this.uncommonAttributes.containsKey(a.getKey()) && this.allTypes.values().stream().allMatch(t -> t.getAttributes().contains(a.getValue()))) {
                this.commonAttributes.put(a.getKey(), a.getValue());
                if (!(a.getValue().getContentType() instanceof LinearKindOfQuantity)) continue;
                qa = a.getValue();
                this.commonChartableAttributes.put(a.getKey(), qa);
                if (!allowLineCharts) continue;
                this.lineChartableAttributes.put(a.getKey(), qa);
                continue;
            }
            this.uncommonAttributes.put(a.getKey(), a.getValue());
            if (!(a.getValue().getContentType() instanceof LinearKindOfQuantity)) continue;
            qa = a.getValue();
            this.uncommonChartableAttributes.put(a.getKey(), qa);
        }
    }

    private static boolean isSuitableForLineCharts(IItemCollection items, Map<String, IType<?>> types) {
        Iterator iterator;
        if (types.values().size() == 1 && (iterator = items.iterator()).hasNext()) {
            iterator.next();
            return !iterator.hasNext();
        }
        return false;
    }

    public Map<String, IAttribute<?>> getAllAttributes() {
        return this.allAttributes;
    }

    public Map<String, IAttribute<?>> getCommonAttributes() {
        return this.commonAttributes;
    }

    public Map<String, IAttribute<IQuantity>> getCommonChartableAttributes() {
        return this.commonChartableAttributes;
    }

    public Map<String, IAttribute<IQuantity>> getUncommonChartableAttributes() {
        return this.uncommonChartableAttributes;
    }

    public Map<String, IAttribute<IQuantity>> getLineChartableAttributes() {
        return this.lineChartableAttributes;
    }

    public Map<String, IType<?>> getAllTypes() {
        return this.allTypes;
    }

    public Map<String, IAttribute<?>> getUncommonAttributes() {
        return this.uncommonAttributes;
    }
}

