/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IDataPageFactory;
import com.oracle.jmc.flightrecorder.ui.IDisplayablePage;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.IPageDefinition;
import com.oracle.jmc.flightrecorder.ui.IPageUI;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.common.AbstractDataPage;
import com.oracle.jmc.flightrecorder.ui.common.BucketBuilder;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import com.oracle.jmc.flightrecorder.ui.common.FlavorSelector;
import com.oracle.jmc.flightrecorder.ui.common.ItemHistogram;
import com.oracle.jmc.flightrecorder.ui.common.ItemRow;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.pages.ChartAndTableUI;
import com.oracle.jmc.ui.charts.AWTChartToolkit;
import com.oracle.jmc.ui.charts.IXDataRenderer;
import com.oracle.jmc.ui.charts.XYDataRenderer;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.TableSettings;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TlabPage
extends AbstractDataPage {
    private static final Color INSIDE_COLOR = new Color(0, 182, 0);
    private static final Color OUTSIDE_COLOR = new Color(164, 64, 255, 128);
    private static final IItemFilter TLAB_EVENTS = JdkFilters.ALLOC_ALL;
    private static final String INSIDE_SIZE = "insideSize";
    private static final String OUTSIDE_SIZE = "outsideSize";
    private static final String INSIDE_COUNT_COL = "insideCount";
    private static final String OUTSIDE_COUNT_COL = "outsideCount";
    private static final String AVERAGE_INSIDE_SIZE_COL = "averageInsideSize";
    private static final String AVERAGE_OUTSIDE_SIZE_COL = "averageOutsideSize";
    private static final String TOTAL_INSIDE_SIZE_COL = "totalInsideSize";
    private static final String TOTAL_OUTSIDE_SIZE_COL = "totalOutsideSize";
    private static final ItemHistogram.ItemHistogramBuilder HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private IRange<IQuantity> visibleRange;
    private IItemFilter tableFilter;
    private ColumnManager.SelectionState tableState;
    private FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        HISTOGRAM.addCountColumn();
        HISTOGRAM.addColumn(INSIDE_COUNT_COL, JdkAggregators.INSIDE_TLAB_COUNT);
        HISTOGRAM.addColumn(OUTSIDE_COUNT_COL, JdkAggregators.OUTSIDE_TLAB_COUNT);
        HISTOGRAM.addColumn(AVERAGE_INSIDE_SIZE_COL, JdkAggregators.ALLOC_INSIDE_TLAB_AVG);
        HISTOGRAM.addColumn(AVERAGE_OUTSIDE_SIZE_COL, JdkAggregators.ALLOC_OUTSIDE_TLAB_AVG);
        HISTOGRAM.addColumn(TOTAL_INSIDE_SIZE_COL, JdkAggregators.ALLOC_INSIDE_TLAB_SUM);
        HISTOGRAM.addColumn(TOTAL_OUTSIDE_SIZE_COL, JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM);
    }

    private static String threadCount(int count) {
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return " (" + Messages.TlabPage_SELECTED_THREAD + ")";
            }
        }
        return " (" + NLS.bind((String)Messages.TlabPage_SELECTED_THREADS, (Object)count) + ")";
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
        return new TlabUI(parent, toolkit, editor, state);
    }

    public TlabPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.visibleRange = editor.getFullRange();
    }

    public static class TlabPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.TlabPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/allocations.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"tlab"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new TlabPage(dpd, items, editor);
        }
    }

    private class TlabUI
    extends ChartAndTableUI {
        private static final String TLAB_TABLE_FILTER = "tlabTableFilter";
        private IAction insideSizeAction;
        private IAction outsideSizeAction;

        TlabUI(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            super(TLAB_EVENTS, TlabPage.this.getDataSource(), parent, toolkit, pageContainer, state, TlabPage.this.getName(), TlabPage.this.tableFilter, TlabPage.this.getIcon(), TlabPage.this.flavorSelectorState);
            TlabPage.this.addResultActions(this.form);
            this.tableFilterComponent.loadState(state.getChild(TLAB_TABLE_FILTER));
            this.chart.setVisibleRange((IQuantity)TlabPage.this.visibleRange.getStart(), (IQuantity)TlabPage.this.visibleRange.getEnd());
            this.chart.addVisibleRangeListener(r -> {
                IRange<IQuantity> iRange = r;
                IRange<IQuantity> iRange2 = iRange;
                TlabPage.this.visibleRange = iRange;
            });
            this.table.getManager().setSelectionState(TlabPage.this.tableState);
        }

        @Override
        public void saveTo(IWritableState state) {
            super.saveTo(state);
            this.tableFilterComponent.saveState(state.createChild(TLAB_TABLE_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            TlabPage.this.tableState = this.table.getManager().getSelectionState();
            TlabPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        @Override
        protected ItemHistogram buildHistogram(Composite parent, IState state) {
            return HISTOGRAM.buildWithoutBorder(parent, JfrAttributes.EVENT_THREAD, TableSettings.forState((IState)state));
        }

        @Override
        protected IXDataRenderer getChartRenderer(IItemCollection itemsInTable, ItemHistogram.HistogramSelection selection) {
            IItemCollection selectedItems = selection.getRowCount() == 0 ? itemsInTable : selection.getItems();
            String threadCount = TlabPage.threadCount(selection.getRowCount());
            IItemCollection filter = selectedItems.apply(JdkFilters.ALLOC_ALL);
            XYDataRenderer renderer = new XYDataRenderer((IQuantity)UnitLookup.MEMORY.getDefaultUnit().quantity(0L), Messages.TlabPage_ROW_TLAB_ALLOCATIONS, Messages.TlabPage_ROW_TLAB_ALLOCATIONS_DESC);
            if (this.insideSizeAction.isChecked()) {
                renderer.addBarChart(JdkAggregators.ALLOC_INSIDE_TLAB_SUM.getName(), BucketBuilder.aggregatorSeries(filter, JdkAggregators.ALLOC_INSIDE_TLAB_SUM, (IAttribute<IQuantity>)JfrAttributes.END_TIME), AWTChartToolkit.staticColor((Color)INSIDE_COLOR));
            }
            if (this.outsideSizeAction.isChecked()) {
                renderer.addBarChart(JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM.getName(), BucketBuilder.aggregatorSeries(filter, JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM, (IAttribute<IQuantity>)JfrAttributes.END_TIME), AWTChartToolkit.staticColor((Color)OUTSIDE_COLOR));
            }
            return new ItemRow(String.valueOf(Messages.TlabPage_ROW_TLAB_ALLOCATIONS) + threadCount, null, (IXDataRenderer)renderer, filter);
        }

        @Override
        protected void onFilterChange(IItemFilter filter) {
            super.onFilterChange(filter);
            TlabPage.this.tableFilter = filter;
        }

        @Override
        protected List<IAction> initializeChartConfiguration(IState state) {
            this.insideSizeAction = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.ALLOC_INSIDE_TLAB_SUM, TlabPage.INSIDE_SIZE, INSIDE_COLOR, b -> this.buildChart());
            this.outsideSizeAction = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM, TlabPage.OUTSIDE_SIZE, OUTSIDE_COLOR, b -> this.buildChart());
            return Arrays.asList(this.insideSizeAction, this.outsideSizeAction);
        }
    }
}

