/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.internal.IArray;
import com.oracle.jmc.common.internal.util.FilterMatcher;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IDataPageFactory;
import com.oracle.jmc.flightrecorder.ui.IDisplayablePage;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.IPageDefinition;
import com.oracle.jmc.flightrecorder.ui.IPageUI;
import com.oracle.jmc.flightrecorder.ui.ItemIterableToolkit;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.common.AbstractDataPage;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import com.oracle.jmc.flightrecorder.ui.common.FlavorSelector;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.handlers.CopySelectionAction;
import com.oracle.jmc.ui.handlers.InFocusHandlerActivator;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import com.oracle.jmc.ui.misc.PersistableSashForm;
import com.oracle.jmc.ui.misc.TreeStructureContentProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ThreadDumpsPage
extends AbstractDataPage {
    private static final String SEPARATOR = "\n\n";
    private static final String SASH = "sash";
    private ISelection treeSelection;
    private TreePath[] treeExpansion;
    private FlavorSelector.FlavorSelectorState flavorSelectorState;

    public ThreadDumpsPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return JdkFilters.THREAD_DUMP;
    }

    @Override
    public IPageUI display(Composite container, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new ThreadDumpsUI(container, toolkit, pageContainer, state);
    }

    private static String joinSelection(List<?> selection) {
        return selection.stream().map(o -> ((Node)o).body).collect(Collectors.joining(SEPARATOR));
    }

    private static String joinSelectionForCopy(IStructuredSelection selection) {
        List list = selection.toList();
        Set parents = list.stream().filter(o -> o instanceof ThreadDumpCollection).collect(Collectors.toSet());
        return list.stream().flatMap(o -> o instanceof ThreadDumpCollection ? ThreadDumpsPage.getThreadDumpCollectionStreamForCopy((ThreadDumpCollection)o) : ThreadDumpsPage.getThreadDumpStreamForCopy(parents, (ThreadDump)o)).map(n -> n.body).collect(Collectors.joining(SEPARATOR));
    }

    private static Stream<Node> getThreadDumpCollectionStreamForCopy(ThreadDumpCollection tdc) {
        return Stream.concat(Stream.of(tdc), Stream.of(tdc.dumps));
    }

    private static Stream<Node> getThreadDumpStreamForCopy(Set<ThreadDumpCollection> parents, ThreadDump td) {
        return parents.contains(td.parent) ? Stream.empty() : Stream.concat(Stream.of(td.parent), Stream.of(td));
    }

    private static ThreadDumpCollection[] parseEvents(IItemIterable is) {
        IMemberAccessor resultAccessor = JdkAttributes.THREAD_DUMP_RESULT.getAccessor(is.getType());
        IMemberAccessor stAccessor = JfrAttributes.END_TIME.getAccessor(is.getType());
        return (ThreadDumpCollection[])ItemIterableToolkit.stream(is).map(i -> ThreadDumpsPage.parseCollection(((IQuantity)stAccessor.getMember(i)).displayUsing("auto"), (String)resultAccessor.getMember(i))).toArray(ThreadDumpCollection[]::new);
    }

    private static ThreadDumpCollection parseCollection(String title, String str) {
        String[] parts = str.split(SEPARATOR);
        if (parts.length > 2) {
            ThreadDump[] dumps = new ThreadDump[parts.length - 2];
            ThreadDumpCollection parent = new ThreadDumpCollection(title, String.valueOf(parts[0]) + SEPARATOR + parts[parts.length - 1], dumps);
            int i = 0;
            while (i < dumps.length) {
                dumps[i] = ThreadDumpsPage.parseThreadDump(parts[i + 1], parent);
                ++i;
            }
            return parent;
        }
        return new ThreadDumpCollection(title, str, new ThreadDump[0]);
    }

    private static ThreadDump parseThreadDump(String str, ThreadDumpCollection parent) {
        int firstLineEnd = (str = str.trim()).indexOf(10);
        String firstLine = firstLineEnd < 0 ? str : str.substring(0, firstLineEnd);
        int lastQuote = firstLine.lastIndexOf(34);
        return new ThreadDump(lastQuote > 1 ? firstLine.substring(1, lastQuote) : firstLine, str, parent);
    }

    static /* synthetic */ String access$2(IStructuredSelection iStructuredSelection) {
        return ThreadDumpsPage.joinSelectionForCopy(iStructuredSelection);
    }

    private static abstract class Node {
        final String title;
        final String body;

        Node(String title, String body) {
            this.title = title;
            this.body = body;
        }

        public boolean equals(Object o) {
            if (o instanceof Node) {
                Node other = (Node)o;
                return this.body.equals(other.body) && this.title.equals(other.title);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.body, this.title);
        }
    }

    private static class ThreadDump
    extends Node {
        final ThreadDumpCollection parent;

        ThreadDump(String title, String body, ThreadDumpCollection parent) {
            super(title, body);
            this.parent = parent;
        }
    }

    private static class ThreadDumpCollection
    extends Node
    implements IArray<ThreadDump> {
        final ThreadDump[] dumps;

        ThreadDumpCollection(String title, String body, ThreadDump[] dumps) {
            super(title, body);
            this.dumps = dumps;
        }

        public boolean isEmpty() {
            return this.dumps.length == 0;
        }

        public ThreadDump[] elements() {
            return this.dumps;
        }
    }

    public static class ThreadDumpsPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.ThreadDumpsPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/threaddumps.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"thread_dumps"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new ThreadDumpsPage(dpd, items, editor);
        }
    }

    private class ThreadDumpsUI
    implements IPageUI {
        private SashForm sash;
        private TreeViewer tree;
        private TreeFilterWithTextInput treeTextFilter;
        private TreeFilter treeFilter;
        private FlavorSelector flavorSelector;

        ThreadDumpsUI(Composite container, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            Form form = DataPageToolkit.createForm(container, toolkit, ThreadDumpsPage.this.getName(), ThreadDumpsPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 256);
            toolkit.adapt((Composite)this.sash);
            Composite filterComposite = new Composite((Composite)this.sash, 0);
            filterComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
            this.tree = new TreeViewer(filterComposite);
            this.tree.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            Text text = toolkit.createText((Composite)this.sash, "", 2634);
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(ThreadDumpsPage.SASH));
            this.tree.setContentProvider((IContentProvider)TreeStructureContentProvider.INSTANCE);
            ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((Node)element).title;
                }

                public Image getImage(Object element) {
                    return element instanceof ThreadDumpCollection ? FlightRecorderUI.getDefault().getImage("pages/threaddumps.png") : UIPlugin.getDefault().getImage("thread_obj.gif");
                }
            };
            this.tree.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.tree.addSelectionChangedListener(s -> text.setText(ThreadDumpsPage.joinSelection(((IStructuredSelection)s.getSelection()).toList())));
            this.treeTextFilter = TreeFilterWithTextInput.addFilterControl(filterComposite, (StructuredViewer)this.tree, e -> labelProvider.getText(e), e -> e instanceof ThreadDump);
            this.treeTextFilter.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.treeTextFilter.getControl().moveAbove(this.tree.getControl());
            this.treeFilter = TreeFilter.addFilter((StructuredViewer)this.tree, e -> labelProvider.getText(e), e -> e instanceof ThreadDump);
            MCContextMenuManager mm = MCContextMenuManager.create((Control)this.tree.getControl());
            CopySelectionAction copyAction = new CopySelectionAction(ThreadDumpsPage::access$2, (StructuredViewer)this.tree);
            mm.add((IAction)copyAction);
            InFocusHandlerActivator.install((Control)this.tree.getControl(), (IAction)copyAction);
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, JdkQueries.THREAD_DUMP.getFilter(), Arrays.asList(JfrAttributes.EVENT_THREAD, JdkAttributes.EVENT_THREAD_NAME, JfrAttributes.LIFETIME, JfrAttributes.END_TIME), ThreadDumpsPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, ThreadDumpsPage.this.flavorSelectorState);
            ThreadDumpsPage.this.addResultActions(form);
            if (ThreadDumpsPage.this.treeExpansion != null) {
                this.tree.setExpandedTreePaths(ThreadDumpsPage.this.treeExpansion);
            }
            this.tree.setSelection(ThreadDumpsPage.this.treeSelection);
        }

        private void onInputSelected(IItemCollection items, Set<String> threadNames, IRange<IQuantity> range) {
            if (threadNames != null && !threadNames.isEmpty()) {
                this.useItems(null, range);
                this.treeFilter.filterString = threadNames.size() > 1 ? "regexp:" + threadNames.stream().collect(Collectors.joining("|")) : threadNames.iterator().next();
            } else {
                this.useItems(items, range);
                this.treeFilter.filterString = null;
            }
            this.tree.refresh();
        }

        private void useItems(IItemCollection items, IRange<IQuantity> range) {
            IItemCollection itemsToUse = items != null ? items : ThreadDumpsPage.this.getDataSource().getItems().apply(ItemFilters.rangeContainedIn((ICanonicalAccessorFactory)JfrAttributes.LIFETIME, range));
            Iterator ii = itemsToUse.apply(JdkQueries.THREAD_DUMP.getFilter()).iterator();
            this.tree.setInput(ii.hasNext() ? ThreadDumpsPage.parseEvents((IItemIterable)ii.next()) : null);
        }

        public void saveTo(IWritableState state) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)state.createChild(ThreadDumpsPage.SASH));
            this.saveToLocal();
        }

        private void saveToLocal() {
            ThreadDumpsPage.this.treeSelection = this.tree.getSelection();
            ThreadDumpsPage.this.treeExpansion = this.tree.getExpandedTreePaths();
            ThreadDumpsPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }
    }

    private static class TreeFilter
    extends ViewerFilter {
        protected String filterString;
        private final Function<Object, String> labelProvider;
        private Function<Object, Boolean> isFilterable;

        private static TreeFilter addFilter(StructuredViewer viewer, Function<Object, String> lp, Function<Object, Boolean> isFilterable) {
            TreeFilter filter = new TreeFilter(viewer, lp, isFilterable);
            return filter;
        }

        private TreeFilter(StructuredViewer viewer, Function<Object, String> labelProvider, Function<Object, Boolean> isFilterable) {
            this.labelProvider = labelProvider;
            this.isFilterable = isFilterable;
            viewer.addFilter((ViewerFilter)this);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.filterString == null) {
                return true;
            }
            if (this.isFilterable.apply(element).booleanValue()) {
                return this.matches(element);
            }
            StructuredViewer sviewer = (StructuredViewer)viewer;
            ITreeContentProvider provider = (ITreeContentProvider)sviewer.getContentProvider();
            Object[] objectArray = provider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (this.select(viewer, element, child)) {
                    if (viewer instanceof AbstractTreeViewer) {
                        ((AbstractTreeViewer)viewer).setExpandedState(element, true);
                    }
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean matches(Object element) {
            String label = this.labelProvider.apply(element);
            return this.filterString == null || FilterMatcher.getInstance().match(label, this.filterString, true);
        }
    }

    private static class TreeFilterWithTextInput
    extends TreeFilter {
        private final Text filterText;

        private static TreeFilterWithTextInput addFilterControl(Composite filterComposite, StructuredViewer viewer, Function<Object, String> lp, Function<Object, Boolean> isFilterable) {
            TreeFilterWithTextInput filter = new TreeFilterWithTextInput(filterComposite, viewer, lp, isFilterable);
            return filter;
        }

        private TreeFilterWithTextInput(Composite filterComposite, final StructuredViewer viewer, Function<Object, String> labelProvider, Function<Object, Boolean> isFilterable) {
            super(viewer, labelProvider, isFilterable);
            this.filterText = new Text(filterComposite, 128);
            this.filterText.setMessage(Messages.SEARCH_TREE_TEXT);
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String text = filterText.getText();
                    filterString = text == null ? null : FilterMatcher.autoAddKleene((String)text, (FilterMatcher.Where)FilterMatcher.Where.BEFORE_AND_AFTER);
                    viewer.refresh();
                }
            });
        }

        public Control getControl() {
            return this.filterText;
        }
    }
}

