/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IDataPageFactory;
import com.oracle.jmc.flightrecorder.ui.IDisplayablePage;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.IPageDefinition;
import com.oracle.jmc.flightrecorder.ui.IPageUI;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.common.AbstractDataPage;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import com.oracle.jmc.flightrecorder.ui.common.ItemAggregateViewer;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SystemPage
extends AbstractDataPage {
    @Override
    public IPageUI display(Composite container, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        Form form = DataPageToolkit.createForm(container, toolkit, this.getName(), this.getIcon());
        ItemAggregateViewer infoViewer = new ItemAggregateViewer(form.getBody(), toolkit);
        infoViewer.addCaption(Messages.SystemPage_SECTION_CPU);
        infoViewer.addAggregate(JdkAggregators.CPU_TYPE);
        infoViewer.addAggregate(JdkAggregators.MIN_NUMBER_OF_CORES);
        infoViewer.addAggregate(JdkAggregators.MIN_HW_THREADS);
        infoViewer.addAggregate(JdkAggregators.MIN_NUMBER_OF_SOCKETS);
        infoViewer.addAggregate(JdkAggregators.CPU_DESCRIPTION);
        infoViewer.addCaption(Messages.SystemPage_SECTION_MEMORY);
        infoViewer.addAggregate(JdkAggregators.MIN_TOTAL_MEMORY);
        infoViewer.addCaption(Messages.SystemPage_SECTION_OS);
        infoViewer.addAggregate(JdkAggregators.OS_VERSION);
        infoViewer.setValues(this.getDataSource().getItems());
        this.addResultActions(form);
        return null;
    }

    public SystemPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.CPU_INFORMATION, JdkFilters.OS_MEMORY_SUMMARY, ItemFilters.type((String)"com.oracle.jdk.OSInformation")});
    }

    public static class SystemPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.SystemPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/system.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"system_information"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new SystemPage(dpd, items, editor);
        }
    }
}

