/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IDataPageFactory;
import com.oracle.jmc.flightrecorder.ui.IDisplayablePage;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.IPageDefinition;
import com.oracle.jmc.flightrecorder.ui.IPageUI;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.common.AbstractDataPage;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import com.oracle.jmc.flightrecorder.ui.common.FilterComponent;
import com.oracle.jmc.flightrecorder.ui.common.FlavorSelector;
import com.oracle.jmc.flightrecorder.ui.common.ItemHistogram;
import com.oracle.jmc.flightrecorder.ui.common.ItemHistogramWithInput;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.ColumnMenusFactory;
import com.oracle.jmc.ui.column.TableSettings;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import com.oracle.jmc.ui.misc.PersistableSashForm;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MethodProfilingPage
extends AbstractDataPage {
    private static final IItemFilter TABLE_ITEMS = ItemFilters.type((String)"com.oracle.jdk.ExecutionSample");
    private static final ItemHistogram.ItemHistogramBuilder PACKAGE_HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private static final ItemHistogram.ItemHistogramBuilder CLASS_HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private IItemFilter packageFilter;
    private ColumnManager.SelectionState packageState;
    private IItemFilter classFilter;
    private ColumnManager.SelectionState classState;
    public FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        PACKAGE_HISTOGRAM.addCountColumn();
        CLASS_HISTOGRAM.addCountColumn();
    }

    private static TableSettings getTableSettings(IState state) {
        if (state == null) {
            return new TableSettings("count", Arrays.asList(new TableSettings.ColumnSettings("key", Boolean.valueOf(false), Integer.valueOf(500), null), new TableSettings.ColumnSettings("count", Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false))));
        }
        return new TableSettings(state);
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new MethodProfilingUi(parent, toolkit, pageContainer, state);
    }

    public MethodProfilingPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return TABLE_ITEMS;
    }

    public static class MethodProfilingPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.MethodProfilingPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/method.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"method_profiling"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new MethodProfilingPage(dpd, items, editor);
        }
    }

    private class MethodProfilingUi
    implements IPageUI {
        private static final String CLASS_FILTER = "classFilter";
        private static final String PACKAGE_FILTER = "packageFilter";
        private static final String SASH_ELEMENT = "sash";
        private static final String PACKAGE_TABLE_ELEMENT = "packageTable";
        private static final String CLASS_TABLE_ELEMENT = "classTable";
        private final ItemHistogram packageTable;
        private final ItemHistogram classTable;
        private final SashForm sash;
        private final IPageContainer pageContainer;
        private Consumer<IItemCollection> chained;
        private FilterComponent packageTableFilter;
        private FilterComponent classTableFilter;
        private IItemCollection selectionItems;
        private FlavorSelector flavorSelector;

        MethodProfilingUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.pageContainer = pageContainer;
            Form form = DataPageToolkit.createForm(parent, toolkit, MethodProfilingPage.this.getName(), MethodProfilingPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            toolkit.adapt((Composite)this.sash);
            this.packageTable = PACKAGE_HISTOGRAM.buildWithoutBorder((Composite)this.sash, JdkAttributes.STACK_TRACE_TOP_PACKAGE, MethodProfilingPage.getTableSettings(state.getChild(PACKAGE_TABLE_ELEMENT)));
            MCContextMenuManager mmPackage = MCContextMenuManager.create((Control)this.packageTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.packageTable.getManager(), (MCContextMenuManager)mmPackage);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.packageTable, Messages.MethodProfilingPage_PACKAGE_HISTOGRAM_SELECTION, (IContributionManager)mmPackage);
            this.classTable = CLASS_HISTOGRAM.buildWithoutBorder((Composite)this.sash, JdkAttributes.STACK_TRACE_TOP_CLASS, MethodProfilingPage.getTableSettings(state.getChild(CLASS_TABLE_ELEMENT)));
            MCContextMenuManager mmClass = MCContextMenuManager.create((Control)this.classTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.classTable.getManager(), (MCContextMenuManager)mmClass);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.classTable, Messages.MethodProfilingPage_CLASS_HISTOGRAM_SELECTION, (IContributionManager)mmClass);
            this.chained = ItemHistogramWithInput.chain(this.packageTable, this::updateDetails, this.classTable);
            this.packageTableFilter = FilterComponent.createFilterComponent(this.packageTable, MethodProfilingPage.this.packageFilter, this.getItems(), pageContainer.getSelectionStore()::getSelections, this::onPackageFilterChange);
            this.packageTableFilter.loadState(state.getChild(PACKAGE_FILTER));
            mmPackage.add(this.packageTableFilter.getShowFilterAction());
            mmPackage.add(this.packageTableFilter.getShowSearchAction());
            this.classTableFilter = FilterComponent.createFilterComponent(this.classTable, MethodProfilingPage.this.classFilter, this.getItems(), pageContainer.getSelectionStore()::getSelections, this::onClassFilterChange);
            this.classTableFilter.loadState(state.getChild(CLASS_FILTER));
            mmClass.add(this.classTableFilter.getShowFilterAction());
            mmClass.add(this.classTableFilter.getShowSearchAction());
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(SASH_ELEMENT));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, TABLE_ITEMS, MethodProfilingPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, MethodProfilingPage.this.flavorSelectorState);
            MethodProfilingPage.this.addResultActions(form);
            this.onPackageFilterChange(MethodProfilingPage.this.packageFilter);
            this.onClassFilterChange(MethodProfilingPage.this.classFilter);
            this.packageTable.getManager().setSelectionState(MethodProfilingPage.this.packageState);
            this.classTable.getManager().setSelectionState(MethodProfilingPage.this.classState);
        }

        private void onPackageFilterChange(IItemFilter filter) {
            MethodProfilingPage.this.packageFilter = filter;
            this.packageTableFilter.filterChangeHelper(filter, this.chained, this.packageTable.getAllRows()::getRowCount, this.getItems());
        }

        private void onClassFilterChange(IItemFilter filter) {
            MethodProfilingPage.this.classFilter = filter;
            IItemCollection items = this.packageTable.getSelection().getItems();
            items = items.hasItems() ? items : this.getItems();
            this.classTableFilter.filterChangeHelper(filter, this.classTable, items);
        }

        public void saveTo(IWritableState writableState) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)writableState.createChild(SASH_ELEMENT));
            this.packageTable.getManager().getSettings().saveState(writableState.createChild(PACKAGE_TABLE_ELEMENT));
            this.classTable.getManager().getSettings().saveState(writableState.createChild(CLASS_TABLE_ELEMENT));
            this.packageTableFilter.saveState(writableState.createChild(PACKAGE_FILTER));
            this.classTableFilter.saveState(writableState.createChild(CLASS_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            MethodProfilingPage.this.packageState = this.packageTable.getManager().getSelectionState();
            MethodProfilingPage.this.classState = this.classTable.getManager().getSelectionState();
            MethodProfilingPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        private void updateDetails(IItemCollection items) {
            this.pageContainer.showSelection(items);
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.selectionItems = items;
            this.chained.accept(this.getItems());
        }

        private IItemCollection getItems() {
            IItemCollection items = this.selectionItems != null ? this.selectionItems : MethodProfilingPage.this.getDataSource().getItems();
            return ItemCollectionToolkit.filterIfNotNull(ItemCollectionToolkit.filterIfNotNull(items.apply(TABLE_ITEMS), MethodProfilingPage.this.packageFilter), MethodProfilingPage.this.classFilter);
        }
    }
}

