/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.flightrecorder.ui.IDataPageFactory;
import com.oracle.jmc.flightrecorder.ui.IDisplayablePage;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.IPageDefinition;
import com.oracle.jmc.flightrecorder.ui.IPageUI;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.common.AbstractDataPage;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MessagePageFactory
implements IDataPageFactory {
    private final String title;
    private final String message;
    private final ImageDescriptor icon;

    public MessagePageFactory(String title, String message, ImageDescriptor icon) {
        this.title = title;
        this.message = message;
        this.icon = icon;
    }

    @Override
    public String getName(IState state) {
        return this.title;
    }

    @Override
    public ImageDescriptor getImageDescriptor(IState state) {
        return this.icon;
    }

    @Override
    public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        return new AbstractDataPage(dpd, items, editor){

            @Override
            public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
                Form form = DataPageToolkit.createForm(parent, toolkit, this.getName(), this.getIcon());
                Text text = new Text(form.getBody(), 2816);
                text.setText(MessagePageFactory.this.message);
                return null;
            }
        };
    }
}

