/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages;

import com.oracle.jmc.common.IDisplayable;
import com.oracle.jmc.common.IMCThread;
import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.jdk.dataproviders.MethodProfilingDataProvider;
import com.oracle.jmc.flightrecorder.ui.EventTypeFolderNode;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IDataPageFactory;
import com.oracle.jmc.flightrecorder.ui.IDisplayablePage;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.IPageDefinition;
import com.oracle.jmc.flightrecorder.ui.IPageUI;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.common.AbstractDataPage;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import com.oracle.jmc.flightrecorder.ui.common.FlavorSelector;
import com.oracle.jmc.flightrecorder.ui.common.ItemHistogram;
import com.oracle.jmc.flightrecorder.ui.common.ItemRow;
import com.oracle.jmc.flightrecorder.ui.common.LaneEditor;
import com.oracle.jmc.flightrecorder.ui.common.PairBucketBuilder;
import com.oracle.jmc.flightrecorder.ui.common.TypeLabelProvider;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.pages.ChartAndTableUI;
import com.oracle.jmc.ui.OrientationAction;
import com.oracle.jmc.ui.charts.AWTChartToolkit;
import com.oracle.jmc.ui.charts.IQuantitySeries;
import com.oracle.jmc.ui.charts.ISpanSeries;
import com.oracle.jmc.ui.charts.IXDataRenderer;
import com.oracle.jmc.ui.charts.QuantitySeries;
import com.oracle.jmc.ui.charts.QuantitySpanRenderer;
import com.oracle.jmc.ui.charts.RendererToolkit;
import com.oracle.jmc.ui.charts.SpanRenderer;
import com.oracle.jmc.ui.charts.XYDataRenderer;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.TableSettings;
import com.oracle.jmc.ui.handlers.ActionToolkit;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import com.oracle.jmc.ui.misc.SWTColorToolkit;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JavaApplicationPage
extends AbstractDataPage {
    private static final Color THREAD_BG_COLOR = new Color(Color.HSBtoRGB(Color.RGBtoHSB(200, 255, 200, null)[0], 0.6f, 0.5f));
    private static final Color EXCEPTIONS_COLOR = TypeLabelProvider.getColor("com.oracle.jdk.JavaExceptionThrow");
    private static final AWTChartToolkit.IColorProvider<IQuantity> PROFILING_COLOR = new AWTChartToolkit.IColorProvider<IQuantity>(){

        public Color getColor(IQuantity balance) {
            double fraction = balance == null ? 0.0 : Math.max(0.0, Math.min(balance.doubleValue(), 1.0));
            float hue = 0.12f - (float)(fraction * 0.1);
            float saturation = fraction < 0.5 ? 0.35f + (float)fraction : 0.85f;
            return Color.getHSBColor(hue, saturation, 0.95f);
        }
    };
    private static final ImageDescriptor PROFILING_LEGEND_ICON = SWTColorToolkit.createGradientThumbnail((RGB)SWTColorToolkit.asRGB((Color)PROFILING_COLOR.getColor((Object)UnitLookup.NUMBER_UNITY.quantity(1L))), (RGB)SWTColorToolkit.asRGB((Color)PROFILING_COLOR.getColor((Object)UnitLookup.NUMBER_UNITY.quantity(0L))), (boolean)true);
    private static final IItemFilter ALL_THREAD_EVENTS = ItemFilters.hasAttribute((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD);
    private static final String THREAD_LANE = "threadLane";
    private static final String PROFILING_COUNT_COL = "profilingCount";
    private static final String ALLOCATION_COL = "allocation";
    private static final String EXCEPTIONS_COL = "exceptions";
    private static final String THREAD_START_COL = "threadStart";
    private static final String THREAD_END_COL = "threadEnd";
    private static final String IO_TIME_COL = "ioTime";
    private static final String IO_COUNT_COL = "ioCount";
    private static final String BLOCKED_TIME_COL = "blockedTime";
    private static final String BLOCKED_COUNT_COL = "blockedCount";
    private static final String CLASSLOAD_COUNT_COL = "classloadingCount";
    private static final String CLASSLOAD_TIME_COL = "classloadingTime";
    private static final String APPLICATION_PAUSE_ID = "applicationPause";
    private static final String ACTIVITY_LANES_ID = "threadActivityLanes";
    private static final ItemHistogram.ItemHistogramBuilder HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private IRange<IQuantity> visibleRange;
    private IItemFilter tableFilter;
    private ColumnManager.SelectionState tableState;
    private FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        HISTOGRAM.addColumn(JdkAttributes.EVENT_THREAD_GROUP);
        HISTOGRAM.addColumn(PROFILING_COUNT_COL, JdkAggregators.EXECUTION_SAMPLE_COUNT);
        HISTOGRAM.addColumn(ALLOCATION_COL, JdkAggregators.ALLOCATION_TOTAL);
        HISTOGRAM.addColumn(IO_TIME_COL, JdkAggregators.TOTAL_IO_TIME);
        HISTOGRAM.addColumn(IO_COUNT_COL, JdkAggregators.TOTAL_IO_COUNT);
        HISTOGRAM.addColumn(BLOCKED_TIME_COL, JdkAggregators.TOTAL_BLOCKED_TIME);
        HISTOGRAM.addColumn(BLOCKED_COUNT_COL, JdkAggregators.TOTAL_BLOCKED_COUNT);
        HISTOGRAM.addColumn(CLASSLOAD_COUNT_COL, JdkAggregators.CLASS_LOADING_COUNT);
        HISTOGRAM.addColumn(CLASSLOAD_TIME_COL, JdkAggregators.CLASS_LOADING_TIME_SUM);
        HISTOGRAM.addColumn(EXCEPTIONS_COL, JdkAggregators.THROWABLES_COUNT);
        HISTOGRAM.addColumn(THREAD_START_COL, Aggregators.min((String)Messages.JavaApplicationPage_COLUMN_THREAD_START, null, (String)"com.oracle.jdk.ThreadStart", (IAttribute)JfrAttributes.EVENT_TIMESTAMP));
        HISTOGRAM.addColumn(THREAD_END_COL, Aggregators.max((String)Messages.JavaApplicationPage_COLUMN_THREAD_END, null, (String)"com.oracle.jdk.ThreadEnd", (IAttribute)JfrAttributes.EVENT_TIMESTAMP));
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new MethodProfilingUi(parent, toolkit, pageContainer, state);
    }

    public JavaApplicationPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.visibleRange = editor.getFullRange();
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ALL_THREAD_EVENTS;
    }

    private static IQuantitySeries<?> threadRanges(String threadName, IItemCollection items) {
        IQuantity eq;
        IItemCollection startEvents = items.apply(ItemFilters.type((String)"com.oracle.jdk.ThreadStart"));
        IItemCollection endEvents = items.apply(ItemFilters.type((String)"com.oracle.jdk.ThreadEnd"));
        Iterator start = ItemCollectionToolkit.values(startEvents, JfrAttributes.START_TIME).get().sorted().iterator();
        Iterator end = ItemCollectionToolkit.values(endEvents, JfrAttributes.END_TIME).get().sorted().iterator();
        ArrayList<IQuantity> startList = new ArrayList<IQuantity>();
        ArrayList<IQuantity> endList = new ArrayList<IQuantity>();
        IQuantity sq = start.hasNext() ? (IQuantity)start.next() : QuantitySpanRenderer.MISSING_START;
        IQuantity iQuantity = eq = end.hasNext() ? (IQuantity)end.next() : QuantitySpanRenderer.MISSING_END;
        if (sq.compareTo((Object)eq) >= 0) {
            startList.add(QuantitySpanRenderer.MISSING_START);
            endList.add(eq);
            eq = end.hasNext() ? (IQuantity)end.next() : QuantitySpanRenderer.MISSING_END;
        }
        while (start.hasNext()) {
            startList.add(sq);
            endList.add(eq);
            sq = start.hasNext() ? (IQuantity)start.next() : QuantitySpanRenderer.MISSING_START;
            IQuantity iQuantity2 = eq = end.hasNext() ? (IQuantity)end.next() : QuantitySpanRenderer.MISSING_END;
        }
        startList.add(sq);
        endList.add(eq);
        final String text = NLS.bind((String)Messages.JavaApplicationPage_THREAD_LIFESPAN, (Object)threadName);
        return QuantitySeries.all(startList, endList, (Object)new IDisplayable(){

            public String displayUsing(String formatHint) {
                return text;
            }
        });
    }

    private static String threadCount(int count) {
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return " (" + Messages.JavaApplicationPage_SELECTED_THREAD + ")";
            }
        }
        return NLS.bind((String)(" (" + Messages.JavaApplicationPage_SELECTED_THREADS + ")"), (Object)count);
    }

    public static class JavaApplicationPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.JavaApplicationPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/methodprofiling.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"java_application"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new JavaApplicationPage(dpd, items, editor);
        }
    }

    private class MethodProfilingUi
    extends ChartAndTableUI {
        private static final String METHOD_PROFILING_TABLE_FILTER = "methodProfilingTableFilter";
        private IAction applicationPauseIdAction;
        private IAction profilingCountAction;
        private IAction allocationAction;
        private IAction exceptionsAction;
        private IAction threadActivityAction;
        private List<LaneEditor.LaneDefinition> naLanes;
        private MCContextMenuManager mm;
        private List<LaneEditor.LaneDefinition> laneDefs;

        MethodProfilingUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            super(ALL_THREAD_EVENTS, JavaApplicationPage.this.getDataSource(), parent, toolkit, pageContainer, state, JavaApplicationPage.this.getName(), JavaApplicationPage.this.tableFilter, JavaApplicationPage.this.getIcon(), JavaApplicationPage.this.flavorSelectorState);
            this.mm = MCContextMenuManager.create((Control)this.chartLegend.getControl());
            this.updateContextMenu();
            this.buildChart();
            JavaApplicationPage.this.addResultActions(this.form);
            this.tableFilterComponent.loadState(state.getChild(METHOD_PROFILING_TABLE_FILTER));
            this.form.getToolBarManager().add((IContributionItem)new Separator());
            OrientationAction.installActions((Form)this.form, (SashForm)this.sash);
            this.chart.addVisibleRangeListener(r -> {
                IRange<IQuantity> iRange = r;
                IRange<IQuantity> iRange2 = iRange;
                JavaApplicationPage.this.visibleRange = iRange;
            });
            this.chart.setVisibleRange((IQuantity)JavaApplicationPage.this.visibleRange.getStart(), (IQuantity)JavaApplicationPage.this.visibleRange.getEnd());
            this.table.getManager().setSelectionState(JavaApplicationPage.this.tableState);
        }

        private void openEditLanesDialog() {
            EventTypeFolderNode typeTree = JavaApplicationPage.this.getDataSource().getTypeTree(ItemCollectionToolkit.stream(JavaApplicationPage.this.getDataSource().getItems()).filter(this::typeWithThreadAndDuration));
            this.laneDefs = LaneEditor.openDialog(typeTree, this.laneDefs.stream().collect(Collectors.toList()), Messages.JavaApplicationPage_EDIT_THREAD_LANES_DIALOG_TITLE, Messages.JavaApplicationPage_EDIT_THREAD_LANES_DIALOG_MESSAGE);
            this.updateContextMenu();
            this.buildChart();
        }

        private Boolean typeWithThreadAndDuration(IItemIterable itemStream) {
            return DataPageToolkit.isTypeWithThreadAndDuration(itemStream.getType());
        }

        private void updateContextMenu() {
            this.mm.removeAll();
            this.mm.add(ActionToolkit.action(this::openEditLanesDialog, (String)Messages.JavaApplicationPage_EDIT_THREAD_LANES_ACTION, (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("lanes_edit.gif")));
            this.mm.add((IContributionItem)new Separator());
            this.laneDefs.stream().forEach(ld -> {
                Action checkAction = new Action(ld.getName(), 2, (LaneEditor.LaneDefinition)ld){
                    int laneIndex;
                    private final /* synthetic */ LaneEditor.LaneDefinition val$ld;
                    {
                        this.val$ld = laneDefinition;
                        super($anonymous0, $anonymous1);
                        this.laneIndex = MethodProfilingUi.this.laneDefs.indexOf(laneDefinition);
                    }

                    public void run() {
                        LaneEditor.LaneDefinition newLd = new LaneEditor.LaneDefinition(this.val$ld.getName(), this.isChecked(), this.val$ld.getFilter(), this.val$ld.isRestLane());
                        MethodProfilingUi.this.laneDefs.set(this.laneIndex, newLd);
                        MethodProfilingUi.this.buildChart();
                    }
                };
                checkAction.setChecked(ld.isEnabled());
                this.mm.add((IAction)checkAction);
            });
        }

        @Override
        protected ItemHistogram buildHistogram(Composite parent, IState state) {
            ItemHistogram build = HISTOGRAM.buildWithoutBorder(parent, JfrAttributes.EVENT_THREAD, TableSettings.forState((IState)state));
            return build;
        }

        @Override
        protected IXDataRenderer getChartRenderer(IItemCollection itemsInTable, ItemHistogram.HistogramSelection selection) {
            boolean useDefaultSelection;
            List<IXDataRenderer> rows = new ArrayList<IXDataRenderer>();
            IItemCollection allItems = JavaApplicationPage.this.getDataSource().getItems();
            DataPageToolkit.buildLinesRow(Messages.JavaApplicationPage_ROW_CPU_USAGE, Messages.JavaApplicationPage_ROW_CPU_USAGE_DESC, allItems, true, JdkQueries.CPU_USAGE_SIMPLE_QUERY, this::isAttributeEnabled, (IQuantity)UnitLookup.PERCENT.quantity(0L), (IQuantity)UnitLookup.PERCENT.quantity(100L)).ifPresent(rows::add);
            DataPageToolkit.buildLinesRow(Messages.JavaApplicationPage_ROW_HEAP_USAGE, JdkAttributes.HEAP_USED.getDescription(), allItems, false, JdkQueries.HEAP_SUMMARY, this::isAttributeEnabled, (IQuantity)UnitLookup.BYTES.quantity(0L), null).ifPresent(rows::add);
            IItemCollection selectedItems = selection.getRowCount() == 0 ? itemsInTable : selection.getItems();
            String threadCount = JavaApplicationPage.threadCount(selection.getRowCount());
            if (this.profilingCountAction.isChecked()) {
                IItemCollection profilingItems = selectedItems.apply(JdkFilters.EXECUTION_SAMPLE);
                IQuantitySeries<IQuantity[]> aggregatorSeries = PairBucketBuilder.aggregatorSeries(profilingItems, JdkAggregators.EXECUTION_SAMPLE_COUNT, MethodProfilingDataProvider.TOP_FRAME_BALANCE, (IAttribute<IQuantity>)JfrAttributes.END_TIME);
                XYDataRenderer renderer = new XYDataRenderer((IQuantity)UnitLookup.NUMBER_UNITY.quantity(0L), (IQuantity)UnitLookup.NUMBER_UNITY.quantity(100L), true, Messages.JavaApplicationPage_METHOD_PROFILING, JdkAggregators.EXECUTION_SAMPLE_COUNT.getDescription());
                renderer.addBarChart(Messages.JavaApplicationPage_METHOD_PROFILING, aggregatorSeries, PROFILING_COLOR);
                rows.add(new ItemRow(String.valueOf(Messages.JavaApplicationPage_METHOD_PROFILING) + threadCount, JdkAggregators.EXECUTION_SAMPLE_COUNT.getDescription(), (IXDataRenderer)renderer, profilingItems));
            }
            if (this.allocationAction.isChecked()) {
                rows.add(DataPageToolkit.buildTimestampHistogram(String.valueOf(Messages.JavaApplicationPage_ROW_ALLOCATION) + threadCount, JdkAggregators.ALLOCATION_TOTAL.getDescription(), selectedItems.apply(JdkFilters.ALLOC_ALL), JdkAggregators.ALLOCATION_TOTAL, DataPageToolkit.ALLOCATION_COLOR));
            }
            if (this.exceptionsAction.isChecked()) {
                rows.add(DataPageToolkit.buildTimestampHistogram(String.valueOf(JdkAggregators.THROWABLES_COUNT.getName()) + threadCount, JdkAggregators.THROWABLES_COUNT.getDescription(), selectedItems.apply(JdkFilters.THROWABLES), JdkAggregators.THROWABLES_COUNT, EXCEPTIONS_COLOR));
            }
            boolean bl = useDefaultSelection = rows.size() > 1;
            if (this.threadActivityAction.isChecked() && this.laneDefs.stream().anyMatch(a -> a.isEnabled()) && selection.getRowCount() > 0) {
                List threadRows = selection.getSelectedRows(this::buildThreadRenderer).collect(Collectors.toList());
                double threadsWeight = Math.sqrt(threadRows.size()) * 0.15;
                double otherRowWeight = Math.max(threadsWeight * 0.1, (1.0 - threadsWeight) / (double)rows.size());
                List weights = Stream.concat(Stream.generate(() -> otherRowWeight).limit(rows.size()), Stream.of(Double.valueOf(threadsWeight))).collect(Collectors.toList());
                rows.add(RendererToolkit.uniformRows(threadRows));
                useDefaultSelection = true;
                rows = Arrays.asList(RendererToolkit.weightedRows(rows, weights));
            }
            IXDataRenderer rr = rows.size() == 1 ? (IXDataRenderer)rows.get(0) : RendererToolkit.uniformRows(rows);
            IXDataRenderer root = this.applicationPauseIdAction.isChecked() ? RendererToolkit.layers((IXDataRenderer[])new IXDataRenderer[]{DataPageToolkit.buildApplicationPauseRow(allItems), rr}) : rr;
            return useDefaultSelection ? new ItemRow(root, this.getDefaultSelection(selectedItems)) : root;
        }

        @Override
        protected List<IAction> initializeChartConfiguration(IState state) {
            this.applicationPauseIdAction = DataPageToolkit.createCheckAction(Messages.JavaApplicationPage_HALTS_ACTION, Messages.JavaApplicationPage_HALTS_ACTION_DESC, JavaApplicationPage.APPLICATION_PAUSE_ID, FlightRecorderUI.getDefault().getMCImageDescriptor("stop.png"), b -> this.buildChart());
            Stream<IAction> attributeActions = Stream.concat(JdkQueries.CPU_USAGE_SIMPLE_QUERY.getAttributes().stream(), Stream.of(JdkAttributes.HEAP_USED)).map(a -> DataPageToolkit.createAttributeCheckAction(a, b -> this.buildChart()));
            this.profilingCountAction = DataPageToolkit.createCheckAction(Messages.JavaApplicationPage_METHOD_PROFILING, Messages.JavaApplicationPage_METHOD_PROFILING_DESC, JavaApplicationPage.PROFILING_COUNT_COL, PROFILING_LEGEND_ICON, b -> this.buildChart());
            this.allocationAction = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.ALLOCATION_TOTAL, JavaApplicationPage.ALLOCATION_COL, DataPageToolkit.ALLOCATION_COLOR, b -> this.buildChart());
            this.exceptionsAction = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.THROWABLES_COUNT, JavaApplicationPage.EXCEPTIONS_COL, EXCEPTIONS_COLOR, b -> this.buildChart());
            this.threadActivityAction = DataPageToolkit.createCheckAction(Messages.JavaApplicationPage_THREAD_ACTIVITY_ACTION, Messages.JavaApplicationPage_THREAD_ACTIVITY_ACTION_DESC, JavaApplicationPage.ACTIVITY_LANES_ID, FlightRecorderUI.getDefault().getMCImageDescriptor("lanes.gif"), b -> this.buildChart());
            this.laneDefs = new ArrayList<LaneEditor.LaneDefinition>();
            Stream.of(state.getChildren(JavaApplicationPage.THREAD_LANE)).map(LaneEditor.LaneDefinition::readFrom).forEach(this.laneDefs::add);
            if (this.laneDefs.isEmpty()) {
                this.laneDefs.add(new LaneEditor.LaneDefinition(Messages.JavaApplicationPage_THREAD_LANE_JAVA_LATENCIES, true, JdkFilters.THREAD_LATENCIES, false));
            }
            LaneEditor.ensureRestLane(this.laneDefs);
            Map<Boolean, List<LaneEditor.LaneDefinition>> lanesByApplicability = this.laneDefs.stream().collect(Collectors.partitioningBy(ld -> ld.isRestLane() || JavaApplicationPage.this.getDataSource().getItems().apply(ld.getFilter()).iterator().hasNext()));
            this.laneDefs = lanesByApplicability.get(true);
            this.naLanes = lanesByApplicability.get(false);
            return Stream.concat(Stream.of(this.applicationPauseIdAction), Stream.concat(attributeActions, Stream.of(this.profilingCountAction, this.allocationAction, this.exceptionsAction, this.threadActivityAction))).collect(Collectors.toList());
        }

        private IXDataRenderer buildThreadRenderer(Object thread, IItemCollection items) {
            String threadName = thread == null ? "" : ((IMCThread)thread).getThreadName();
            List<Object> laneFilters = this.laneDefs == null ? Collections.emptyList() : this.laneDefs;
            ArrayList lanes = new ArrayList(laneFilters.size());
            laneFilters.stream().filter(ld -> ld.isEnabled()).forEach(lane -> {
                IItemCollection laneItems = items.apply(lane.getFilter());
                if (laneItems.iterator().hasNext()) {
                    ISpanSeries laneSeries = QuantitySeries.max((IItemCollection)laneItems, (IAttribute)JfrAttributes.START_TIME, (IAttribute)JfrAttributes.END_TIME);
                    lanes.add(new ItemRow(SpanRenderer.withBoundaries((ISpanSeries)laneSeries, DataPageToolkit.ITEM_COLOR), laneItems));
                }
            });
            IXDataRenderer renderer = !lanes.isEmpty() ? RendererToolkit.uniformRows(lanes) : new ItemRow(RendererToolkit.empty(), ItemCollectionToolkit.EMPTY);
            IItemCollection itemsAndThreadLifespan = this.addThreadLifeSpanEvents(thread, items);
            return new QuantitySpanRenderer(JavaApplicationPage.threadRanges(threadName, itemsAndThreadLifespan), renderer, (Paint)THREAD_BG_COLOR, 10, threadName, null);
        }

        private IItemCollection addThreadLifeSpanEvents(Object thread, IItemCollection items) {
            IItemCollection threadLifeSpan = JavaApplicationPage.this.getDataSource().getItems().apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.equals((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD, (Object)((IMCThread)thread)), ItemFilters.type((String[])new String[]{"com.oracle.jdk.ThreadStart", "com.oracle.jdk.ThreadEnd"})}));
            IItemCollection itemsAndThreadLifespan = ItemCollectionToolkit.merge(() -> Stream.of(items, threadLifeSpan));
            return itemsAndThreadLifespan;
        }

        private IItemCollection getDefaultSelection(IItemCollection items) {
            block16: {
                Object firstElement = ((IStructuredSelection)this.chartLegend.getSelection()).getFirstElement();
                if (firstElement == null) break block16;
                switch (((IAction)firstElement).getId()) {
                    case "profilingCount": {
                        return items.apply(JdkFilters.EXECUTION_SAMPLE);
                    }
                    case "allocation": {
                        return items.apply(JdkFilters.ALLOC_ALL);
                    }
                    case "exceptions": {
                        return items.apply(JdkFilters.THROWABLES);
                    }
                    case "threadActivityLanes": {
                        return items.apply(this.getEnabledLanesFilter());
                    }
                }
            }
            return ItemCollectionToolkit.EMPTY;
        }

        private IItemFilter getEnabledLanesFilter() {
            List<IItemFilter> laneFilters = this.laneDefs.stream().filter(LaneEditor.LaneDefinition::isEnabled).map(ld -> ld.getFilter()).collect(Collectors.toList());
            return ItemFilters.or((IItemFilter[])laneFilters.toArray(new IItemFilter[laneFilters.size()]));
        }

        @Override
        protected void onFilterChange(IItemFilter filter) {
            super.onFilterChange(filter);
            JavaApplicationPage.this.tableFilter = filter;
        }

        @Override
        public void saveTo(IWritableState writableState) {
            super.saveTo(writableState);
            this.laneDefs.stream().forEach(f -> f.saveTo(writableState.createChild(JavaApplicationPage.THREAD_LANE)));
            this.naLanes.stream().forEach(f -> f.saveTo(writableState.createChild(JavaApplicationPage.THREAD_LANE)));
            this.tableFilterComponent.saveState(writableState.createChild(METHOD_PROFILING_TABLE_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            JavaApplicationPage.this.tableState = this.table.getManager().getSelectionState();
            JavaApplicationPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }
    }
}

