/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IDataPageFactory;
import com.oracle.jmc.flightrecorder.ui.IDisplayablePage;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.IPageDefinition;
import com.oracle.jmc.flightrecorder.ui.IPageUI;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.common.AbstractDataPage;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import com.oracle.jmc.flightrecorder.ui.common.FilterComponent;
import com.oracle.jmc.flightrecorder.ui.common.ItemAggregateViewer;
import com.oracle.jmc.flightrecorder.ui.common.ItemHistogram;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.ColumnMenusFactory;
import com.oracle.jmc.ui.column.TableSettings;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import com.oracle.jmc.ui.misc.CompositeToolkit;
import com.oracle.jmc.ui.misc.PersistableSashForm;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class JVMInformationPage
extends AbstractDataPage {
    private static final Set<String> FLAGS;
    private static final IItemFilter FLAGS_FILTER;
    private static final IAccessorFactory<?> FLAG_VALUE_FIELD;
    private static final String SASH = "sash";
    private static final String JVM_FLAGS = "jvmFlags";
    private static final String JVM_FLAGS_FILTER = "jvmFlagsFilter";
    private static final String FLAG_VALUE_COL_ID = "value";
    private static final ItemHistogram.CompositeKeyHistogramBuilder FLAG_HISTOGRAM;
    private IItemFilter flagsFilter;
    private ColumnManager.SelectionState flagsSelection;

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("com.oracle.jdk.LongFlag");
        types.add("com.oracle.jdk.UnsignedLongFlag");
        types.add("com.oracle.jdk.DoubleFlag");
        types.add("com.oracle.jdk.BooleanFlag");
        types.add("com.oracle.jdk.StringFlag");
        types.add("com.oracle.jdk.IntFlag");
        types.add("com.oracle.jdk.UnsignedIntFlag");
        FLAGS = Collections.unmodifiableSet(types);
        FLAGS_FILTER = ItemFilters.type(FLAGS);
        FLAG_VALUE_FIELD = new IAccessorFactory<Object>(){

            public <T> IMemberAccessor<?, T> getAccessor(IType<T> type) {
                switch (type.getIdentifier()) {
                    case "com.oracle.jdk.UnsignedLongFlag": 
                    case "com.oracle.jdk.IntFlag": 
                    case "com.oracle.jdk.LongFlag": 
                    case "com.oracle.jdk.DoubleFlag": 
                    case "com.oracle.jdk.UnsignedIntFlag": {
                        return JdkAttributes.FLAG_VALUE_NUMBER.getAccessor(type);
                    }
                    case "com.oracle.jdk.BooleanFlag": {
                        return JdkAttributes.FLAG_VALUE_BOOLEAN.getAccessor(type);
                    }
                    case "com.oracle.jdk.StringFlag": {
                        return JdkAttributes.FLAG_VALUE_TEXT.getAccessor(type);
                    }
                }
                return null;
            }
        };
        FLAG_HISTOGRAM = new ItemHistogram.CompositeKeyHistogramBuilder();
        FLAG_HISTOGRAM.addKeyColumn(JdkAttributes.FLAG_NAME);
        FLAG_HISTOGRAM.addKeyColumn(JdkAttributes.FLAG_ORIGIN);
        FLAG_HISTOGRAM.addKeyColumn(FLAG_VALUE_COL_ID, Messages.JVMInformationPage_COLUMN_VALUE, FLAG_VALUE_FIELD);
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new JVMInformationUi(parent, toolkit, pageContainer, state);
    }

    public JVMInformationPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ItemFilters.or((IItemFilter[])new IItemFilter[]{FLAGS_FILTER, JdkFilters.VM_INFO});
    }

    public static class JVMInformationPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.JVMInformationPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/jvminformation.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"jvm_information"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new JVMInformationPage(dpd, items, editor);
        }
    }

    private class JVMInformationUi
    implements IPageUI {
        private final ItemAggregateViewer infoViewer;
        private final ItemHistogram allFlagsTable;
        private FilterComponent allFlagsFilter;
        private final SashForm sash;

        JVMInformationUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            Form form = DataPageToolkit.createForm(parent, toolkit, JVMInformationPage.this.getName(), JVMInformationPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 256);
            this.sash.setLayoutData((Object)new GridData(4, 4, true, true));
            Section jvmInfSection = CompositeToolkit.createSection((Composite)this.sash, (FormToolkit)toolkit, (String)Messages.JVMInformationPage_SECTION_JVM_INFO);
            this.infoViewer = new ItemAggregateViewer((Composite)jvmInfSection, toolkit);
            this.infoViewer.addAggregate(JdkAggregators.JVM_START_TIME);
            this.infoViewer.addAggregate(JdkAggregators.JVM_NAME);
            this.infoViewer.addAggregate(JdkAggregators.JVM_VERSION);
            this.infoViewer.addAggregate(JdkAggregators.JVM_ARGUMENTS);
            this.infoViewer.addAggregate(JdkAggregators.JAVA_ARGUMENTS);
            jvmInfSection.setClient(this.infoViewer.getControl());
            Section allFlagsSection = CompositeToolkit.createSection((Composite)this.sash, (FormToolkit)toolkit, (String)Messages.JVMInformationPage_SECTION_JVM_FLAGS);
            this.allFlagsTable = FLAG_HISTOGRAM.buildWithoutBorder((Composite)allFlagsSection, new TableSettings(state.getChild(JVMInformationPage.JVM_FLAGS)));
            this.allFlagsFilter = FilterComponent.createFilterComponent(this.allFlagsTable, JVMInformationPage.this.flagsFilter, JVMInformationPage.this.getDataSource().getItems().apply(FLAGS_FILTER), pageContainer.getSelectionStore()::getSelections, this::onFilterChange);
            MCContextMenuManager mm = MCContextMenuManager.create((Control)this.allFlagsTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.allFlagsTable.getManager(), (MCContextMenuManager)mm);
            mm.add(this.allFlagsFilter.getShowFilterAction());
            mm.add(this.allFlagsFilter.getShowSearchAction());
            allFlagsSection.setClient((Control)this.allFlagsFilter.getComponent());
            ColumnViewer viewer = this.allFlagsTable.getManager().getViewer();
            viewer.addSelectionChangedListener(e -> pageContainer.showSelection(this.allFlagsTable.getSelection().getItems()));
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(JVMInformationPage.SASH));
            this.allFlagsFilter.loadState(JVMInformationPage.this.getState().getChild(JVMInformationPage.JVM_FLAGS_FILTER));
            this.infoViewer.setValues(JVMInformationPage.this.getDataSource().getItems());
            this.allFlagsTable.show(JVMInformationPage.this.getDataSource().getItems().apply(FLAGS_FILTER));
            this.onFilterChange(JVMInformationPage.this.flagsFilter);
            JVMInformationPage.this.addResultActions(form);
            this.allFlagsTable.getManager().setSelectionState(JVMInformationPage.this.flagsSelection);
        }

        private void onFilterChange(IItemFilter filter) {
            this.allFlagsFilter.filterChangeHelper(filter, this.allFlagsTable, JVMInformationPage.this.getDataSource().getItems().apply(FLAGS_FILTER));
            JVMInformationPage.this.flagsFilter = filter;
        }

        public void saveTo(IWritableState memento) {
            this.allFlagsTable.getManager().getSettings().saveState(memento.createChild(JVMInformationPage.JVM_FLAGS));
            this.allFlagsFilter.saveState(memento.createChild(JVMInformationPage.JVM_FLAGS_FILTER));
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)memento.createChild(JVMInformationPage.SASH));
            this.saveToLocal();
        }

        private void saveToLocal() {
            JVMInformationPage.this.flagsSelection = this.allFlagsTable.getManager().getSelectionState();
        }
    }
}

