/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IItemQuery;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.item.ItemQueryBuilder;
import com.oracle.jmc.common.item.ItemToolkit;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.unit.LinearKindOfQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.jdk.memory.ReferenceStatisticsType;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IDataPageFactory;
import com.oracle.jmc.flightrecorder.ui.IDisplayablePage;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.IPageDefinition;
import com.oracle.jmc.flightrecorder.ui.IPageUI;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.common.AbstractDataPage;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import com.oracle.jmc.flightrecorder.ui.common.FilterComponent;
import com.oracle.jmc.flightrecorder.ui.common.FlavorSelector;
import com.oracle.jmc.flightrecorder.ui.common.ItemList;
import com.oracle.jmc.flightrecorder.ui.common.ItemRow;
import com.oracle.jmc.flightrecorder.ui.common.TypeLabelProvider;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import com.oracle.jmc.ui.charts.AWTChartToolkit;
import com.oracle.jmc.ui.charts.ISpanSeries;
import com.oracle.jmc.ui.charts.IXDataRenderer;
import com.oracle.jmc.ui.charts.QuantitySeries;
import com.oracle.jmc.ui.charts.RendererToolkit;
import com.oracle.jmc.ui.charts.SpanRenderer;
import com.oracle.jmc.ui.charts.XYChart;
import com.oracle.jmc.ui.column.ColumnBuilder;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.ColumnMenusFactory;
import com.oracle.jmc.ui.column.IColumn;
import com.oracle.jmc.ui.column.TableSettings;
import com.oracle.jmc.ui.handlers.ActionToolkit;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import com.oracle.jmc.ui.misc.ActionUiToolkit;
import com.oracle.jmc.ui.misc.ChartCanvas;
import com.oracle.jmc.ui.misc.PersistableSashForm;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GarbageCollectionsPage
extends AbstractDataPage {
    private static final ReferenceStatisticsType[] REF_TYPE = ReferenceStatisticsType.values();
    private static final String SASH = "sash";
    private static final String TABLE_SASH = "tableSash";
    private static final String GCS = "gcs";
    private static final String CHART = "chart";
    private static final String PHASE_TABLE_FILTER = "phaseTableFilter";
    private static final String GC_TABLE_FILTER = "gcTableFilter";
    private static final String METASPACE_TABLE_FILTER = "metaspaceTableFilter";
    private static final String PHASE_LIST = "phaseList";
    private static final String METASPACE_LIST = "metaspaceList";
    private static final Color LONGEST_PAUSE_COLOR = DataPageToolkit.GC_BASE_COLOR.brighter();
    private static final Color SUM_OF_PAUSES_COLOR = DataPageToolkit.GC_BASE_COLOR.brighter().brighter();
    private static final IItemQuery METASPACE_SUMMARY = ItemQueryBuilder.fromWhere((IItemFilter)JdkFilters.METASPACE_SUMMARY).select(new IAttribute[]{JdkAttributes.GC_METASPACE_USED, JdkAttributes.GC_METASPACE_CAPACITY, JdkAttributes.GC_METASPACE_COMMITTED, JdkAttributes.GC_METASPACE_RESERVED}).build();
    private static final ItemList.ItemListBuilder PHASES = new ItemList.ItemListBuilder();
    private static final ItemList.ItemListBuilder METASPACE = new ItemList.ItemListBuilder();
    private IItemFilter tableFilterState;
    private IItemFilter phasesFilterState;
    private IItemFilter metaspaceFilterState;
    private IRange<IQuantity> timelineRange;
    private ColumnManager.SelectionState gcListSelection;
    private ColumnManager.SelectionState phasesSelection;
    private ColumnManager.SelectionState metaspaceSelection;
    private int gcInfoTabSelection = 0;
    public FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        PHASES.addColumn(JfrAttributes.EVENT_TYPE);
        PHASES.addColumn(JdkAttributes.GC_PHASE_NAME);
        PHASES.addColumn(JfrAttributes.DURATION);
        PHASES.addColumn(JfrAttributes.START_TIME);
        PHASES.addColumn(JdkAttributes.GC_ID);
        METASPACE.addColumn(JdkAttributes.GC_METASPACE_USED);
        METASPACE.addColumn(JdkAttributes.GC_DATASPACE_COMMITTED);
        METASPACE.addColumn(JdkAttributes.GC_DATASPACE_RESERVED);
        METASPACE.addColumn(JdkAttributes.GC_DATASPACE_USED);
        METASPACE.addColumn(JdkAttributes.GC_CLASSSPACE_COMMITTED);
        METASPACE.addColumn(JdkAttributes.GC_CLASSSPACE_RESERVED);
        METASPACE.addColumn(JdkAttributes.GC_CLASSSPACE_USED);
        METASPACE.addColumn(JdkAttributes.GC_THRESHOLD);
        METASPACE.addColumn(JdkAttributes.GC_WHEN);
        METASPACE.addColumn(JdkAttributes.GC_ID);
        METASPACE.addColumn(JfrAttributes.START_TIME);
    }

    private static void logDuplicateGcId(GC duplicateGC) {
        if (duplicateGC != null) {
            IQuantity gcID = (IQuantity)JdkAttributes.GC_ID.getAccessor(ItemToolkit.getItemType((IItem)duplicateGC.gcItem)).getMember((Object)duplicateGC.gcItem);
            FlightRecorderUI.getDefault().getLogger().severe("GC with id " + gcID + " is duplicated");
        }
    }

    private static IColumn buildGCItemAttributeColumn(IAttribute<?> a, IMemberAccessor<?, Object> cellAccessor) {
        int style = a.getContentType() instanceof LinearKindOfQuantity ? 131072 : 0;
        return new ColumnBuilder(a.getName(), a.getIdentifier(), cellAccessor).description(a.getDescription()).style(style).build();
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new GarbageCollectionsUi(parent, toolkit, pageContainer, state);
    }

    public GarbageCollectionsPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.timelineRange = editor.getFullRange();
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.GC_PAUSE, JdkFilters.GC_PAUSE_PHASE, JdkFilters.HEAP_SUMMARY, JdkFilters.METASPACE_SUMMARY});
    }

    private static Set<String> calculateExcludedAttributeIds(IItemCollection items) {
        Stream<Object> exclude = METASPACE_SUMMARY.getAttributes().stream();
        Iterator iterator = items.apply(METASPACE_SUMMARY.getFilter()).iterator();
        if (iterator.hasNext()) {
            IType type = ((IItemIterable)iterator.next()).getType();
            exclude = exclude.filter(a -> a.getAccessor(type) == null);
        }
        return exclude.map(ICanonicalAccessorFactory::getIdentifier).collect(Collectors.toSet());
    }

    private static class GC {
        final IType<IItem> type;
        final IItem gcItem;
        final Object[] referenceStatisticsData;
        IQuantity gcId;
        IQuantity duration;
        String gcCause;
        String gcName;
        IQuantity longestPause;
        IQuantity sumOfPauses;
        IQuantity startTime;
        IQuantity endTime;
        IQuantity usedDelta;
        IQuantity committedDelta;
        IQuantity usedMetaspaceDelta;
        IQuantity committedMetaspaceDelta;

        GC(IItem gcItem, IType<IItem> type) {
            this.type = type;
            this.gcItem = gcItem;
            this.referenceStatisticsData = new Object[REF_TYPE.length];
            this.usedDelta = UnitLookup.BYTES.quantity(0L);
            this.committedDelta = UnitLookup.BYTES.quantity(0L);
            this.usedMetaspaceDelta = UnitLookup.BYTES.quantity(0L);
            this.committedMetaspaceDelta = UnitLookup.BYTES.quantity(0L);
        }

        Object getRefCount(ReferenceStatisticsType type) {
            return this.referenceStatisticsData[type.ordinal()];
        }

        void setRefCount(Object type, Object count) {
            int i = 0;
            while (i < REF_TYPE.length) {
                if (REF_TYPE[i].typeValue.equals(type)) {
                    this.referenceStatisticsData[i] = count;
                    break;
                }
                ++i;
            }
        }
    }

    public static class GarbageCollectionPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.GarbageCollectionsPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/gc.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"garbage_collection"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new GarbageCollectionsPage(dpd, items, editor);
        }
    }

    private class GarbageCollectionsUi
    implements IPageUI {
        private final SashForm sash;
        private final SashForm tableSash;
        private final IPageContainer pageContainer;
        private final ChartCanvas chartCanvas;
        private final ColumnManager gcList;
        private IXDataRenderer renderRoot = RendererToolkit.empty();
        private final IAction enablePhases = ActionToolkit.checkAction(b -> this.buildChart(), (String)Messages.GarbageCollectionsPage_ROW_PAUSE_PHASES, (String)Messages.GarbageCollectionsPage_ROW_PAUSE_PHASES_DESC, (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("parts.png"), (String)"phases");
        private final IAction longestPause = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.LONGEST_GC_PAUSE, "longestPause", GarbageCollectionsPage.access$2(), b -> this.buildChart());
        private final IAction sumOfPauses = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.TOTAL_GC_PAUSE, "sumOfPauses", GarbageCollectionsPage.access$3(), b -> this.buildChart());
        private final List<IAction> allChartSeriesActions = Stream.concat(Stream.concat(JdkQueries.HEAP_SUMMARY.getAttributes().stream(), GarbageCollectionsPage.access$4().getAttributes().stream()).map(a -> DataPageToolkit.createAttributeCheckAction(a, b -> this.buildChart())), Stream.of(this.longestPause, this.sumOfPauses, this.enablePhases)).collect(Collectors.toList());
        private final Set<String> excludedAttributeIds;
        private FilterComponent tableFilter;
        private XYChart gcChart;
        private IRange<IQuantity> currentRange;
        private ItemList phasesList;
        private FilterComponent phasesFilter;
        private ItemList metaspaceList;
        private FilterComponent metaspaceFilter;
        private CTabFolder gcInfoFolder;
        private IItemCollection selectionItems;
        private FlavorSelector flavorSelector;

        GarbageCollectionsUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.pageContainer = pageContainer;
            this.excludedAttributeIds = GarbageCollectionsPage.calculateExcludedAttributeIds(GarbageCollectionsPage.this.getDataSource().getItems());
            Form form = DataPageToolkit.createForm(parent, toolkit, GarbageCollectionsPage.this.getName(), GarbageCollectionsPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            toolkit.adapt((Composite)this.sash);
            this.tableSash = new SashForm((Composite)this.sash, 256);
            toolkit.adapt((Composite)this.tableSash);
            TableViewer tableViewer = new TableViewer((Composite)this.tableSash, 268501762);
            tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
            ArrayList<IColumn> columns = new ArrayList<IColumn>();
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JdkAttributes.GC_ID, o -> ((GC)o).gcId));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JfrAttributes.DURATION, o -> ((GC)o).duration));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JdkAttributes.GC_CAUSE, o -> ((GC)o).gcCause));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JdkAttributes.GC_NAME, o -> ((GC)o).gcName));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JdkAttributes.GC_LONGEST_PAUSE, o -> ((GC)o).longestPause));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JdkAttributes.GC_SUM_OF_PAUSES, o -> ((GC)o).sumOfPauses));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JfrAttributes.START_TIME, o -> ((GC)o).startTime));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JfrAttributes.END_TIME, o -> ((GC)o).endTime));
            ReferenceStatisticsType[] referenceStatisticsTypeArray = REF_TYPE;
            int n = referenceStatisticsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceStatisticsType t = referenceStatisticsTypeArray[n2];
                columns.add(new ColumnBuilder(t.localizedName, "ReferenceStatisticsType-" + t.name(), o -> ((GC)o).getRefCount(t)).style(131072).build());
                ++n2;
            }
            columns.add(new ColumnBuilder(Messages.GarbageCollectionsPage_USED_HEAP_DELTA, "usedHeapDelta", o -> ((GC)o).usedDelta).style(131072).build());
            columns.add(new ColumnBuilder(Messages.GarbageCollectionsPage_COMMITTED_HEAP_DELTA, "committedHeapDelta", o -> ((GC)o).committedDelta).style(131072).build());
            columns.add(new ColumnBuilder(Messages.GarbageCollectionsPage_USED_METASPACE_DELTA, "usedMetaspaceDelta", o -> ((GC)o).usedMetaspaceDelta).style(131072).build());
            columns.add(new ColumnBuilder(Messages.GarbageCollectionsPage_COMMITTED_METASPACE_DELTA, "committedMetaspaceDelta", o -> ((GC)o).committedMetaspaceDelta).style(131072).build());
            this.gcList = ColumnManager.build((TableViewer)tableViewer, columns, (TableSettings)TableSettings.forState((IState)state.getChild(GarbageCollectionsPage.GCS)));
            MCContextMenuManager itemListMm = MCContextMenuManager.create((Control)this.gcList.getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.gcList, (MCContextMenuManager)itemListMm);
            this.gcList.getViewer().addSelectionChangedListener(e -> {
                this.buildChart();
                pageContainer.showSelection(ItemCollectionToolkit.build(this.gcSelectedGcItems()));
                this.updatePhaseList();
                this.updateMetaspaceList();
            });
            SelectionStoreActionToolkit.addSelectionStoreActions((StructuredViewer)this.gcList.getViewer(), pageContainer.getSelectionStore(), () -> ItemCollectionToolkit.build(this.gcSelectedGcItems()), Messages.GarbageCollectionsPage_LIST_SELECTION, (IContributionManager)itemListMm);
            this.tableFilter = FilterComponent.createFilterComponent(tableViewer.getControl(), this.gcList, GarbageCollectionsPage.this.tableFilterState, GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.GARBAGE_COLLECTION), pageContainer.getSelectionStore()::getSelections, this::onFilterChange);
            itemListMm.add(this.tableFilter.getShowFilterAction());
            itemListMm.add(this.tableFilter.getShowSearchAction());
            this.gcInfoFolder = new CTabFolder((Composite)this.tableSash, 0);
            this.phasesList = PHASES.buildWithoutBorder((Composite)this.gcInfoFolder, TableSettings.forState((IState)state.getChild(GarbageCollectionsPage.PHASE_LIST)));
            this.phasesList.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.phasesList.getSelection().get())));
            this.phasesFilter = FilterComponent.createFilterComponent(this.phasesList, GarbageCollectionsPage.this.phasesFilterState, this.getPhaseItems(), pageContainer.getSelectionStore()::getSelections, this::onPhasesFilterChange);
            MCContextMenuManager phasesMm = MCContextMenuManager.create((Control)this.phasesList.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.phasesList.getManager(), (MCContextMenuManager)phasesMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.phasesList, Messages.GarbageCollectionsPage_PAUSE_PHASE_SELECTION, (IContributionManager)phasesMm);
            phasesMm.add(this.phasesFilter.getShowFilterAction());
            phasesMm.add(this.phasesFilter.getShowSearchAction());
            DataPageToolkit.addTabItem(this.gcInfoFolder, (Control)this.phasesFilter.getComponent(), Messages.GarbageCollectionsPage_PAUSE_PHASES_TITLE);
            this.metaspaceList = METASPACE.buildWithoutBorder((Composite)this.gcInfoFolder, TableSettings.forState((IState)state.getChild(GarbageCollectionsPage.METASPACE_LIST)));
            this.metaspaceList.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.metaspaceList.getSelection().get())));
            this.metaspaceFilter = FilterComponent.createFilterComponent(this.metaspaceList, GarbageCollectionsPage.this.metaspaceFilterState, this.getMetaspaceItems(), pageContainer.getSelectionStore()::getSelections, this::onMetaspaceFilterChange);
            MCContextMenuManager metaspaceMm = MCContextMenuManager.create((Control)this.metaspaceList.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.metaspaceList.getManager(), (MCContextMenuManager)metaspaceMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.metaspaceList, Messages.GarbageCollectionsPage_METASPACE_SELECTION, (IContributionManager)metaspaceMm);
            metaspaceMm.add(this.metaspaceFilter.getShowFilterAction());
            metaspaceMm.add(this.metaspaceFilter.getShowSearchAction());
            DataPageToolkit.addTabItem(this.gcInfoFolder, (Control)this.metaspaceFilter.getComponent(), Messages.GarbageCollectionsPage_METASPACE_TITLE);
            Composite chartContainer = toolkit.createComposite((Composite)this.sash);
            chartContainer.setLayout((Layout)new GridLayout(2, false));
            this.chartCanvas = new ChartCanvas(chartContainer);
            this.chartCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
            ActionToolkit.loadCheckState((IState)state.getChild(GarbageCollectionsPage.CHART), this.allChartSeriesActions.stream());
            Control chartLegend = ActionUiToolkit.buildCheckboxControl((Composite)chartContainer, this.allChartSeriesActions.stream().filter(a -> this.includeAttribute(a.getId())), (boolean)true);
            GridData gd = new GridData(4, 4, false, true);
            gd.widthHint = 180;
            chartLegend.setLayoutData((Object)gd);
            DataPageToolkit.createChartTimestampTooltip(this.chartCanvas);
            this.gcChart = new XYChart(pageContainer.getFullRange(), this.renderRoot, 180);
            this.gcChart.setVisibleRange((IQuantity)GarbageCollectionsPage.this.timelineRange.getStart(), (IQuantity)GarbageCollectionsPage.this.timelineRange.getEnd());
            this.gcChart.addVisibleRangeListener(r -> {
                IRange<IQuantity> iRange = r;
                IRange<IQuantity> iRange2 = iRange;
                GarbageCollectionsPage.this.timelineRange = iRange;
            });
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(GarbageCollectionsPage.SASH));
            PersistableSashForm.loadState((SashForm)this.tableSash, (IState)state.getChild(GarbageCollectionsPage.TABLE_SASH));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, JdkFilters.GARBAGE_COLLECTION, GarbageCollectionsPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, this::onShow, GarbageCollectionsPage.this.flavorSelectorState);
            this.gcInfoFolder.setSelection(GarbageCollectionsPage.this.gcInfoTabSelection);
            GarbageCollectionsPage.this.addResultActions(form);
            this.tableFilter.loadState(state.getChild(GarbageCollectionsPage.GC_TABLE_FILTER));
            this.phasesFilter.loadState(state.getChild(GarbageCollectionsPage.PHASE_TABLE_FILTER));
            this.metaspaceFilter.loadState(state.getChild(GarbageCollectionsPage.METASPACE_TABLE_FILTER));
            this.gcList.setSelectionState(GarbageCollectionsPage.this.gcListSelection);
            this.phasesList.getManager().setSelectionState(GarbageCollectionsPage.this.phasesSelection);
            this.metaspaceList.getManager().setSelectionState(GarbageCollectionsPage.this.metaspaceSelection);
        }

        private void updatePhaseList() {
            this.phasesList.show(ItemCollectionToolkit.filterIfNotNull(this.getPhaseItems(), GarbageCollectionsPage.this.phasesFilterState));
        }

        private void updateMetaspaceList() {
            this.metaspaceList.show(ItemCollectionToolkit.filterIfNotNull(this.getMetaspaceItems(), GarbageCollectionsPage.this.metaspaceFilterState));
        }

        private IItemCollection getMetaspaceItems() {
            Set<IQuantity> selectedGcIds = this.getSelectedGcIds();
            IItemCollection metaspaceItems = GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.METASPACE_SUMMARY).apply(ItemFilters.memberOf((ICanonicalAccessorFactory)JdkAttributes.GC_ID, selectedGcIds));
            return metaspaceItems;
        }

        private IItemCollection getPhaseItems() {
            Set<IQuantity> gcIds = this.getSelectedGcIds();
            IItemCollection gcIdPausePhases = GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.GC_PAUSE_PHASE).apply(ItemFilters.memberOf((ICanonicalAccessorFactory)JdkAttributes.GC_ID, gcIds));
            return gcIdPausePhases;
        }

        private Set<IQuantity> getSelectedGcIds() {
            List selected = ((IStructuredSelection)this.gcList.getViewer().getSelection()).toList();
            Set<IQuantity> gcIds = selected.stream().map(gc -> (IQuantity)gc.type.getAccessor(JdkAttributes.GC_ID.getKey()).getMember((Object)gc.gcItem)).collect(Collectors.toSet());
            return gcIds;
        }

        private void onFilterChange(IItemFilter newFilter) {
            IItemCollection items = this.selectionItems != null ? this.selectionItems : GarbageCollectionsPage.this.getDataSource().getItems();
            items = items.apply(JdkFilters.GARBAGE_COLLECTION);
            if (this.tableFilter.isVisible()) {
                this.updateTable(ItemCollectionToolkit.filterIfNotNull(items, newFilter));
                Object input = this.gcList.getViewer().getInput();
                this.tableFilter.setColor(input instanceof Object[] && ((Object[])input).length > 0 ? 1 : 0);
            } else {
                this.updateTable(items);
            }
            GarbageCollectionsPage.this.tableFilterState = newFilter;
        }

        private void onPhasesFilterChange(IItemFilter filter) {
            this.phasesFilter.filterChangeHelper(filter, this.phasesList, this.getPhaseItems());
            GarbageCollectionsPage.this.phasesFilterState = filter;
        }

        private void onMetaspaceFilterChange(IItemFilter filter) {
            this.metaspaceFilter.filterChangeHelper(filter, this.metaspaceList, this.getMetaspaceItems());
            GarbageCollectionsPage.this.metaspaceFilterState = filter;
        }

        private ItemRow buildSpanRow(IItemCollection items, String typeId) {
            IItemCollection filtered = items.apply(ItemFilters.type((String)typeId));
            return new ItemRow(DataPageToolkit.buildSpanRenderer(filtered, (AWTChartToolkit.IColorProvider<IItem>)AWTChartToolkit.staticColor((Color)TypeLabelProvider.getColorOrDefault(typeId))), filtered);
        }

        private void buildChart() {
            IItemCollection allItems = GarbageCollectionsPage.this.getDataSource().getItems();
            ArrayList<IXDataRenderer> rows = new ArrayList<IXDataRenderer>();
            Predicate<IAttribute<IQuantity>> legendFilter = this::isAttributeEnabled;
            DataPageToolkit.buildLinesRow(Messages.GarbageCollectionsPage_ROW_HEAP, Messages.GarbageCollectionsPage_ROW_HEAP_DESC, allItems, false, JdkQueries.HEAP_SUMMARY, legendFilter, (IQuantity)UnitLookup.BYTES.quantity(0L), null).ifPresent(rows::add);
            DataPageToolkit.buildLinesRow(Messages.GarbageCollectionsPage_ROW_METASPACE, Messages.GarbageCollectionsPage_ROW_METASPACE_DESC, allItems, false, METASPACE_SUMMARY, legendFilter, (IQuantity)UnitLookup.BYTES.quantity(0L), null).ifPresent(rows::add);
            ArrayList<IXDataRenderer> gcPauseRows = new ArrayList<IXDataRenderer>();
            IItemCollection pauseEvents = allItems.apply(JdkFilters.GC_PAUSE);
            if (this.longestPause.isChecked()) {
                gcPauseRows.add(DataPageToolkit.buildTimestampHistogramRenderer(pauseEvents, JdkAggregators.LONGEST_GC_PAUSE, LONGEST_PAUSE_COLOR));
            }
            if (this.sumOfPauses.isChecked()) {
                gcPauseRows.add(DataPageToolkit.buildTimestampHistogramRenderer(pauseEvents, JdkAggregators.TOTAL_GC_PAUSE, SUM_OF_PAUSES_COLOR));
            }
            if (!gcPauseRows.isEmpty()) {
                rows.add(RendererToolkit.layers((IXDataRenderer[])new IXDataRenderer[]{DataPageToolkit.buildGcPauseRow(allItems), RendererToolkit.uniformRows(gcPauseRows)}));
            }
            if (this.enablePhases.isChecked()) {
                ItemRow pauses = this.buildSpanRow(allItems, "com.oracle.jdk.GCPhasePause");
                ItemRow l1 = this.buildSpanRow(allItems, "com.oracle.jdk.GCPhasePauseLevel1");
                ItemRow l2 = this.buildSpanRow(allItems, "com.oracle.jdk.GCPhasePauseLevel2");
                ItemRow l3 = this.buildSpanRow(allItems, "com.oracle.jdk.GCPhasePauseLevel3");
                rows.add(RendererToolkit.uniformRows(Arrays.asList(pauses, l1, l2, l3), (String)this.enablePhases.getText()));
            }
            this.renderRoot = RendererToolkit.layers((IXDataRenderer[])new IXDataRenderer[]{RendererToolkit.uniformRows(rows), this.buildTableSelectionRenderer()});
            this.chartCanvas.replaceRenderer(this.renderRoot);
        }

        private boolean isAttributeEnabled(IAttribute<IQuantity> attr) {
            String id = attr.getIdentifier();
            return this.includeAttribute(id) && this.allChartSeriesActions.stream().filter(a -> id.equals(a.getId())).findAny().get().isChecked();
        }

        private boolean includeAttribute(String attrId) {
            return !this.excludedAttributeIds.contains(attrId);
        }

        private IXDataRenderer buildTableSelectionRenderer() {
            Supplier<Stream<? extends IItem>> phaseSelection = this.phasesList.getSelection();
            Stream<? extends IItem> gcItems = phaseSelection.get().count() > 0L ? phaseSelection.get() : this.gcSelectedGcItems();
            ISpanSeries gcBackdrop = QuantitySeries.max((IItemCollection)ItemCollectionToolkit.build(gcItems), (IAttribute)JfrAttributes.START_TIME, (IAttribute)JfrAttributes.END_TIME);
            return SpanRenderer.build((ISpanSeries)gcBackdrop, (AWTChartToolkit.IColorProvider)AWTChartToolkit.staticColor((Color)new Color(100, 180, 220, 150)));
        }

        public void saveTo(IWritableState memento) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)memento.createChild(GarbageCollectionsPage.SASH));
            PersistableSashForm.saveState((SashForm)this.tableSash, (IWritableState)memento.createChild(GarbageCollectionsPage.TABLE_SASH));
            this.gcList.getSettings().saveState(memento.createChild(GarbageCollectionsPage.GCS));
            this.phasesList.getManager().getSettings().saveState(memento.createChild(GarbageCollectionsPage.PHASE_LIST));
            this.metaspaceList.getManager().getSettings().saveState(memento.createChild(GarbageCollectionsPage.METASPACE_LIST));
            ActionToolkit.saveCheckState((IWritableState)memento.createChild(GarbageCollectionsPage.CHART), this.allChartSeriesActions.stream());
            this.tableFilter.saveState(memento.createChild(GarbageCollectionsPage.GC_TABLE_FILTER));
            this.phasesFilter.saveState(memento.createChild(GarbageCollectionsPage.PHASE_TABLE_FILTER));
            this.metaspaceFilter.saveState(memento.createChild(GarbageCollectionsPage.METASPACE_TABLE_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            GarbageCollectionsPage.this.gcListSelection = this.gcList.getSelectionState();
            GarbageCollectionsPage.this.phasesSelection = this.phasesList.getManager().getSelectionState();
            GarbageCollectionsPage.this.metaspaceSelection = this.metaspaceList.getManager().getSelectionState();
            GarbageCollectionsPage.this.gcInfoTabSelection = this.gcInfoFolder.getSelectionIndex();
            GarbageCollectionsPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        private void updateTable(IItemCollection gcs) {
            HashMap gcMap = new HashMap();
            gcs.forEach(is -> {
                IMemberAccessor gcIdAccessor = JdkAttributes.GC_ID.getAccessor(is.getType());
                IMemberAccessor durationAccessor = JfrAttributes.DURATION.getAccessor(is.getType());
                IMemberAccessor causeAccessor = JdkAttributes.GC_CAUSE.getAccessor(is.getType());
                IMemberAccessor nameAccessor = JdkAttributes.GC_NAME.getAccessor(is.getType());
                IMemberAccessor longestPauseAccessor = JdkAttributes.GC_LONGEST_PAUSE.getAccessor(is.getType());
                IMemberAccessor sumPauseAccessor = JdkAttributes.GC_SUM_OF_PAUSES.getAccessor(is.getType());
                IMemberAccessor startTimeAccessor = JfrAttributes.START_TIME.getAccessor(is.getType());
                IMemberAccessor endTimeAccessor = JfrAttributes.END_TIME.getAccessor(is.getType());
                is.forEach(item -> {
                    GC value = new GC((IItem)item, (IType<IItem>)is.getType());
                    value.gcId = (IQuantity)gcIdAccessor.getMember(item);
                    value.duration = (IQuantity)durationAccessor.getMember(item);
                    value.gcCause = (String)causeAccessor.getMember(item);
                    value.gcName = (String)nameAccessor.getMember(item);
                    value.longestPause = (IQuantity)longestPauseAccessor.getMember(item);
                    value.sumOfPauses = (IQuantity)sumPauseAccessor.getMember(item);
                    value.startTime = (IQuantity)startTimeAccessor.getMember(item);
                    value.endTime = (IQuantity)endTimeAccessor.getMember(item);
                    GarbageCollectionsPage.logDuplicateGcId(gcMap.put(gcIdAccessor.getMember(item), value));
                });
            });
            IItemCollection refItems = GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.REFERENCE_STATISTICS);
            refItems.forEach(is -> {
                IMemberAccessor gdIdAccessor = JdkAttributes.GC_ID.getAccessor(is.getType());
                IMemberAccessor typeAccessor = JdkAttributes.REFERENCE_STATISTICS_TYPE.getAccessor(is.getType());
                IMemberAccessor countAccessor = JdkAttributes.REFERENCE_STATISTICS_COUNT.getAccessor(is.getType());
                is.forEach(item -> {
                    GC gc = (GC)gcMap.get(gdIdAccessor.getMember(item));
                    if (gc != null) {
                        gc.setRefCount(typeAccessor.getMember(item), countAccessor.getMember(item));
                    }
                });
            });
            IItemCollection heapItems = GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.HEAP_SUMMARY);
            heapItems.forEach(is -> {
                IMemberAccessor gcIdAccessor = JdkAttributes.GC_ID.getAccessor(is.getType());
                IMemberAccessor gcWhenAccessor = JdkAttributes.GC_WHEN.getAccessor(is.getType());
                IMemberAccessor usedHeapAccessor = JdkAttributes.HEAP_USED.getAccessor(is.getType());
                IMemberAccessor committedHeapAccessor = JdkAttributes.GC_HEAPSPACE_COMMITTED.getAccessor(is.getType());
                is.forEach(item -> {
                    GC gc = (GC)gcMap.get(gcIdAccessor.getMember(item));
                    if (gc != null) {
                        String when = (String)gcWhenAccessor.getMember(item);
                        if ("Before GC".equals(when)) {
                            gc.usedDelta = gc.usedDelta.subtract((IQuantity)usedHeapAccessor.getMember(item));
                            gc.committedDelta = gc.committedDelta.subtract((IQuantity)committedHeapAccessor.getMember(item));
                        } else {
                            gc.usedDelta = gc.usedDelta.add((IQuantity)usedHeapAccessor.getMember(item));
                            gc.committedDelta = gc.committedDelta.add((IQuantity)committedHeapAccessor.getMember(item));
                        }
                    }
                });
            });
            IItemCollection metaspaceItems = GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.METASPACE_SUMMARY);
            metaspaceItems.forEach(is -> {
                IMemberAccessor gcIdAccessor = JdkAttributes.GC_ID.getAccessor(is.getType());
                IMemberAccessor gcWhenAccessor = JdkAttributes.GC_WHEN.getAccessor(is.getType());
                IMemberAccessor usedMetaspaceAccessor = JdkAttributes.GC_METASPACE_USED.getAccessor(is.getType());
                IMemberAccessor committedMetaspaceAccessor = JdkAttributes.GC_METASPACE_COMMITTED.getAccessor(is.getType());
                is.forEach(item -> {
                    GC gc = (GC)gcMap.get(gcIdAccessor.getMember(item));
                    if (gc != null && usedMetaspaceAccessor != null && committedMetaspaceAccessor != null && gcWhenAccessor != null) {
                        String when = (String)gcWhenAccessor.getMember(item);
                        if ("Before GC".equals(when)) {
                            gc.usedMetaspaceDelta = gc.usedMetaspaceDelta.subtract((IQuantity)usedMetaspaceAccessor.getMember(item));
                            gc.committedMetaspaceDelta = gc.committedMetaspaceDelta.subtract((IQuantity)committedMetaspaceAccessor.getMember(item));
                        } else {
                            gc.usedMetaspaceDelta = gc.usedMetaspaceDelta.add((IQuantity)usedMetaspaceAccessor.getMember(item));
                            gc.committedMetaspaceDelta = gc.committedMetaspaceDelta.add((IQuantity)committedMetaspaceAccessor.getMember(item));
                        }
                    }
                });
            });
            this.gcList.getViewer().setInput((Object)gcMap.values().toArray());
        }

        private void onShow(Boolean show) {
            IRange<IQuantity> range = show != false ? this.currentRange : this.pageContainer.getFullRange();
            this.gcChart.setVisibleRange((IQuantity)range.getStart(), (IQuantity)range.getEnd());
            this.buildChart();
        }

        private void updateChart() {
            DataPageToolkit.setChart(this.chartCanvas, this.gcChart, this.pageContainer::showSelection);
            SelectionStoreActionToolkit.addSelectionStoreRangeActions(this.pageContainer.getSelectionStore(), this.gcChart, (IAttribute<IRange<IQuantity>>)JfrAttributes.LIFETIME, Messages.GarbageCollectionsPage_TIMELINE_SELECTION, (IContributionManager)this.chartCanvas.getContextMenu());
            this.buildChart();
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.currentRange = timeRange;
            this.selectionItems = items;
            IItemCollection gcs = items != null ? items : GarbageCollectionsPage.this.getDataSource().getItems();
            this.updateTable(gcs.apply(JdkFilters.GARBAGE_COLLECTION));
            this.updateChart();
        }

        private Stream<? extends IItem> gcSelectedGcItems() {
            List sel = ((IStructuredSelection)this.gcList.getViewer().getSelection()).toList();
            return sel.stream().map(gc -> gc.gcItem);
        }
    }
}

