/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.jdk.general.PasswordsInArgumentsRule;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IDataPageFactory;
import com.oracle.jmc.flightrecorder.ui.IDisplayablePage;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.IPageDefinition;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.pages.DistinctItemsPage;
import org.eclipse.jface.resource.ImageDescriptor;

public class EnvironmentVariablesPage
extends DistinctItemsPage {
    public EnvironmentVariablesPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.setTableDefinition(JdkQueries.ENVIRONMENT_VARIABLE);
        this.setLabelProvider(DataPageToolkit.createTableHighlightProvider(PasswordsInArgumentsRule.PASSWORD_PATTERN, true));
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return JdkFilters.ENVIRONMENT_VARIABLE;
    }

    public static class EnvironmentVariablesPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.EnvironmentVariablesPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/environment.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"environment_variables"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new EnvironmentVariablesPage(dpd, items, editor);
        }
    }
}

