/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IItemQuery;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.IPageDefinition;
import com.oracle.jmc.flightrecorder.ui.IPageUI;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.common.AbstractDataPage;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import com.oracle.jmc.flightrecorder.ui.common.FilterComponent;
import com.oracle.jmc.flightrecorder.ui.common.ItemHistogram;
import com.oracle.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.ColumnMenusFactory;
import com.oracle.jmc.ui.column.TableSettings;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

class DistinctItemsPage
extends AbstractDataPage {
    private static final String TABLE = "table";
    private static final String FILTER = "filter";
    private IItemQuery query;
    private IBaseLabelProvider labelProvider;
    private IItemFilter tableFilter;
    private ColumnManager.SelectionState tableSelection;

    public DistinctItemsPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    void setLabelProvider(IBaseLabelProvider provider) {
        this.labelProvider = provider;
    }

    void setTableDefinition(IItemQuery query) {
        this.query = query;
    }

    @Override
    public IPageUI display(Composite container, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new DistinctItemsUi(container, toolkit, pageContainer, state, this.getName(), this.getIcon(), this.query, this.getDataSource(), this.labelProvider, this.getDescription());
    }

    private class DistinctItemsUi
    implements IPageUI {
        private final ItemHistogram table;
        private final FilterComponent filter;
        private final StreamModel items;
        private final IItemQuery query;

        DistinctItemsUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state, String name, Image icon, IItemQuery query, StreamModel items, IBaseLabelProvider labelProvider, String description) {
            Form form = DataPageToolkit.createForm(parent, toolkit, name, icon);
            this.items = items;
            this.query = query;
            this.table = DataPageToolkit.createDistinctItemsTable(form.getBody(), items.getItems(), query, new TableSettings(state.getChild(DistinctItemsPage.TABLE)));
            this.filter = FilterComponent.createFilterComponent(this.table, DistinctItemsPage.this.tableFilter, items.getItems().apply(query.getFilter()), pageContainer.getSelectionStore()::getSelections, this::onFilterChange);
            MCContextMenuManager mm = MCContextMenuManager.create((Control)this.table.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.table.getManager(), (MCContextMenuManager)mm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.table, name, (IContributionManager)mm);
            mm.add(this.filter.getShowFilterAction());
            mm.add(this.filter.getShowSearchAction());
            this.table.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(this.table.getSelection().getItems()));
            this.table.show(items.getItems().apply(query.getFilter()));
            this.filter.loadState(state.getChild(DistinctItemsPage.FILTER));
            DistinctItemsPage.this.addResultActions(form);
            if (labelProvider != null) {
                this.table.getManager().getViewer().setLabelProvider(labelProvider);
            }
            this.onFilterChange(DistinctItemsPage.this.tableFilter);
            this.table.getManager().setSelectionState(DistinctItemsPage.this.tableSelection);
        }

        private void onFilterChange(IItemFilter newFilter) {
            this.filter.filterChangeHelper(newFilter, this.table, this.items.getItems().apply(this.query.getFilter()));
            DistinctItemsPage.this.tableFilter = newFilter;
        }

        public void saveTo(IWritableState state) {
            this.table.getManager().getSettings().saveState(state.createChild(DistinctItemsPage.TABLE));
            this.filter.saveState(state.createChild(DistinctItemsPage.FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            DistinctItemsPage.this.tableSelection = this.table.getManager().getSelectionState();
        }
    }
}

