/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.pages;

import com.oracle.jmc.common.IDescribable;
import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.version.JavaVersionSupport;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkFilters;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IDataPageFactory;
import com.oracle.jmc.flightrecorder.ui.IDisplayablePage;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.IPageDefinition;
import com.oracle.jmc.flightrecorder.ui.IPageUI;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.common.AbstractDataPage;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import com.oracle.jmc.flightrecorder.ui.common.FilterComponent;
import com.oracle.jmc.flightrecorder.ui.common.FlavorSelector;
import com.oracle.jmc.flightrecorder.ui.common.ItemList;
import com.oracle.jmc.flightrecorder.ui.common.ItemRow;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import com.oracle.jmc.ui.charts.AWTChartToolkit;
import com.oracle.jmc.ui.charts.ISpanSeries;
import com.oracle.jmc.ui.charts.IXDataRenderer;
import com.oracle.jmc.ui.charts.QuantitySeries;
import com.oracle.jmc.ui.charts.RendererToolkit;
import com.oracle.jmc.ui.charts.SpanRenderer;
import com.oracle.jmc.ui.charts.XYChart;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.ColumnMenusFactory;
import com.oracle.jmc.ui.column.TableSettings;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import com.oracle.jmc.ui.misc.ChartCanvas;
import com.oracle.jmc.ui.misc.PersistableSashForm;
import com.oracle.jmc.ui.misc.SWTColorToolkit;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CodeCachePage
extends AbstractDataPage {
    private static ColumnLabelProvider LEGEND_LP = new ColumnLabelProvider(){

        public String getText(Object element) {
            return this.getText(element, IDescribable::getName);
        }

        public String getToolTipText(Object element) {
            return this.getText(element, IDescribable::getDescription);
        }

        private String getText(Object element, Function<IDescribable, String> accessor) {
            for (IAttribute a : JdkQueries.CODE_CACHE_ENTRIES.getAttributes()) {
                if (!a.getIdentifier().equals(element)) continue;
                return accessor.apply((IDescribable)a);
            }
            for (IAttribute a : JdkQueries.CODE_CACHE_UNALLOCATED.getAttributes()) {
                if (!a.getIdentifier().equals(element)) continue;
                return accessor.apply((IDescribable)a);
            }
            for (IAttribute a : JdkQueries.CODE_CACHE_UNALLOCATED_SEGMENTED.getAttributes()) {
                if (!a.getIdentifier().equals(element)) continue;
                return accessor.apply((IDescribable)a);
            }
            for (IAttribute a : JdkQueries.CODE_CACHE_ENTRIES_SEGMENTED.getAttributes()) {
                if (!a.getIdentifier().equals(element)) continue;
                return accessor.apply((IDescribable)a);
            }
            for (IAttribute a : JdkQueries.CODE_CACHE_ADAPTORS_SEGMENTED.getAttributes()) {
                if (!a.getIdentifier().equals(element)) continue;
                return accessor.apply((IDescribable)a);
            }
            for (IAttribute a : JdkQueries.CODE_CACHE_METHODS_SEGMENTED.getAttributes()) {
                if (!a.getIdentifier().equals(element)) continue;
                return accessor.apply((IDescribable)a);
            }
            switch ((String)element) {
                case "totalMethodsSwept": {
                    return accessor.apply((IDescribable)JdkAggregators.SWEEP_METHOD_SUM);
                }
                case "totalMethodsFlushed": {
                    return accessor.apply((IDescribable)JdkAggregators.SWEEP_FLUSHED_SUM);
                }
                case "totalMethodsReclaimed": {
                    return accessor.apply((IDescribable)JdkAggregators.SWEEP_RECLAIMED_SUM);
                }
                case "totalMethodsZombified": {
                    return accessor.apply((IDescribable)JdkAggregators.SWEEP_ZOMBIFIED_SUM);
                }
                case "codeCacheSweeps": {
                    return accessor.apply(SWEEPS_DESCRIPTION);
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element.equals(CodeCachePage.SWEEPS_ID)) {
                return SWTColorToolkit.getColorThumbnail((RGB)SWTColorToolkit.asRGB((Color)SWEEP_BACKDROP_COLOR));
            }
            return SWTColorToolkit.getColorThumbnail((RGB)SWTColorToolkit.asRGB((Color)DataPageToolkit.getFieldColor((String)element)));
        }
    };
    private static final ItemList.ItemListBuilder CODE_SWEEP_LIST = new ItemList.ItemListBuilder();
    private static final Color SWEEP_BACKDROP_COLOR;
    private static final String SASH = "sash";
    private static final String CODE_SWEEP_TABLE = "codeSweepTable";
    private static final String CODE_SWEEP_FILTER = "codeSweepFilter";
    private static final String CHART = "chart";
    private static final String SERIES = "series";
    private static final String ID_ATTRIBUTE = "id";
    private static final String TOTAL_SWEPT_ID = "totalMethodsSwept";
    private static final String TOTAL_FLUSHED_ID = "totalMethodsFlushed";
    private static final String TOTAL_RECLAIMED_ID = "totalMethodsReclaimed";
    private static final String TOTAL_ZOMBIFIED_ID = "totalMethodsZombified";
    private static final String SWEEPS_ID = "codeCacheSweeps";
    private static final IDescribable SWEEPS_DESCRIPTION;
    private IItemFilter codeSweepFilterState;
    private ColumnManager.SelectionState codeSweepSelectionState;
    private IRange<IQuantity> timelineRange;
    private FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        CODE_SWEEP_LIST.addColumn(JfrAttributes.START_TIME);
        CODE_SWEEP_LIST.addColumn(JfrAttributes.DURATION);
        CODE_SWEEP_LIST.addColumn(JdkAttributes.SWEEP_INDEX);
        CODE_SWEEP_LIST.addColumn(JdkAttributes.SWEEP_FRACTION_INDEX);
        CODE_SWEEP_LIST.addColumn(JdkAttributes.SWEEP_METHOD_FLUSHED);
        CODE_SWEEP_LIST.addColumn(JdkAttributes.SWEEP_METHOD_RECLAIMED);
        CODE_SWEEP_LIST.addColumn(JdkAttributes.SWEEP_METHOD_SWEPT);
        CODE_SWEEP_LIST.addColumn(JdkAttributes.SWEEP_METHOD_ZOMBIFIED);
        CODE_SWEEP_LIST.addColumn(JfrAttributes.EVENT_THREAD);
        SWEEP_BACKDROP_COLOR = new Color(0, 100, 200, 80);
        SWEEPS_DESCRIPTION = new IDescribable(){

            public String getName() {
                return Messages.CodeCachePage_OVERLAY_SWEEPS;
            }

            public String getDescription() {
                return Messages.CodeCachePage_OVERLAYS_SWEEPS_DESC;
            }
        };
    }

    public CodeCachePage(IPageDefinition defintion, StreamModel items, IPageContainer editor) {
        super(defintion, items, editor);
        this.timelineRange = editor.getFullRange();
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ItemFilters.type((String[])new String[]{"com.oracle.jdk.CodeCacheStatistics", "com.oracle.jdk.SweepCodeCache"});
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
        return new CodeCachePageUI(parent, toolkit, editor, state);
    }

    public static class CodeCachePageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.CodeCachePage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/compilations.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"code_cache"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition definition, StreamModel items, IPageContainer editor) {
            return new CodeCachePage(definition, items, editor);
        }
    }

    private class CodeCachePageUI
    implements IPageUI {
        private final SashForm sash;
        private final IPageContainer pageContainer;
        private final CheckboxTableViewer chartLegend;
        private final ChartCanvas chartCanvas;
        private final ItemList codeSweepTable;
        private final FilterComponent codeSweepFilter;
        private IItemCollection selectionItems;
        private XYChart chart;
        private IRange<IQuantity> currentRange;
        private FlavorSelector flavorSelector;

        CodeCachePageUI(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.pageContainer = pageContainer;
            Form form = DataPageToolkit.createForm(parent, toolkit, CodeCachePage.this.getName(), CodeCachePage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            toolkit.adapt((Composite)this.sash);
            Composite chartContainer = toolkit.createComposite((Composite)this.sash);
            chartContainer.setLayout((Layout)new GridLayout(2, false));
            this.chartCanvas = new ChartCanvas(chartContainer);
            this.chart = new XYChart(pageContainer.getFullRange(), RendererToolkit.empty(), 180);
            this.chart.setVisibleRange((IQuantity)CodeCachePage.this.timelineRange.getStart(), (IQuantity)CodeCachePage.this.timelineRange.getEnd());
            this.chart.addVisibleRangeListener(r -> {
                IRange<IQuantity> iRange = r;
                IRange<IQuantity> iRange2 = iRange;
                CodeCachePage.this.timelineRange = iRange;
            });
            this.chartCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
            DataPageToolkit.setChart(this.chartCanvas, this.chart, pageContainer::showSelection);
            SelectionStoreActionToolkit.addSelectionStoreRangeActions(pageContainer.getSelectionStore(), this.chart, (IAttribute<IRange<IQuantity>>)JfrAttributes.LIFETIME, Messages.CodeCachePage_SWEEPS_TIMELINE_SELECTION, (IContributionManager)this.chartCanvas.getContextMenu());
            this.chartLegend = CheckboxTableViewer.newCheckList((Composite)chartContainer, (int)2048);
            GridData gd = new GridData(4, 4, false, true);
            gd.widthHint = 180;
            this.chartLegend.getTable().setLayoutData((Object)gd);
            this.chartLegend.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.chartLegend.setLabelProvider((IBaseLabelProvider)LEGEND_LP);
            this.chartLegend.addCheckStateListener(e -> this.buildChart());
            this.chartLegend.addSelectionChangedListener(e -> this.buildChart());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.chartLegend);
            ArrayList<String> chartSeries = new ArrayList<String>();
            if (RulesToolkit.getJavaVersion((IItemCollection)CodeCachePage.this.getDataSource().getItems()).isGreaterOrEqualThan(JavaVersionSupport.JDK_9)) {
                JdkQueries.CODE_CACHE_UNALLOCATED_SEGMENTED.getAttributes().stream().map(ICanonicalAccessorFactory::getIdentifier).forEach(chartSeries::add);
                JdkQueries.CODE_CACHE_ENTRIES_SEGMENTED.getAttributes().stream().map(ICanonicalAccessorFactory::getIdentifier).forEach(chartSeries::add);
                JdkQueries.CODE_CACHE_ADAPTORS_SEGMENTED.getAttributes().stream().map(ICanonicalAccessorFactory::getIdentifier).forEach(chartSeries::add);
                JdkQueries.CODE_CACHE_METHODS_SEGMENTED.getAttributes().stream().map(ICanonicalAccessorFactory::getIdentifier).forEach(chartSeries::add);
            } else {
                JdkQueries.CODE_CACHE_ENTRIES.getAttributes().stream().map(ICanonicalAccessorFactory::getIdentifier).forEach(chartSeries::add);
                JdkQueries.CODE_CACHE_UNALLOCATED.getAttributes().stream().map(ICanonicalAccessorFactory::getIdentifier).forEach(chartSeries::add);
            }
            chartSeries.addAll(Arrays.asList(CodeCachePage.TOTAL_SWEPT_ID, CodeCachePage.TOTAL_FLUSHED_ID, CodeCachePage.TOTAL_RECLAIMED_ID, CodeCachePage.TOTAL_ZOMBIFIED_ID, CodeCachePage.SWEEPS_ID));
            this.chartLegend.setInput((Object)chartSeries.toArray());
            IState chartState = state.getChild(CodeCachePage.CHART);
            if (chartState != null) {
                IState[] iStateArray = chartState.getChildren();
                int n = iStateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IState c = iStateArray[n2];
                    this.chartLegend.setChecked((Object)c.getAttribute(CodeCachePage.ID_ATTRIBUTE), true);
                    ++n2;
                }
            }
            this.codeSweepTable = CODE_SWEEP_LIST.buildWithoutBorder((Composite)this.sash, TableSettings.forState((IState)state.getChild(CodeCachePage.CODE_SWEEP_TABLE)));
            this.codeSweepTable.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.codeSweepTable.getSelection().get())));
            this.codeSweepFilter = FilterComponent.createFilterComponent(this.codeSweepTable, CodeCachePage.this.codeSweepFilterState, CodeCachePage.this.getDataSource().getItems().apply(JdkFilters.SWEEP_CODE_CACHE), pageContainer.getSelectionStore()::getSelections, this::onFilterChange);
            MCContextMenuManager mm = MCContextMenuManager.create((Control)this.codeSweepTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.codeSweepTable.getManager(), (MCContextMenuManager)mm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.codeSweepTable, Messages.CodeCachePage_SWEEP_TABLE_SELECTION, (IContributionManager)mm);
            mm.add(this.codeSweepFilter.getShowFilterAction());
            mm.add(this.codeSweepFilter.getShowSearchAction());
            this.codeSweepFilter.loadState(state.getChild(CodeCachePage.CODE_SWEEP_FILTER));
            DataPageToolkit.createChartTimestampTooltip(this.chartCanvas);
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(CodeCachePage.SASH));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, JdkFilters.CODE_CACHE, CodeCachePage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, this::onShow, CodeCachePage.this.flavorSelectorState);
            CodeCachePage.this.addResultActions(form);
            this.onFilterChange(CodeCachePage.this.codeSweepFilterState);
            this.codeSweepTable.getManager().setSelectionState(CodeCachePage.this.codeSweepSelectionState);
        }

        private Optional<ItemRow> buildBarChart(IItemCollection items, IAggregator<IQuantity, ?> aggregator, String id) {
            if (this.chartLegend.getChecked((Object)id)) {
                return Optional.of(DataPageToolkit.buildTimestampHistogram(aggregator.getName(), aggregator.getDescription(), items, aggregator, DataPageToolkit.getFieldColor(id)));
            }
            return Optional.empty();
        }

        private void buildChart() {
            IItemCollection itemsInRange = this.getItems();
            ArrayList rows = new ArrayList();
            Predicate<IAttribute<IQuantity>> legendFilter = a -> this.chartLegend.getChecked((Object)a.getIdentifier());
            DataPageToolkit.buildLinesRow(Messages.CodeCachePage_ROW_UNALLOCATED, null, itemsInRange, false, JdkQueries.CODE_CACHE_UNALLOCATED, legendFilter, (IQuantity)UnitLookup.BYTES.quantity(0L), null).ifPresent(rows::add);
            DataPageToolkit.buildLinesRow(Messages.CodeCachePage_ROW_UNALLOCATED, null, itemsInRange, false, JdkQueries.CODE_CACHE_UNALLOCATED_SEGMENTED, legendFilter, (IQuantity)UnitLookup.BYTES.quantity(0L), null).ifPresent(rows::add);
            DataPageToolkit.buildLinesRow(Messages.CodeCachePage_ROW_ENTRIES, null, itemsInRange, false, JdkQueries.CODE_CACHE_ENTRIES, legendFilter, (IQuantity)UnitLookup.NUMBER_UNITY.quantity(0L), null).ifPresent(rows::add);
            DataPageToolkit.buildLinesRow(Messages.CodeCachePage_ROW_ENTRIES, null, itemsInRange, false, JdkQueries.CODE_CACHE_ENTRIES_SEGMENTED, legendFilter, (IQuantity)UnitLookup.NUMBER_UNITY.quantity(0L), null).ifPresent(rows::add);
            DataPageToolkit.buildLinesRow(Messages.CodeCachePage_ROW_ADAPTORS, null, itemsInRange, false, JdkQueries.CODE_CACHE_ADAPTORS_SEGMENTED, legendFilter, (IQuantity)UnitLookup.NUMBER_UNITY.quantity(0L), null).ifPresent(rows::add);
            DataPageToolkit.buildLinesRow(Messages.CodeCachePage_ROW_METHODS, null, itemsInRange, false, JdkQueries.CODE_CACHE_METHODS_SEGMENTED, legendFilter, (IQuantity)UnitLookup.NUMBER_UNITY.quantity(0L), null).ifPresent(rows::add);
            IItemCollection sweepEvents = itemsInRange.apply(JdkFilters.SWEEP_CODE_CACHE);
            this.buildBarChart(sweepEvents, JdkAggregators.SWEEP_METHOD_SUM, CodeCachePage.TOTAL_SWEPT_ID).ifPresent(rows::add);
            this.buildBarChart(sweepEvents, JdkAggregators.SWEEP_FLUSHED_SUM, CodeCachePage.TOTAL_FLUSHED_ID).ifPresent(rows::add);
            this.buildBarChart(sweepEvents, JdkAggregators.SWEEP_RECLAIMED_SUM, CodeCachePage.TOTAL_RECLAIMED_ID).ifPresent(rows::add);
            this.buildBarChart(sweepEvents, JdkAggregators.SWEEP_ZOMBIFIED_SUM, CodeCachePage.TOTAL_ZOMBIFIED_ID).ifPresent(rows::add);
            IXDataRenderer root = RendererToolkit.uniformRows(rows);
            if (this.chartLegend.getChecked((Object)CodeCachePage.SWEEPS_ID)) {
                ISpanSeries sweepBackdrop = QuantitySeries.max((IItemCollection)sweepEvents, (IAttribute)JfrAttributes.START_TIME, (IAttribute)JfrAttributes.END_TIME);
                root = RendererToolkit.layers((IXDataRenderer[])new IXDataRenderer[]{root, new ItemRow(null, null, SpanRenderer.build((ISpanSeries)sweepBackdrop, (AWTChartToolkit.IColorProvider)AWTChartToolkit.staticColor((Color)SWEEP_BACKDROP_COLOR)), sweepEvents)});
            }
            this.chartCanvas.replaceRenderer(root);
        }

        private void onShow(Boolean show) {
            IRange<IQuantity> range = show != false ? this.currentRange : this.pageContainer.getFullRange();
            this.chart.setVisibleRange((IQuantity)range.getStart(), (IQuantity)range.getEnd());
            this.buildChart();
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.currentRange = timeRange;
            this.selectionItems = items;
            this.codeSweepTable.show(this.getItems().apply(JdkFilters.SWEEP_CODE_CACHE));
            this.buildChart();
        }

        private IItemCollection getItems() {
            return this.selectionItems != null ? this.selectionItems.apply(JdkFilters.CODE_CACHE) : CodeCachePage.this.getDataSource().getItems().apply(JdkFilters.CODE_CACHE);
        }

        private void onFilterChange(IItemFilter filter) {
            this.codeSweepFilter.filterChangeHelper(filter, this.codeSweepTable, CodeCachePage.this.getDataSource().getItems().apply(JdkFilters.SWEEP_CODE_CACHE));
            CodeCachePage.this.codeSweepFilterState = filter;
        }

        public void saveTo(IWritableState state) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)state.createChild(CodeCachePage.SASH));
            IWritableState chartState = state.createChild(CodeCachePage.CHART);
            this.codeSweepTable.getManager().getSettings().saveState(state.createChild(CodeCachePage.CODE_SWEEP_TABLE));
            this.codeSweepFilter.saveState(state.createChild(CodeCachePage.CODE_SWEEP_FILTER));
            Object[] objectArray = this.chartLegend.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                chartState.createChild(CodeCachePage.SERIES).putString(CodeCachePage.ID_ATTRIBUTE, (String)o);
                ++n2;
            }
            this.saveToLocal();
        }

        private void saveToLocal() {
            CodeCachePage.this.codeSweepSelectionState = this.codeSweepTable.getManager().getSelectionState();
            CodeCachePage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }
    }
}

