/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.overview;

import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.ui.DataPageDescriptor;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.owasp.encoder.Encode;

public class RulesHtmlToolkit {
    public static final double IN_PROGRESS = -200.0;
    private static final String RULE_TEMPLATE = RulesHtmlToolkit.readFromFile("rule_result.html");
    private static final String TEMPLATE = RulesHtmlToolkit.readFromFile("rules_overview.html");
    public static final String START_DIV = "<div class=\"wrapper\" id=\"notAllOk\">";
    public static final String END_DIV = "</div>";
    public static final String CLOSE_HTML = "</body></html>";
    public static final String PUSH_DIV = "<div class=\"push\"></div>";
    private static final String HEADING_PATTERN = "<div id=\"{0}_group\"><div id=\"{0}_heading\" style=\"margin-left: {4}px;\" class=\"{2}\"><div onclick=\"overview.link(''{0}'');\"><img class=\"{2}_icon\" alt=\"{1}\" src=\"data:image/png;base64,{3}\"/>{1}</div></div>";

    static String getType(double value) {
        if (value >= 75.0) {
            return "warning";
        }
        if (value >= 25.0) {
            return "info";
        }
        if (value >= 0.0) {
            return "ok";
        }
        if (value == -1.0) {
            return "na";
        }
        if (value == -3.0) {
            return "ignore";
        }
        if (value == -200.0) {
            return "progress";
        }
        if (value == -2.0) {
            return "error";
        }
        return "error";
    }

    private static String readFromFile(String path) {
        String result = "";
        URL url = RulesHtmlToolkit.class.getResource(path);
        try {
            List loadFromFile = IOToolkit.loadFromFile((File)new File(FileLocator.toFileURL((URL)url).getPath()));
            StringBuilder sb = new StringBuilder();
            for (String s : loadFromFile) {
                sb.append(String.valueOf(s) + System.getProperty("line.separator"));
            }
            result = sb.toString();
        }
        catch (IOException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Couldn't read HTML template file.", e);
        }
        return result;
    }

    static String createShowOK() {
        String ok = "<div class=\"footer\"><label class=\"showOkText\" for=\"showOk\">";
        ok = String.valueOf(ok) + Messages.RULESPAGE_SHOW_OK_RESULTS_ACTION;
        ok = String.valueOf(ok) + "</label>&nbsp;<input type=\"checkbox\" onclick='overview.showOk(this.checked);' id=\"showOk\"></div>";
        ok = String.valueOf(ok) + "<script>window.onload = function() {overview.showOk(false)}</script>";
        return ok;
    }

    public static String getHtmlTemplate() {
        return TEMPLATE;
    }

    public static String getAllOkTemplate() {
        return NLS.bind((String)"<div id=\"allgreen\" style=\"display: none;\"><p class=\"allOk\">{0}</p><p style=\"font-family: sans-serif\">{1}</p></div>", (Object)Messages.RULES_NO_PROBLEMS_FOUND, (Object)Messages.RULES_NO_PROBLEMS_FOUND_DETAILS);
    }

    public static String getAllIgnoredTemplate() {
        return NLS.bind((String)"<div id=\"allignored\" style=\"display: none;\"><p class=\"allIgnored\">{0}</p></div>", (Object)Messages.RULES_ALL_IGNORED_MESSAGE);
    }

    public static String createRuleHtml(Result result, boolean expanded, int margin) throws IOException {
        String description = String.valueOf(result.getShortDescription()) + (result.getLongDescription() != null ? result.getLongDescription() : "");
        return RulesHtmlToolkit.createRuleHtml(result.getRule().getId(), result.getScore(), result.getRule().getName(), description, expanded, margin, result.getRule().getTopic().hashCode());
    }

    public static String createRuleHtml(String id, double value, String title, String description, Boolean expanded, int margin, int uuid) {
        String button;
        String clazz;
        value = Math.round(value);
        StringBuilder sb = new StringBuilder(RULE_TEMPLATE);
        if (expanded.booleanValue()) {
            clazz = "visible";
            button = "-";
        } else {
            clazz = "hidden";
            button = "+";
        }
        String displayScore = Double.compare(-200.0, value) == 0 ? "none" : "inline block";
        String displayProgress = Double.compare(-200.0, value) == 0 ? "inline block" : "none";
        return MessageFormat.format(sb.toString(), Encode.forHtml((String)(String.valueOf(id) + uuid)), value == -1.0 ? "N/A" : Double.valueOf(value), Encode.forHtml((String)title), description, RulesHtmlToolkit.getType(value), margin, clazz, button, displayScore, displayProgress, id);
    }

    static String createSubHeading(String id, String name, String type, String image, String lowestResult, int margin) {
        return MessageFormat.format(HEADING_PATTERN, Encode.forHtml((String)id), Encode.forHtml((String)name), Encode.forHtml((String)type), image, margin);
    }

    public static String createSubHeading(DataPageDescriptor page, String type, String lowestResult, int margin) {
        return RulesHtmlToolkit.createSubHeading(Integer.toString(page.hashCode()), page.getName(), type, RulesHtmlToolkit.encodeImage(page.getImageDescriptor()), lowestResult, margin);
    }

    private static String encodeImage(ImageDescriptor image) {
        if (image == null) {
            return "";
        }
        ImageLoader loader = new ImageLoader();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save((OutputStream)out, 5);
        return Base64.getEncoder().encodeToString(out.toByteArray());
    }
}

