/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.overview;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.Severity;
import com.oracle.jmc.flightrecorder.ui.DataPageDescriptor;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.RulesUiToolkit;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.overview.RulesHtmlToolkit;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ResultReportUi {
    private static final String OVERVIEW_MAKE_SCALABLE = "overview.makeScalable();";
    private static final String OVERVIEW_UPDATE_PAGE_HEADERS_VISIBILITY = "overview.updatePageHeadersVisibility();";
    private List<String> overviewHtml = new ArrayList<String>();
    private final HashMap<String, Boolean> resultExpandedStates = new HashMap();
    private Boolean showOk = false;
    private Boolean isLoaded = false;
    private Browser browser;
    private IPageContainer editor;
    private Iterable<DataPageDescriptor> descriptors;
    private boolean isSinglePage = false;
    private ConcurrentLinkedQueue<IRule> resultEventQueue = new ConcurrentLinkedQueue();
    private Collection<String> topics = RulesUiToolkit.getTopics();
    private Collection<Result> results;

    public ResultReportUi(boolean isSinglePage) {
        this.isSinglePage = isSinglePage;
    }

    public List<String> getHtml(IPageContainer editor) {
        this.overviewHtml.clear();
        this.overviewHtml.add(this.addFooter(this.generateStructuredHtml(editor, this.descriptors)));
        return this.overviewHtml;
    }

    private List<Result> sortResults(Collection<Result> results) {
        ArrayList<Result> sorted = new ArrayList<Result>();
        results.forEach(r -> {
            boolean bl = sorted.add((Result)r);
        });
        Collections.sort(sorted, (r1, r2) -> r1.getRule().getId().compareTo(r2.getRule().getId()));
        return sorted;
    }

    private String lowestCommonDenominator(List<Result> results) {
        OptionalDouble max = results.stream().mapToDouble(Result::getScore).max();
        if (max.isPresent()) {
            return RulesHtmlToolkit.getType(max.getAsDouble());
        }
        return "";
    }

    private String addFooter(String template) {
        template = String.valueOf(template) + "<div class=\"push\"></div>";
        template = String.valueOf(template) + "</div>";
        template = String.valueOf(template) + RulesHtmlToolkit.createShowOK();
        template = String.valueOf(template) + "</body></html>";
        return template;
    }

    public void setShowOk(boolean showOk) {
        this.showOk = showOk;
        if (!this.isSinglePage) {
            try {
                this.browser.evaluate(String.format("overview.showOk(%b);", showOk));
                boolean allOk = this.editor.getRuleManager().getScoreStream(this.topics.toArray(new String[this.topics.size()])).allMatch(d -> d > -200.0 && d < Severity.INFO.getLimit()) && !showOk;
                this.browser.evaluate(String.format("overview.allOk(%b);", allOk));
            }
            catch (SWTException swte) {
                this.browser.setText(this.generateStructuredHtml(this.editor, this.descriptors));
            }
        }
    }

    boolean getShowOk() {
        return this.showOk;
    }

    public void updateRule(IRule rule) {
        if (this.resultEventQueue.isEmpty()) {
            this.resultEventQueue.add(rule);
            DisplayToolkit.safeAsyncExec(() -> {
                if (this.browser.isDisposed()) {
                    return;
                }
                StringBuilder script = new StringBuilder();
                while (!this.resultEventQueue.isEmpty()) {
                    IRule next = this.resultEventQueue.poll();
                    Result result = this.editor.getRuleManager().getResult(next);
                    if (result == null) continue;
                    long score = Math.round(result.getScore());
                    String quoteEscape = this.getDescription(result).replaceAll("\\\"", "\\\\\"");
                    String description = quoteEscape.replaceAll("\n", "</br>");
                    script.append(String.format("overview.updateResult(\"%s\", %d, \"%s\");", result.getRule().getId(), score, description));
                }
                String[] topicsArray = this.topics.toArray(new String[this.topics.size()]);
                if (!this.isSinglePage) {
                    boolean allOk = this.editor.getRuleManager().getScoreStream(topicsArray).allMatch(d -> d > -200.0 && d < Severity.INFO.getLimit()) && this.showOk == false;
                    script.append(String.format("overview.allOk(%b);", allOk));
                }
                boolean allIgnored = this.editor.getRuleManager().getScoreStream(topicsArray).allMatch(d -> d == -3.0);
                script.append(String.format("overview.allIgnored(%b);", allIgnored));
                try {
                    if (this.isLoaded.booleanValue()) {
                        this.browser.evaluate(script.toString());
                        this.browser.evaluate(OVERVIEW_UPDATE_PAGE_HEADERS_VISIBILITY);
                    } else {
                        final String finalScript = script.toString();
                        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

                            public void completed(ProgressEvent event) {
                                ResultReportUi.this.browser.evaluate(finalScript);
                                ResultReportUi.this.isLoaded = true;
                                ResultReportUi.this.browser.evaluate(ResultReportUi.OVERVIEW_UPDATE_PAGE_HEADERS_VISIBILITY);
                                ResultReportUi.this.browser.removeProgressListener((ProgressListener)this);
                            }
                        });
                    }
                }
                catch (IllegalArgumentException | SWTException e) {
                    try {
                        FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Could not update single result, redrawing html view. " + e.getMessage());
                        this.browser.setText(this.isSinglePage ? this.generateSinglePageHtml() : this.generateStructuredHtml(this.editor, this.descriptors));
                    }
                    catch (Exception e1) {
                        FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not update Result Overview", e1);
                    }
                }
            });
        } else {
            this.resultEventQueue.add(rule);
        }
    }

    public void setTopics(Collection<String> topics) {
        this.topics = topics;
    }

    public void setResults(Collection<Result> results) {
        this.results = results;
    }

    public boolean createHtmlOverview(final Browser browser, final IPageContainer editor, IState state) {
        this.browser = browser;
        this.editor = editor;
        this.descriptors = FlightRecorderUI.getDefault().getPageManager().getRootPages();
        try {
            this.showOk = Boolean.valueOf(state.getChild("report").getChild("showOk").getAttribute("value"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        browser.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        try {
            String html = this.isSinglePage ? this.generateSinglePageHtml() : this.generateStructuredHtml(editor, this.descriptors);
            browser.setText(html, true);
            browser.setJavascriptEnabled(true);
            browser.addProgressListener((ProgressListener)new ProgressAdapter(){

                public void completed(ProgressEvent event) {
                    new Linker(browser, "linker", ResultReportUi.this.descriptors, editor);
                    new Expander(browser, "expander");
                    browser.execute(String.format("overview.showOk(%b);", ResultReportUi.this.showOk));
                    if (ResultReportUi.this.isSinglePage) {
                        browser.execute(ResultReportUi.OVERVIEW_MAKE_SCALABLE);
                    }
                    browser.evaluate(ResultReportUi.OVERVIEW_UPDATE_PAGE_HEADERS_VISIBILITY);
                    ResultReportUi.this.isLoaded = true;
                }
            });
        }
        catch (IOException | IllegalArgumentException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not create Report Overview", e);
            return false;
        }
        return true;
    }

    private String generateSinglePageHtml() throws IOException {
        if (this.results == null) {
            return "";
        }
        StringBuilder html = new StringBuilder(RulesHtmlToolkit.getHtmlTemplate());
        html.append(RulesHtmlToolkit.getAllIgnoredTemplate());
        html.append("<div class=\"wrapper\" id=\"notAllOk\">");
        html.append("<section id=\"sec\">");
        ArrayList<Result> resultList = new ArrayList<Result>(this.results);
        Collections.sort(resultList, (r1, r2) -> (int)(r2.getScore() - r1.getScore()));
        if (this.results.size() == 0 || this.results.stream().filter(r -> r.getScore() != -3.0).count() == 0L) {
            html.append("<p style=\"font-size: 1.1em;\">");
            html.append(Messages.ResultOverview_NO_RESULTS_FOR_PAGE);
            html.append("</p>");
        } else {
            for (Result result : resultList) {
                boolean expand = Severity.get((double)result.getScore()).compareTo((Enum)Severity.INFO) >= 0;
                html.append(RulesHtmlToolkit.createRuleHtml(result, expand, 0));
            }
        }
        html.append("</section>");
        html.append("</div>");
        html.append("</body></html>");
        return html.toString();
    }

    private StringBuilder addTopics(StringBuilder div, IPageContainer editor, List<String> topics) {
        for (String topic : topics) {
            div.append("<section>");
            this.generateTitleAndResults(RulesHtmlToolkit.createSubHeading(topic, topic, "column_title", null, "", 0), topic.hashCode(), editor.getRuleManager().getResults(topic), div);
            div.append("</section>");
        }
        return div;
    }

    private String generateStructuredHtml(IPageContainer editor, Iterable<DataPageDescriptor> descriptors) {
        StringBuilder div = new StringBuilder(RulesHtmlToolkit.getHtmlTemplate());
        div.append(RulesHtmlToolkit.getAllOkTemplate());
        div.append(RulesHtmlToolkit.getAllIgnoredTemplate());
        div.append("<div class=\"wrapper\" id=\"notAllOk\">");
        HashSet<String> displayed = new HashSet<String>();
        for (DataPageDescriptor dpd : descriptors) {
            Collection<Result> headResults = editor.getRuleManager().getResults(dpd.getTopics());
            if (!dpd.hasChildren() && headResults.size() == 0) continue;
            div.append("<section>");
            this.generateTitleAndResults(RulesHtmlToolkit.createSubHeading(dpd, "column_title", "", 0), dpd.hashCode(), headResults, div);
            DataPageDescriptor[] dataPageDescriptorArray = dpd.getChildren();
            int n = dataPageDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataPageDescriptor child = dataPageDescriptorArray[n2];
                div.append(this.generateSubPageHTML(editor, child, 10, displayed));
                ++n2;
            }
            div.append("</div>");
            div.append("</section>");
            displayed.addAll(headResults.stream().map(r -> r.getRule().getTopic()).collect(Collectors.toList()));
        }
        String[] topics = this.topics.toArray(new String[this.topics.size()]);
        List<String> unusedTopics = editor.getRuleManager().getResults(topics).stream().filter(result -> !displayed.contains(result.getRule().getTopic())).map(r -> r.getRule().getTopic()).distinct().collect(Collectors.toList());
        div = this.addTopics(div, editor, unusedTopics);
        return div.toString();
    }

    private void generateTitleAndResults(String subHeading, int uuid, Collection<Result> results, StringBuilder div) {
        List<Result> headResults = this.sortResults(results);
        div.append(subHeading);
        if (headResults != null) {
            for (Result result : headResults) {
                div.append(RulesHtmlToolkit.createRuleHtml(result.getRule().getId(), result.getScore(), result.getRule().getName(), this.getDescription(result), this.isExpanded(result), 10, uuid));
            }
        }
    }

    private String getDescription(Result result) {
        String description = result.getShortDescription();
        description = String.valueOf(description) + (result.getLongDescription() != null ? "<br/>" + result.getLongDescription() : "");
        return description;
    }

    private Boolean isExpanded(Result result) {
        return this.resultExpandedStates.getOrDefault(result.getRule().getId(), false);
    }

    private String generateSubPageHTML(IPageContainer editor, DataPageDescriptor parent, int margin, Set<String> displayed) {
        StringBuilder html = new StringBuilder();
        DataPageDescriptor[] children = parent.getChildren();
        StringBuilder results = new StringBuilder();
        List<Result> sortResults = this.sortResults(editor.getRuleManager().getResults(parent.getTopics()));
        for (Result result : sortResults) {
            results.append(RulesHtmlToolkit.createRuleHtml(result.getRule().getId(), result.getScore(), result.getRule().getName(), this.getDescription(result), this.isExpanded(result), margin + 10, parent.hashCode()));
            displayed.add(result.getRule().getTopic());
        }
        DataPageDescriptor[] dataPageDescriptorArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            DataPageDescriptor child = dataPageDescriptorArray[n2];
            results.append(this.generateSubPageHTML(editor, child, margin <= 60 ? margin + 20 : margin, displayed));
            ++n2;
        }
        if (results.length() > 0) {
            html.append(RulesHtmlToolkit.createSubHeading(parent, "page_heading", this.lowestCommonDenominator(sortResults), margin));
            html.append((CharSequence)results);
            html.append("</div>");
        }
        return html.toString();
    }

    public void saveTo(IWritableState state) {
        state.createChild("report").createChild("showOk").putString("value", this.showOk.toString());
    }

    private class Expander
    extends BrowserFunction {
        public Expander(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            ResultReportUi.this.resultExpandedStates.put(arguments[0].toString(), (Boolean)arguments[1]);
            return null;
        }
    }

    private static class Linker
    extends BrowserFunction {
        private Iterable<DataPageDescriptor> descriptors;
        private IPageContainer editor;

        public Linker(Browser browser, String name, Iterable<DataPageDescriptor> descriptors, IPageContainer editor) {
            super(browser, name);
            this.descriptors = descriptors;
            this.editor = editor;
        }

        public Object function(Object[] arguments) {
            if (arguments.length != 1 && !(arguments[0] instanceof String)) {
                return null;
            }
            String name = arguments[0].toString();
            for (DataPageDescriptor dpd : this.descriptors) {
                String dpdIdentifier = Integer.toString(dpd.hashCode());
                if (dpdIdentifier.equals(name)) {
                    this.editor.navigateTo(dpd);
                    return null;
                }
                if (!this.hasPageAsChild(dpd, name)) continue;
                return null;
            }
            return null;
        }

        private boolean hasPageAsChild(DataPageDescriptor parent, String name) {
            if (Integer.toString(parent.hashCode()).equals(name)) {
                this.editor.navigateTo(parent);
                return true;
            }
            if (!parent.hasChildren()) {
                return false;
            }
            DataPageDescriptor[] dataPageDescriptorArray = parent.getChildren();
            int n = dataPageDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataPageDescriptor child = dataPageDescriptorArray[n2];
                if (this.hasPageAsChild(child, name)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

