/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.common;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.flightrecorder.ui.common.JComponentNavigator;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class QuantityRangeSelector
extends JComponentNavigator {
    private final Color RED = Color.getHSBColor(0.0f, 0.9f, 0.9f);
    private final Color ORANGE = Color.getHSBColor(0.1f, 0.9f, 0.8f);
    private final DefaultToolTip tt;
    private final Consumer<IRange<IQuantity>>[] onChange;

    @SafeVarargs
    public QuantityRangeSelector(Composite parent, FormToolkit toolkit, IRange<IQuantity> fullRange, Consumer<IRange<IQuantity>> ... onChange) {
        super(parent, toolkit);
        this.onChange = onChange;
        this.tt = new DefaultToolTip((Control)this);
        this.setNavigatorRange(fullRange);
    }

    @Override
    protected void renderBackdrop(Graphics2D g2d, int w, int h) {
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.RED, 0.0f, h, this.ORANGE, false));
        g2d.fillRect(0, 0, w, h);
    }

    @Override
    protected void onRangeChange() {
        IRange<IQuantity> range = this.getCurrentRange();
        String text = String.valueOf(((IQuantity)range.getStart()).displayUsing("auto")) + " - ( " + ((IQuantity)range.getExtent()).displayUsing("auto") + " ) - " + ((IQuantity)range.getEnd()).displayUsing("auto");
        this.tt.setText(text);
        Arrays.stream(this.onChange).forEach(l -> l.accept(range));
    }
}

