/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.common;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.ui.common.JComponentNavigator;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.accessibility.MCAccessibleListener;
import com.oracle.jmc.ui.accessibility.SimpleTraverseListener;
import com.oracle.jmc.ui.charts.AWTChartToolkit;
import com.oracle.jmc.ui.charts.IXYDisplayableSet;
import com.oracle.jmc.ui.charts.SubdividedQuantityRange;
import com.oracle.jmc.ui.charts.XYQuantities;
import com.oracle.jmc.ui.misc.MCLayoutFactory;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class Navigator
extends Composite {
    private static final IAttribute<IQuantity> X_START_ATTRIBUTE = JfrAttributes.START_TIME;
    private static final IAttribute<IQuantity> X_END_ATTRIBUTE = JfrAttributes.END_TIME;
    private static final Color SELECTED_TOPCOLOR = new Color(128, 128, 255);
    private static final Color SELECTED_BOTTOMCOLOR = new Color(0, 250, 250);
    private static final Color ALL_TOPCOLOR = Color.RED;
    private static final Color ALL_BOTTOMCOLOR = new Color(252, 128, 3);
    private static final IQuantity MINIMUM_DURATION = UnitLookup.NANOSECONDS.quantity(1000L);
    private static final int RESOLUTION = 800;
    private final JComponentNavigator navigator;
    private volatile IRange<IQuantity> fullRange;
    private double[] allItems;
    private double[] selectedItems;
    private final Button translateBackButton;
    private final Button translateForwardButton;
    private final Button zoomOutButton;
    private final Button zoomInButton;
    private final Button selectAllButton;
    private final Label leftLabel;
    private final Label centerLabel;
    private final Label rightLabel;
    private Runnable navigatorObserver;

    public Navigator(Composite parent, FormToolkit toolkit) {
        super(parent, 0);
        this.setLayout((Layout)MCLayoutFactory.createPackedLayout((int)1, (boolean)true));
        Composite topRow = toolkit.createComposite((Composite)this);
        topRow.setLayout((Layout)new GridLayout(1, true));
        topRow.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.centerLabel = Navigator.createTimeLabel(topRow, toolkit, 0x1000000);
        this.navigator = new NavigatorCanvas(this, toolkit);
        this.navigator.setLayoutData(new GridData(4, 4, true, true));
        Composite bottomRow = toolkit.createComposite((Composite)this);
        GridLayout gridLayout = new GridLayout(7, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        bottomRow.setLayout((Layout)gridLayout);
        bottomRow.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.leftLabel = Navigator.createTimeLabel(bottomRow, toolkit, 16384);
        GridData leftLabelLayoutData = new GridData(16384, 4, true, true);
        leftLabelLayoutData.widthHint = 1000;
        this.leftLabel.setLayoutData((Object)leftLabelLayoutData);
        this.leftLabel.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        this.setData((Widget)this.leftLabel, "start.time");
        this.translateBackButton = this.createTranslateBackward(bottomRow);
        this.translateBackButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.zoomOutButton = this.createZoomOut(bottomRow);
        this.zoomOutButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.selectAllButton = this.createSelectAll(bottomRow);
        this.selectAllButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.zoomInButton = this.createZoomIn(bottomRow);
        this.zoomInButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.translateForwardButton = this.createTranslateForward(bottomRow);
        this.translateForwardButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        Composite rightLabelContainer = toolkit.createComposite(bottomRow, 0);
        GridLayout rightLabelContainerLayout = new GridLayout(2, false);
        rightLabelContainerLayout.marginWidth = 0;
        rightLabelContainerLayout.marginHeight = 0;
        rightLabelContainer.setLayout((Layout)rightLabelContainerLayout);
        GridData rightLabelLayoutData = new GridData(4, 4, true, true);
        rightLabelLayoutData.widthHint = 1000;
        rightLabelContainer.setLayoutData((Object)rightLabelLayoutData);
        Label rightDummyLabel = toolkit.createLabel(rightLabelContainer, null);
        rightDummyLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rightLabel = Navigator.createTimeLabel(rightLabelContainer, toolkit, 131072);
        this.rightLabel.setLayoutData((Object)new GridData(131072, 4, true, true));
        this.rightLabel.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        this.setData((Widget)this.rightLabel, "end.time");
        this.setButtonDecorations();
    }

    private void setData(Widget widget, String id) {
        widget.setData("name", (Object)("navigator." + id));
    }

    private void enableButton(Button button, boolean enabled) {
        if (button != null && !button.isDisposed()) {
            button.setEnabled(enabled);
        }
    }

    private Button createTranslateForward(Composite container) {
        throw new UnsupportedOperationException("Reimplement");
    }

    private Button createTranslateBackward(Composite container) {
        throw new UnsupportedOperationException("Reimplement");
    }

    private Button createZoomIn(Composite container) {
        throw new UnsupportedOperationException("Reimplement");
    }

    private Button createZoomOut(Composite container) {
        throw new UnsupportedOperationException("Reimplement");
    }

    private Button createSelectAll(Composite container) {
        Button button = new Button(container, 0);
        button.setToolTipText(Messages.NAVIGATOR_SELECT_ALL_TEXT);
        this.setData((Widget)button, "select.all");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Navigator.this.navigator.setCurrentRange((IRange<IQuantity>)Navigator.this.fullRange);
            }
        });
        this.hookTimeAccessibility(button);
        return button;
    }

    private void setButtonDecorations() {
        boolean buttonAsText = UIPlugin.getDefault().getPreferenceStore().getBoolean("accessibility.buttonsAsText");
        if (buttonAsText) {
            this.setButtonTexts();
        } else {
            this.setButtonPictures();
        }
    }

    private void setButtonTexts() {
        this.translateBackButton.setImage(null);
        this.translateForwardButton.setImage(null);
        this.zoomOutButton.setImage(null);
        this.zoomInButton.setImage(null);
        this.selectAllButton.setImage(null);
        this.translateBackButton.setText(Messages.NAVIGATOR_MOVE_BACKWARD_TEXT);
        this.translateForwardButton.setText(Messages.NAVIGATOR_MOVE_FORWARD_TEXT);
        this.zoomOutButton.setText(Messages.NAVIGATOR_ZOOM_OUT_TEXT);
        this.zoomInButton.setText(Messages.NAVIGATOR_ZOOM_IN_TEXT);
        this.selectAllButton.setText(Messages.NAVIGATOR_SELECT_ALL_TEXT);
    }

    private void setButtonPictures() {
        this.translateBackButton.setText("");
        this.translateForwardButton.setText("");
        this.zoomOutButton.setText("");
        this.zoomInButton.setText("");
        this.selectAllButton.setText("");
        this.translateBackButton.setImage(UIPlugin.getDefault().getImage("backward_nav.gif"));
        this.translateForwardButton.setImage(UIPlugin.getDefault().getImage("forward_nav.gif"));
        this.zoomOutButton.setImage(UIPlugin.getDefault().getImage("zoom-out-16.png"));
        this.zoomInButton.setImage(UIPlugin.getDefault().getImage("zoom-in-16.png"));
        this.selectAllButton.setImage(UIPlugin.getDefault().getImage("select-all-16.png"));
    }

    private void hookTimeAccessibility(Button button) {
        MCAccessibleListener listener = new MCAccessibleListener();
        listener.setName(button.getToolTipText());
        button.getAccessible().addAccessibleListener((AccessibleListener)listener);
    }

    public void setNavigatorRange(IRange<IQuantity> range) {
        this.fullRange = range;
        this.navigator.setNavigatorRange(range);
    }

    public IRange<IQuantity> getCurrentRange() {
        return this.navigator.getCurrentRange();
    }

    public void setCurrentRange(IRange<IQuantity> range) {
        this.navigator.setCurrentRange(range);
    }

    public void setNavigatorObserver(Runnable navigatorObserver) {
        this.navigatorObserver = navigatorObserver;
    }

    private static Label createTimeLabel(Composite parent, FormToolkit toolkit, int alignMent) {
        Label l = toolkit.createLabel(parent, "-- : -- : --", 0x48 | alignMent);
        l.setLayoutData((Object)new GridData(4, 1024, true, false));
        return l;
    }

    public void setAllItems(IItemCollection allItems) {
        this.allItems = allItems == null ? null : this.countItemsInMaxResolution(allItems);
        this.selectedItems = null;
        this.navigator.invalidateNavigator(true);
        this.navigator.redraw();
    }

    public void setSelectedItems(IItemCollection selectedItems) {
        this.selectedItems = this.countItemsInMaxResolution(selectedItems);
        this.navigator.invalidateNavigator(true);
        this.navigator.redraw();
    }

    private SubdividedQuantityRange getFullRangeAxis(int pixels, int subdividers) {
        return new SubdividedQuantityRange(subdividers, (IQuantity)this.fullRange.getStart(), (IQuantity)this.fullRange.getEnd(), pixels);
    }

    private double[] countItemsInMaxResolution(IItemCollection items) {
        SubdividedQuantityRange fullRangeAxis = this.getFullRangeAxis(800, 1);
        double[] values = new double[800];
        for (IItemIterable next : items) {
            IType type = next.getType();
            IMemberAccessor endAccessor = X_END_ATTRIBUTE.getAccessor(type);
            IMemberAccessor startAccessor = X_START_ATTRIBUTE.getAccessor(type);
            for (IItem item : next) {
                int xPos = (int)fullRangeAxis.getPixel((IQuantity)endAccessor.getMember((Object)item));
                if (xPos < 0) continue;
                if (startAccessor != endAccessor) {
                    int xPosStart = (int)fullRangeAxis.getPixel((IQuantity)startAccessor.getMember((Object)item));
                    if (xPosStart >= values.length) continue;
                    int i = xPosStart;
                    while (i <= Math.min(xPos, values.length - 1)) {
                        int n = i++;
                        values[n] = values[n] + 1.0;
                    }
                    continue;
                }
                if (xPos >= values.length) continue;
                int n = xPos;
                values[n] = values[n] + 1.0;
            }
        }
        int i = 0;
        while (i < values.length) {
            if (values[i] == 0.0) {
                values[i] = Double.NaN;
            }
            ++i;
        }
        return values;
    }

    private class NavigatorCanvas
    extends JComponentNavigator {
        public NavigatorCanvas(Composite parent, FormToolkit toolkit) {
            super(parent, toolkit);
        }

        @Override
        protected void onRangeChange() {
            IRange<IQuantity> currentRange = Navigator.this.navigator.getCurrentRange();
            boolean hasMinBound = Navigator.this.navigator.isLimitingMin();
            boolean hasMaxBound = Navigator.this.navigator.isLimitingMax();
            IQuantity duration = (IQuantity)currentRange.getExtent();
            Navigator.this.enableButton(Navigator.this.translateBackButton, hasMinBound);
            Navigator.this.enableButton(Navigator.this.translateForwardButton, hasMaxBound);
            Navigator.this.enableButton(Navigator.this.zoomOutButton, hasMinBound || hasMaxBound);
            Navigator.this.enableButton(Navigator.this.zoomInButton, duration.compareTo((Object)MINIMUM_DURATION) > 0);
            Navigator.this.enableButton(Navigator.this.selectAllButton, hasMinBound || hasMaxBound);
            Navigator.this.leftLabel.setText(((IQuantity)currentRange.getStart()).displayUsing("auto"));
            Navigator.this.centerLabel.setText(duration.displayUsing("auto"));
            Navigator.this.rightLabel.setText(((IQuantity)currentRange.getEnd()).displayUsing("auto"));
            if (Navigator.this.navigatorObserver != null) {
                Navigator.this.navigatorObserver.run();
            }
        }

        @Override
        protected void renderBackdrop(Graphics2D g2, int width, int height) {
            XYQuantities allQuantities;
            IQuantity maxY;
            g2.fillRect(0, 0, width, height);
            if (Navigator.this.allItems != null && Navigator.this.fullRange != null && (maxY = (allQuantities = XYQuantities.create(null, (double[])Navigator.this.allItems, (IUnit)UnitLookup.NUMBER_UNITY, (SubdividedQuantityRange)Navigator.this.getFullRangeAxis(width, 800))).getMaxY()) != null && maxY.doubleValue() > 0.0) {
                IQuantity minY = maxY.getUnit().quantity(-maxY.doubleValue() / (double)(height - 1));
                SubdividedQuantityRange yRange = new SubdividedQuantityRange(minY, maxY, height, 20);
                allQuantities.setYRange(yRange);
                g2.setPaint(new GradientPaint(0.0f, 0.0f, ALL_BOTTOMCOLOR, 0.0f, height, ALL_TOPCOLOR));
                AWTChartToolkit.drawRightAngleChart((Graphics2D)g2, (IXYDisplayableSet)allQuantities, (int)width, (int)height);
                if (Navigator.this.selectedItems != null) {
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, SELECTED_BOTTOMCOLOR, 0.0f, height, SELECTED_TOPCOLOR));
                    XYQuantities selectedQuantities = XYQuantities.create(null, (double[])Navigator.this.selectedItems, (IUnit)UnitLookup.NUMBER_UNITY, (SubdividedQuantityRange)Navigator.this.getFullRangeAxis(width, 800));
                    selectedQuantities.setYRange(yRange);
                    AWTChartToolkit.drawRightAngleChart((Graphics2D)g2, (IXYDisplayableSet)selectedQuantities, (int)width, (int)height);
                }
            }
        }
    }
}

