/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.common;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IDataPageFactory;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.ui.CoreImages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.logging.Level;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public abstract class LabeledPageFactory
implements IDataPageFactory {
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_ICON = "icon";

    @Override
    public String getName(IState state) {
        String name = state.getAttribute(ATTRIBUTE_NAME);
        return name != null ? name : this.getDefaultName(state);
    }

    protected String getDefaultName(IState state) {
        return Messages.PAGE_UNNAMED;
    }

    @Override
    public String getDescription(IState state) {
        return state.getAttribute(ATTRIBUTE_DESCRIPTION);
    }

    @Override
    public ImageDescriptor getImageDescriptor(IState state) {
        String iconStr = state.getAttribute(ATTRIBUTE_ICON);
        if (iconStr != null) {
            byte[] pngData = Base64.getDecoder().decode(iconStr);
            try {
                return ImageDescriptor.createFromImageData((ImageData)new ImageData((InputStream)new ByteArrayInputStream(pngData)));
            }
            catch (Exception e) {
                FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not load icon for page: " + this.getName(state), e);
            }
        }
        return this.getDefaultImageDescriptor(state);
    }

    protected ImageDescriptor getDefaultImageDescriptor(IState state) {
        return CoreImages.HELP;
    }

    public static void writeLabel(IWritableState to, String name, String description, ImageDescriptor image) {
        to.putString(ATTRIBUTE_NAME, name);
        to.putString(ATTRIBUTE_DESCRIPTION, description);
        if (image != null) {
            try {
                ImageLoader loader = new ImageLoader();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                loader.data = new ImageData[]{image.getImageData()};
                loader.save((OutputStream)out, 5);
                String iconStr = Base64.getEncoder().encodeToString(out.toByteArray());
                to.putString(ATTRIBUTE_ICON, iconStr);
            }
            catch (Exception e) {
                FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not persist icon", e);
            }
        }
    }
}

