/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.common;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class KeyedStream<K, V> {
    private final Stream.Builder<V> builder = Stream.builder();
    private final K key;
    private Stream<V> collected;

    private KeyedStream(K key) {
        this.key = key;
    }

    public K getKey() {
        return this.key;
    }

    public Stream<V> getStream() {
        Stream<V> stream = this.builder.build();
        return this.collected == null ? stream : Stream.concat(this.collected, stream);
    }

    private void collect(Stream<V> c) {
        this.collected = this.collected == null ? c : Stream.concat(this.collected, c);
    }

    private static <K, V> MapBuilder<K, V> combine(MapBuilder<K, V> a, MapBuilder<K, V> b) {
        for (Map.Entry e : b.map.entrySet()) {
            a.map.merge(e.getKey(), e.getValue(), (v1, v2) -> {
                super.collect(v2.getStream());
                return v1;
            });
        }
        return a;
    }

    private static <K, V> Supplier<MapBuilder<K, V>> supplier(Function<V, K> mappingFunction) {
        return () -> new MapBuilder(mappingFunction);
    }

    public static <K, T> Collector<T, ?, Stream<KeyedStream<K, T>>> collector(Function<T, K> mappingFunction) {
        Function<MapBuilder, Stream> f = MapBuilder::build;
        return Collector.of(KeyedStream.supplier(mappingFunction), MapBuilder::add, KeyedStream::combine, f, Collector.Characteristics.UNORDERED);
    }

    /* synthetic */ KeyedStream(Object object, KeyedStream keyedStream) {
        this(object);
    }

    private static class MapBuilder<K, V> {
        final Map<K, KeyedStream<K, V>> map = new HashMap<K, KeyedStream<K, V>>();
        final Function<V, K> mappingFunction;

        MapBuilder(Function<V, K> mappingFunction) {
            this.mappingFunction = mappingFunction;
        }

        void add(V value) {
            this.map.computeIfAbsent(this.mappingFunction.apply(value), key -> new KeyedStream(key, null)).builder.accept(value);
        }

        Stream<KeyedStream<K, V>> build() {
            return this.map.values().stream();
        }
    }
}

