/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.common;

import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.common.ItemHistogram;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;

public class ItemHistogramWithInput {
    private final ItemHistogram histogram;
    private IItemCollection input = ItemCollectionToolkit.EMPTY;

    public ItemHistogramWithInput(ItemHistogram histogram) {
        this.histogram = histogram;
    }

    public void setInput(IItemCollection items) {
        this.input = items;
        ColumnViewer viewer = this.histogram.getManager().getViewer();
        ISelection prevSelection = viewer.getSelection();
        this.histogram.show(items);
        if (viewer.getSelection().equals(prevSelection)) {
            viewer.setSelection(prevSelection);
        }
    }

    public void addListener(Consumer<? super IItemCollection> listener) {
        this.histogram.getManager().getViewer().addSelectionChangedListener(e -> listener.accept(this.getItems()));
    }

    public IItemCollection getItems() {
        ItemHistogram.HistogramSelection selection = this.histogram.getSelection();
        return selection.getRowCount() == 0 ? this.input : selection.getItems();
    }

    public static Consumer<IItemCollection> chain(ItemHistogram source, Consumer<? super IItemCollection> destination, ItemHistogram ... intermediate) {
        ItemHistogramWithInput top;
        ItemHistogramWithInput prev = top = new ItemHistogramWithInput(source);
        ItemHistogram[] itemHistogramArray = intermediate;
        int n = intermediate.length;
        int n2 = 0;
        while (n2 < n) {
            ItemHistogram ih = itemHistogramArray[n2];
            ItemHistogramWithInput current = new ItemHistogramWithInput(ih);
            prev.addListener(current::setInput);
            prev = current;
            ++n2;
        }
        prev.addListener(destination);
        return top::setInput;
    }
}

