/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.common;

import com.oracle.jmc.common.IDisplayable;
import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.LinearKindOfQuantity;
import com.oracle.jmc.common.util.CompositeKey;
import com.oracle.jmc.common.util.TypeHandling;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.ItemIterableToolkit;
import com.oracle.jmc.flightrecorder.ui.common.AggregationGrid;
import com.oracle.jmc.flightrecorder.ui.common.CompositeKeyAccessorFactory;
import com.oracle.jmc.flightrecorder.ui.common.ItemList;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.ui.TypeAppearance;
import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.accessibility.FocusTracker;
import com.oracle.jmc.ui.column.ColumnBuilder;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.IColumn;
import com.oracle.jmc.ui.column.TableSettings;
import com.oracle.jmc.ui.misc.BackgroundFractionDrawer;
import com.oracle.jmc.ui.misc.DelegatingLabelProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

public class ItemHistogram {
    public static final String KEY_COL_ID = "key";
    public static final String COUNT_COL_ID = "count";
    private static final Listener COUNT_DRAWER = BackgroundFractionDrawer.unchecked(AggregationGrid::getCountFraction);
    private final AggregationGrid grid;
    private final ColumnManager columnManager;
    private final IAccessorFactory<?> classifier;

    private ItemHistogram(ColumnManager columnManager, IAccessorFactory<?> classifier, AggregationGrid grid) {
        this.columnManager = columnManager;
        this.grid = grid;
        this.classifier = classifier;
    }

    public ColumnManager getManager() {
        return this.columnManager;
    }

    public HistogramSelection getAllRows() {
        return new HistogramSelection(Stream.of(((Table)this.columnManager.getViewer().getControl()).getItems()).map(ti -> ti.getData()).collect(Collectors.toList()));
    }

    public HistogramSelection getSelection() {
        return new HistogramSelection(((IStructuredSelection)this.columnManager.getViewer().getSelection()).toList());
    }

    public void show(IItemCollection items) {
        this.columnManager.getViewer().setInput((Object)this.grid.buildRows(ItemCollectionToolkit.stream(items), this.classifier));
    }

    /* synthetic */ ItemHistogram(ColumnManager columnManager, IAccessorFactory iAccessorFactory, AggregationGrid aggregationGrid, ItemHistogram itemHistogram) {
        this(columnManager, iAccessorFactory, aggregationGrid);
    }

    public static class CompositeKeyHistogramBuilder {
        private final ItemHistogramBuilder histogramBuilder = new ItemHistogramBuilder();
        private final CompositeKeyAccessorFactory factory = new CompositeKeyAccessorFactory();

        public void addKeyColumn(IAttribute<?> attribute) {
            this.addKeyColumn(ItemList.getColumnId(attribute), attribute.getName(), (IAccessorFactory<?>)attribute);
        }

        public void addKeyColumn(String id, String name, IAccessorFactory<?> keyElementProvider) {
            IMemberAccessor<?, CompositeKey> keyElementAccessor = this.factory.add(keyElementProvider);
            IMemberAccessor rowTokeyElementAccessor = row -> keyElementAccessor.getMember((Object)((CompositeKey)AggregationGrid.getKey(row)));
            this.histogramBuilder.columns.add(new ColumnBuilder(name, id, rowTokeyElementAccessor).build());
        }

        public void addCountColumn() {
            this.histogramBuilder.addCountColumn();
        }

        public void addColumn(String colId, IAggregator<?, ?> a) {
            this.histogramBuilder.addColumn(colId, a);
        }

        public ItemHistogram build(Composite container, TableSettings tableSettings) {
            return this.histogramBuilder.build(container, this.histogramBuilder.columns, this.factory, tableSettings, 2048);
        }

        public ItemHistogram buildWithoutBorder(Composite container, TableSettings tableSettings) {
            return this.histogramBuilder.build(container, this.histogramBuilder.columns, this.factory, tableSettings, 0);
        }
    }

    public static class HistogramSelection {
        private final List<?> selection;

        private HistogramSelection(List<?> selection) {
            this.selection = selection;
        }

        public int getRowCount() {
            return this.selection.size();
        }

        public IItemCollection getItems() {
            List rows = this.selection.stream().map(AggregationGrid::getItems).collect(Collectors.toList());
            return ItemCollectionToolkit.merge(rows::stream);
        }

        public <T> Stream<T> getSelectedRows(BiFunction<Object, IItemCollection, T> rowBuilder) {
            return this.selection.stream().map(row -> rowBuilder.apply(AggregationGrid.getKey(row), AggregationGrid.getItems(row)));
        }
    }

    public static class ItemHistogramBuilder {
        private final AggregationGrid grid = new AggregationGrid();
        private final List<IColumn> columns = new ArrayList<IColumn>();

        public void addCountColumn() {
            this.columns.add(new ColumnBuilder(Messages.COUNT_COLUMN_NAME, ItemHistogram.COUNT_COL_ID, AggregationGrid::getCount).columnDrawer(COUNT_DRAWER).style(131072).build());
        }

        public void addColumn(String colId, IAggregator<?, ?> a) {
            int style = a.getValueType() instanceof LinearKindOfQuantity ? 131072 : 0;
            this.columns.add(new ColumnBuilder(a.getName(), colId, this.grid.addColumn(a)).description(a.getDescription()).style(style).build());
        }

        public <T> void addColumn(IAttribute<T> a) {
            IMemberAccessor anyValueAccessor = row -> ItemCollectionToolkit.stream(AggregationGrid.getItems(row)).flatMap(is -> ItemIterableToolkit.stream(is).map(arg_0 -> ((IMemberAccessor)a.getAccessor(is.getType())).getMember(arg_0))).filter(Objects::nonNull).findAny().orElse(null);
            this.columns.add(new ColumnBuilder(a.getName(), a.getIdentifier(), anyValueAccessor).description(a.getDescription()).build());
        }

        public <T> ItemHistogram build(Composite container, IAttribute<T> classifier, TableSettings tableSettings) {
            return this.build(container, classifier.getName(), (ContentType<? super T>)classifier.getContentType(), (IAccessorFactory<T>)classifier, tableSettings);
        }

        public <T> ItemHistogram buildWithoutBorder(Composite container, IAttribute<T> classifier, TableSettings tableSettings) {
            return this.buildWithoutBorder(container, classifier.getName(), (ContentType<? super T>)classifier.getContentType(), (IAccessorFactory<T>)classifier, tableSettings);
        }

        public <T> ItemHistogram buildWithoutBorder(Composite container, String colLabel, ContentType<? super T> keyType, IAccessorFactory<T> classifier, TableSettings tableSettings) {
            return this.build(container, colLabel, keyType, classifier, tableSettings, 0);
        }

        public <T> ItemHistogram build(Composite container, String colLabel, ContentType<? super T> keyType, IAccessorFactory<T> classifier, TableSettings tableSettings) {
            return this.build(container, colLabel, keyType, classifier, tableSettings, 2048);
        }

        public <T> ItemHistogram build(Composite container, String colLabel, ContentType<? super T> keyType, IAccessorFactory<T> classifier, TableSettings tableSettings, int border) {
            ArrayList<IColumn> columns = new ArrayList<IColumn>();
            IMemberAccessor keyAccessor = AggregationGrid::getKey;
            DelegatingLabelProvider keyLp = new DelegatingLabelProvider((ColumnLabelProvider)new KeyLabelProvider(keyType), keyAccessor);
            columns.add(new ColumnBuilder(colLabel, ItemHistogram.KEY_COL_ID, keyAccessor).labelProvider((ColumnLabelProvider)keyLp).build());
            columns.addAll(this.columns);
            return this.build(container, columns, classifier, tableSettings, border);
        }

        private <T> ItemHistogram build(Composite container, List<IColumn> columns, IAccessorFactory<T> classifier, TableSettings tableSettings, int border) {
            TableViewer tableViewer = new TableViewer(container, 0x10302 | border);
            tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
            if (UIPlugin.getDefault().getAccessibilityMode()) {
                FocusTracker.enableFocusTracking((Composite)tableViewer.getTable());
            }
            return new ItemHistogram(ColumnManager.build((TableViewer)tableViewer, columns, (TableSettings)tableSettings), classifier, this.grid, null);
        }
    }

    private static class KeyLabelProvider
    extends ColumnLabelProvider {
        private final Image image;

        KeyLabelProvider(ContentType<?> ct) {
            this.image = TypeAppearance.getImage((String)ct.getIdentifier());
        }

        public Font getFont(Object key) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }

        public Image getImage(Object key) {
            return this.image;
        }

        public String getText(Object key) {
            if (key instanceof IDisplayable) {
                return ((IDisplayable)key).displayUsing("exact");
            }
            return TypeHandling.getValueString((Object)key);
        }

        public String getToolTipText(Object key) {
            if (key instanceof IDisplayable) {
                return ((IDisplayable)key).displayUsing("verbose");
            }
            return null;
        }
    }
}

